/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.module.attach.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import org.apache.commons.io.FilenameUtils;
import yem.base.common.utils.YEM;

public class AccessoryToolsUtil {
    private static final String[] SPECIAL_SYMBOLS = new String[]{"%", "=", "+", "&"};
    private static boolean isLinux = AccessoryToolsUtil.isOSLinux();
    private String monthStr = AccessoryToolsUtil.getMonthStr();
    protected String realePath;

    public static boolean isLinux() {
        return isLinux;
    }

    public static void uploadAttachments(List<Map<String, Object>> fileInfoList, IFormView view, String attachment, String AttachmentType, Boolean flag) throws IOException {
        IDataModel model = view.getModel();
        String appId = model.getDataEntityType().getAppId();
        String billname = model.getDataEntityType().getName();
        String pkValue = String.valueOf(model.getDataEntity(true).getLong("id"));
        for (Map<String, Object> fileInfo : fileInfoList) {
            String url = (String)fileInfo.get("url");
            String name = (String)fileInfo.get("name");
            url = AccessoryToolsUtil.uploadFileItem(appId, billname, pkValue, name, url);
            fileInfo.put("url", url);
            fileInfo.put("creator", UserServiceHelper.getCurrentUserId());
            fileInfo.put("modifytime", new Date().getTime());
        }
        if (flag.booleanValue()) {
            Map<String, Map<String, Object>> attachmentMap = AccessoryToolsUtil.buildAttachmentMap(fileInfoList, attachment);
            attachmentMap.forEach((uid, value) -> {
                int newRow = model.createNewEntryRow("yem_attachmentinfo_e");
                AccessoryToolsUtil.setAttachmentValues(view, newRow, uid, value, (String)value.get("attachmentpanelKey"), AttachmentType);
            });
        }
        AttachmentServiceHelper.upload((String)billname, (Object)pkValue, (String)attachment, fileInfoList);
        OperationServiceHelper.executeOperate((String)"save", (String)billname, (DynamicObject[])new DynamicObject[]{model.getDataEntity(true)});
    }

    public static String uploadFileItem(String appId, String formId, String pkId, String fileName, String filePath) throws IOException {
        Date today = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
        String NewDateStr = df.format(today);
        String attachmentPath = "/" + RequestContext.get().getTenantId() + "/" + RequestContext.get().getAccountId() + "/" + NewDateStr + "/" + appId + "/" + formId + "/" + pkId + "/attachments/";
        String url = "";
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream in = cache.getInputStream(filePath);
        FileService fs = FileServiceFactory.getAttachmentFileService();
        String path = attachmentPath + fileName;
        FileItem fi = new FileItem(fileName, path, in);
        fi.setCreateNewFileWhenExists(true);
        url = fs.upload(fi);
        if (url == null || "".equals(url)) {
            new Exception("\u9644\u4ef6\u3010" + fileName + "\u3011\u4e0a\u4f20\u5931\u8d25\uff01");
        }
        return url;
    }

    private static void setAttachmentValues(IFormView view, int row, String uid, Map<String, Object> data, String attachmentpanelKey, String AttachmentType) {
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        String billName = dataEntity.getDataEntityType().getName();
        view.getModel().setValue("yem_attachmentname", data.get("name"), row);
        view.getModel().setValue("yem_atturl", (Object)UrlService.getAttachmentFullUrl((String)((String)data.get("url"))), row);
        view.getModel().setValue("yem_panel", (Object)attachmentpanelKey, row);
        view.getModel().setValue("yem_billno", view.getModel().getValue("billno"), row);
        view.getModel().setValue("yem_docid", (Object)billName, row);
        String id = MetadataDao.getIdByNumber((String)billName, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        String docname = formMeta.getName().getLocaleValue();
        view.getModel().setValue("yem_docname", (Object)docname, row);
        view.getModel().setValue("yem_billid", view.getModel().getValue("id"), row);
        view.getModel().setValue("yem_attachedid", (Object)uid, row);
        view.getModel().setValue("yem_uploaddate", data.get("createTime"), row);
        Long currentUserId = UserServiceHelper.getCurrentUserId();
        view.getModel().setValue("yem_attacheduser", (Object)currentUserId, row);
        QFilter qFilter = new QFilter("number", "=", (Object)AttachmentType);
        DynamicObject attachmenttype = BusinessDataServiceHelper.loadSingle((String)"yem_bd_attachmenttype", (QFilter[])qFilter.toArray());
        if (null != attachmenttype) {
            view.getModel().setValue("yem_attachmenttype", (Object)attachmenttype, row);
        } else {
            view.getModel().setValue("yem_attachmenttype", null, row);
        }
    }

    public static Map<String, Map<String, Object>> buildAttachmentMap(List<Map<String, Object>> fileInfoList, String attachment) {
        HashMap<String, Map<String, Object>> attachmentMap = new HashMap<String, Map<String, Object>>();
        for (Map<String, Object> attachmentData : fileInfoList) {
            String uid = (String)attachmentData.get("uid");
            String name = (String)attachmentData.get("name");
            String url = (String)attachmentData.get("url");
            Long createTime = (Long)attachmentData.get("createdate");
            String formattedTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(createTime));
            Object creator = attachmentData.get("creator");
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("name", name);
            dataMap.put("url", url);
            dataMap.put("createTime", formattedTime);
            dataMap.put("creator", creator);
            dataMap.put("attachmentpanelKey", attachment);
            attachmentMap.put(uid, dataMap);
        }
        return attachmentMap;
    }

    public static void uploadAttachments(List<Map<String, Object>> fileInfoList, String appId, DynamicObject dataEntity, String attachment, Map<String, DynamicObject> attachMaping, Boolean flag) throws IOException {
        String billname = dataEntity.getDataEntityType().getName();
        String pkValue = String.valueOf(dataEntity.getLong("id"));
        for (Map<String, Object> fileInfo : fileInfoList) {
            String url = (String)fileInfo.get("url");
            String name = (String)fileInfo.get("name");
            url = AccessoryToolsUtil.uploadFileItem(appId, billname, pkValue, name, url);
            fileInfo.put("url", url);
            fileInfo.put("creator", UserServiceHelper.getCurrentUserId());
            fileInfo.put("modifytime", new Date().getTime());
        }
        if (flag.booleanValue()) {
            Map<String, Map<String, Object>> attachmentMap = AccessoryToolsUtil.buildAttachmentMap(fileInfoList, attachment);
            attachmentMap.forEach((uid, value) -> {
                DynamicObject dynamicObject = (DynamicObject)attachMaping.get(uid);
                AccessoryToolsUtil.setAttachmentValues(dataEntity, uid, value, (String)value.get("attachmentpanelKey"), dynamicObject != null ? dynamicObject.getString("number") : "");
            });
        }
        AttachmentServiceHelper.upload((String)billname, (Object)pkValue, (String)attachment, fileInfoList);
        dataEntity.set("yem_signbackerid", (Object)YEM.getCurrentUserId());
        dataEntity.set("yem_signbackdate", (Object)new Date());
        OperationServiceHelper.executeOperate((String)"save", (String)billname, (DynamicObject[])new DynamicObject[]{dataEntity});
    }

    public static void setAttachmentValues(DynamicObject dataEntity, String uid, Map<String, Object> data, String attachmentpanelKey, String AttachmentType) {
        DynamicObject attachmentinfo = dataEntity.getDynamicObjectCollection("yem_attachmentinfo_e").addNew();
        String str = (String)data.get("createTime");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime = LocalDateTime.parse(str, formatter);
        Date date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        String billName = dataEntity.getDataEntityType().getName();
        attachmentinfo.set("yem_attachmentname", data.get("name"));
        if (!AccessoryToolsUtil.shouldFetchFullUrl((String)data.get("url"))) {
            attachmentinfo.set("yem_atturl", (Object)UrlService.getAttachmentFullUrl((String)((String)data.get("url"))));
        } else {
            attachmentinfo.set("yem_atturl", data.get("url"));
        }
        attachmentinfo.set("yem_panel", (Object)attachmentpanelKey);
        attachmentinfo.set("yem_billno", dataEntity.get("billno"));
        attachmentinfo.set("yem_docid", (Object)billName);
        String id = MetadataDao.getIdByNumber((String)billName, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        String docname = formMeta.getName().getLocaleValue();
        attachmentinfo.set("yem_docname", (Object)docname);
        attachmentinfo.set("yem_billid", dataEntity.get("id"));
        attachmentinfo.set("yem_attachedid", (Object)uid);
        attachmentinfo.set("yem_uploaddate", (Object)date);
        Long currentUserId = UserServiceHelper.getCurrentUserId();
        attachmentinfo.set("yem_attacheduser", (Object)currentUserId);
        QFilter qFilter = new QFilter("number", "=", (Object)AttachmentType);
        DynamicObject attachmenttype = BusinessDataServiceHelper.loadSingle((String)"yem_bd_attachmenttype", (QFilter[])qFilter.toArray());
        if (null != attachmenttype) {
            attachmentinfo.set("yem_attachmenttype", (Object)attachmenttype);
        } else {
            attachmentinfo.set("yem_attachmenttype", null);
        }
    }

    public static boolean shouldFetchFullUrl(String url) {
        if (url == null || url.isEmpty()) {
            return false;
        }
        boolean needsFullUrl = AccessoryToolsUtil.checkBusinessLogic(url);
        return needsFullUrl;
    }

    private static boolean checkBusinessLogic(String url) {
        return url.startsWith("http");
    }

    public static void doPreviewByUrl(String url, String fId, IFormView view) {
        String attachmentFullUrl = AccessoryToolsUtil.getEncreptURL(UrlService.getAttachmentFullUrl((String)URLEncoder.encode(url)));
        if (!(attachmentFullUrl = attachmentFullUrl.replace("download.do", "preview.do")).contains("&kdedcba=")) {
            attachmentFullUrl = EncreptSessionUtils.encryptSession((String)attachmentFullUrl);
        }
        attachmentFullUrl = attachmentFullUrl + "&fId=" + fId;
        String resutlt = AccessoryToolsUtil.sendGet(attachmentFullUrl, null);
        try {
            JSONObject resultMap = (JSONObject)JSON.parse((String)resutlt);
            if (resultMap != null && "error".equals(resultMap.get((Object)"status"))) {
                view.showTipNotification(resultMap.get((Object)"description").toString());
                return;
            }
            if (resultMap != null && "success".equals(resultMap.get((Object)"status"))) {
                attachmentFullUrl = resultMap.get((Object)"url").toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        view.openUrl(attachmentFullUrl);
    }

    private static String getEncreptURL(String url) {
        return EncreptSessionUtils.encryptSession((String)url);
    }

    private static String sendGet(String url, String param) {
        String userAgent = RequestContext.get().getUserAgent();
        StringBuilder result = new StringBuilder();
        String urlNameString = url;
        if (param != null && param.trim().length() > 0) {
            urlNameString = urlNameString + "?" + param;
        }
        BufferedReader in = null;
        HttpURLConnection connection = null;
        InputStream is = null;
        try {
            URL realUrl = new URL(urlNameString);
            connection = (HttpURLConnection)realUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(60000);
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", userAgent);
            connection.connect();
            if (connection.getResponseCode() == 200) {
                String line;
                is = connection.getInputStream();
                in = new BufferedReader(new InputStreamReader(is));
                while ((line = in.readLine()) != null) {
                    result.append(line);
                }
                String string = result.toString();
                return string;
            }
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result.toString();
    }

    public String downloadFile2FileItem(String appId, String formId, String pkId, String fileName, String downloadUrl) throws IOException {
        return AccessoryToolsUtil.uploadFileItem(appId, formId, pkId, fileName, this.downloadFile(fileName, downloadUrl));
    }

    public String downloadFile(String downloadUrl) throws IOException {
        String fileName = FilenameUtils.getName((String)downloadUrl);
        return this.downloadFile(fileName, downloadUrl);
    }

    public String downloadFile(String fileName, String downloadUrl) throws IOException {
        return AccessoryToolsUtil.downloadFile(this.newFile(fileName), downloadUrl);
    }

    public static String downloadFile(File file, String downloadUrl) throws IOException {
        URL url = new URL(downloadUrl);
        URLConnection urlConnection = url.openConnection();
        HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
        httpURLConnection.setConnectTimeout(5000);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
        httpURLConnection.setRequestProperty("Charset", "UTF-8");
        httpURLConnection.connect();
        int fileLength = httpURLConnection.getContentLength();
        System.out.println("\u60a8\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u5927\u5c0f\u4e3a:" + fileLength / 1024 + "K");
        AccessoryToolsUtil.createNewFile(file);
        InputStream inputStream = httpURLConnection.getInputStream();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedInputStream bin = new BufferedInputStream(inputStream);
        int size = 0;
        byte[] buf = new byte[1024];
        while ((size = bin.read(buf)) != -1) {
            fileOutputStream.write(buf, 0, size);
        }
        bin.close();
        fileOutputStream.close();
        return file.getPath();
    }

    public void FileUtil(String formId) {
        String uuid = AccessoryToolsUtil.createUUID();
        this.realePath = isLinux ? String.format("/kingdee/yem/files/%s/%s/%s/", this.monthStr, formId, uuid) : String.format("C:/kingdee/yem/files/%s/%s/%s/", this.monthStr, formId, uuid);
    }

    private static boolean isOSLinux() {
        Properties prop = System.getProperties();
        String os = prop.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("linux") > -1;
    }

    public File newFile(String fileName) {
        return new File(this.realePath + AccessoryToolsUtil.replaceSpeSymbol(fileName));
    }

    public static String replaceSpeSymbol(String str) {
        for (int i = 0; i < SPECIAL_SYMBOLS.length; ++i) {
            if (!str.contains(SPECIAL_SYMBOLS[i])) continue;
            str = str.replace(SPECIAL_SYMBOLS[i], "_");
        }
        return str;
    }

    public static String getMonthStr() {
        return new SimpleDateFormat("yyyyMM").format(new Date());
    }

    public File createNewFile(String fileName) throws IOException {
        File file = this.newFile(fileName);
        AccessoryToolsUtil.createNewFile(file);
        return file;
    }

    public static boolean createNewFile(File file) throws IOException {
        File fileParent = file.getParentFile();
        if (!fileParent.exists()) {
            fileParent.mkdirs();
        }
        boolean created = file.createNewFile();
        if (isLinux) {
            file.setExecutable(true);
            file.setReadable(true);
            file.setWritable(true);
        }
        return created;
    }

    public static String createUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static Map<String, String> getAttachControl(String formName) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formName);
        FormMetadata taskMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List items = taskMeta.getItems();
        HashMap<String, String> attachmentPanelAp = new HashMap<String, String>();
        items.forEach(item -> {
            if (item instanceof AttachmentPanelAp) {
                AttachmentPanelAp attachmentPanel = (AttachmentPanelAp)item;
                attachmentPanelAp.put(attachmentPanel.getKey(), String.valueOf(attachmentPanel.getName()));
            }
        });
        return attachmentPanelAp;
    }
}

