/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.module.iscb.helper;

import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.module.iscb.helper.Api;
import yem.base.common.module.iscb.helper.ApiLog;
import yem.base.common.utils.YEM;

public class ApiHelper {
    private static final String KEY_APIAPP = "yem_base_app";
    private static final String KEY_API = "yem_base_api";
    private boolean exist;
    private String thirdKey;
    private ILocaleString thirdName;
    private Map<String, String> params;
    private Map<String, Api> apis;

    public ApiHelper(String thirdKey) {
        DynamicObject app = BusinessDataServiceHelper.loadSingleFromCache((String)KEY_APIAPP, (QFilter[])new QFilter("number", "=", (Object)thirdKey).toArray());
        if (app != null) {
            this.params = app.getDynamicObjectCollection("yem_params").stream().collect(Collectors.toMap(x -> x.getString("yem_paramkey"), y -> y.getString("yem_paramvalue")));
            QFilter qFilter = new QFilter("group", "=", app.getPkValue());
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            Map datas = BusinessDataServiceHelper.loadFromCache((String)KEY_API, (QFilter[])qFilter.toArray());
            this.apis = datas.values().stream().filter(x -> YEM.isNotEmpty(x.getString("number"))).collect(Collectors.toMap(x -> x.getString("number"), Api::new));
            this.thirdName = app.getLocaleString("name");
            this.exist = true;
        }
        this.thirdKey = thirdKey;
    }

    public boolean isExist() {
        return this.exist;
    }

    public String getThirdKey() {
        return this.thirdKey;
    }

    public ILocaleString getThirdName() {
        return this.thirdName;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getParam(String paramKey) {
        return this.params.getOrDefault(paramKey, "");
    }

    public Map<String, Api> getApis() {
        return this.apis;
    }

    public Api getApi(String apiKey) {
        return this.apis.getOrDefault(apiKey, new Api(null));
    }

    public ApiLog log(Api api) {
        return new ApiLog(api);
    }
}

