/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.module.rate.dynamic;

import com.alibaba.nacos.shaded.com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.plugin.Plugin;

public class RateTendencyFormPlugin
extends AbstractFormPlugin
implements Plugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"yem_sourcecur"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "yem_daterange_startdate": 
            case "yem_daterange_enddate": 
            case "yem_sourcecur": {
                PointLineChart pointLineChart = (PointLineChart)this.getControl("yem_map");
                this.drawChart(pointLineChart);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        PointLineChart pointLineChart = (PointLineChart)this.getControl("yem_map");
        this.drawChart(pointLineChart);
    }

    public void drawChart(PointLineChart pointLineChart) {
        Axis axisX = this.consAxisX(pointLineChart);
        RateTendencyFormPlugin.setStyleX(axisX);
        List<String> dataOnX = this.consDataOnX();
        axisX.setCategorys(dataOnX);
        Axis axisY = this.consAxisY(pointLineChart);
        RateTendencyFormPlugin.setStyleY(axisY);
        DynamicObjectCollection multipleDc = (DynamicObjectCollection)this.getModel().getValue("yem_sourcecur");
        if (multipleDc.isEmpty()) {
            Iterator USD = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("number,name", "=", (Object)"USD")});
            this.getModel().setValue("yem_sourcecur", (Object)new Object[]{USD.getPkValue()});
            this.setLineStyle(pointLineChart, USD.getString("name") + "\u8f6c\u6362\u4eba\u6c11\u5e01\u6c47\u7387", this.constructYData(dataOnX));
        } else {
            for (DynamicObject d : multipleDc) {
                this.setLineStyle(pointLineChart, d.getDynamicObject("fbasedataid").getString("name") + "\u8f6c\u6362\u4eba\u6c11\u5e01\u6c47\u7387", this.constructYData(dataOnX, d.getDynamicObject("fbasedataid")));
            }
        }
        pointLineChart.setMargin(Position.right, "80px");
        pointLineChart.setMargin(Position.top, "80px");
        pointLineChart.setMargin(Position.left, "80px");
        pointLineChart.setLegendPropValue("top", (Object)"8%");
        HashMap legendtextstyle = Maps.newHashMap();
        legendtextstyle.put("fontSize", 18);
        legendtextstyle.put("color", "#000000");
        pointLineChart.setLegendPropValue("textStyle", (Object)legendtextstyle);
        pointLineChart.refresh();
    }

    private static void setStyleY(Axis axisY) {
        HashMap yNameStyle = Maps.newHashMap();
        yNameStyle.put("color", "#000000");
        yNameStyle.put("fontSize", 18);
        axisY.setPropValue("nameTextStyle", (Object)yNameStyle);
    }

    private static void setStyleX(Axis axisX) {
        HashMap nameTextStyle = Maps.newHashMap();
        nameTextStyle.put("color", "#000000");
        nameTextStyle.put("fontStyle", "italic");
        nameTextStyle.put("fontSize", 25);
        axisX.setPropValue("nameTextStyle", (Object)nameTextStyle);
        axisX.setPropValue("nameLocation", (Object)"end");
        axisX.setPropValue("position", (Object)"bottom");
        HashMap axisLabel = Maps.newHashMap();
        HashMap textstyle = Maps.newHashMap();
        textstyle.put("color", "#000000");
        textstyle.put("fontSize", "16");
        axisLabel.put("textStyle", textstyle);
        axisX.setPropValue("axisLabel", (Object)axisLabel);
    }

    private Axis consAxisX(PointLineChart pointLineChart) {
        Axis axis = pointLineChart.createXAxis("\u65e5\u671f", AxisType.category);
        HashMap axisTick = Maps.newHashMap();
        axisTick.put("interval", 1);
        axisTick.put("show", false);
        axisTick.put("grid", Position.left);
        axis.setPropValue("axisTick", (Object)axisTick);
        return axis;
    }

    private Axis consAxisY(PointLineChart pointLineChart) {
        Axis axis = pointLineChart.createYAxis("\u4eba\u540d\u5e01(\u5143)", AxisType.value);
        HashMap axisTick = Maps.newHashMap();
        axis.setPropValue("axisTic", (Object)axisTick.put("show", true));
        HashMap splitLine = Maps.newHashMap();
        HashMap lineStyle = Maps.newHashMap();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", (Object)splitLine);
        axis.setPropValue("interval", (Object)0.5);
        pointLineChart.setShowTooltip(true);
        return axis;
    }

    private List<String> consDataOnX() {
        LocalDate startDay;
        LocalDate endDay;
        DateRangeEdit dateRange = (DateRangeEdit)this.getControl("yem_daterange");
        String startKey = dateRange.getStartDateFieldKey();
        String endKey = dateRange.getEndDateFieldKey();
        Date s = (Date)this.getModel().getValue(startKey);
        Date e = (Date)this.getModel().getValue(endKey);
        if (null == s || null == e) {
            endDay = LocalDate.now();
            startDay = endDay.minus(Period.ofDays(3));
            this.getModel().setValue(startKey, (Object)startDay);
            this.getModel().setValue(endKey, (Object)endDay);
        } else {
            startDay = s.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            endDay = e.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        ArrayList<String> data = new ArrayList<String>();
        long gap = startDay.until(endDay, ChronoUnit.DAYS);
        for (long i = 0L; i <= gap; ++i) {
            LocalDate xDay = startDay.plusDays(i);
            data.add(xDay.toString());
        }
        return data;
    }

    private List<BigDecimal> constructYData(List<String> dataOnX) {
        ArrayList<BigDecimal> dataY = new ArrayList<BigDecimal>();
        for (String datum : dataOnX) {
            DynamicObject data = BusinessDataServiceHelper.loadSingle((String)"yem_com_hisrate", (String)"yem_excval", (QFilter[])new QFilter[]{new QFilter("yem_effectdate", "=", (Object)LocalDate.parse(datum)), new QFilter("yem_org.number", "=", (Object)"USD")});
            if (data != null) {
                dataY.add(data.getBigDecimal("yem_excval"));
                continue;
            }
            dataY.add(null);
        }
        return dataY;
    }

    private List<BigDecimal> constructYData(List<String> dataOnX, DynamicObject d) {
        ArrayList<BigDecimal> dataY = new ArrayList<BigDecimal>();
        for (String datum : dataOnX) {
            DynamicObject data = BusinessDataServiceHelper.loadSingle((String)"yem_com_hisrate", (String)"yem_excval", (QFilter[])new QFilter[]{new QFilter("yem_effectdate", "=", (Object)LocalDate.parse(datum)), new QFilter("yem_org.number", "=", (Object)d.getString("number"))});
            if (data != null) {
                dataY.add(data.getBigDecimal("yem_excval"));
                continue;
            }
            dataY.add(null);
        }
        return dataY;
    }

    private void setLineStyle(PointLineChart pointLineChart, String name, List<BigDecimal> values) {
        LineSeries expireSeries = pointLineChart.createSeries(name);
        Label label = new Label();
        label.setShow(true);
        label.setColor("#000000");
        expireSeries.setLabel(label);
        expireSeries.setItemColor("red");
        expireSeries.setAnimationDuration(2000);
        expireSeries.setData(values.toArray(new Number[0]));
    }
}

