/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.module.rate.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class RateTaskPlugin
extends AbstractTask {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String backGetToken() {
        String url = "https://mid.wmyun.com/admin-api/system/auth/login";
        JSONObject json = new JSONObject();
        json.put("username", (Object)"caapi");
        json.put("password", (Object)"caapi");
        try (CloseableHttpClient hp = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("tenant-id", "1");
            StringEntity reqStr = new StringEntity(json.toJSONString(), "UTF-8");
            httpPost.setEntity((HttpEntity)reqStr);
            try (CloseableHttpResponse rp = hp.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = rp.getEntity();
                if (entity == null) return null;
                String jsonString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                JSONObject rs = JSON.parseObject((String)jsonString);
                if (!rs.containsKey((Object)"data")) return null;
                JSONObject data = rs.getJSONObject("data");
                String string = data.getString("accessToken");
                return string;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u83b7\u53d6 token \u5931\u8d25: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject getMidRs(String token, String currency) {
        String url = "https://mid.wmyun.com/admin-api/ca/realtime-exrate/query";
        JSONObject json = new JSONObject();
        json.put("fromCd", (Object)currency);
        json.put("toCd", (Object)"CNY");
        json.put("exrateDate", (Object)LocalDate.now());
        try (CloseableHttpClient hp = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("tenant-id", "1");
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("Authorization", token);
            StringEntity reqStr = new StringEntity(json.toJSONString(), "UTF-8");
            httpPost.setEntity((HttpEntity)reqStr);
            try (CloseableHttpResponse rp = hp.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = rp.getEntity();
                if (entity == null) return null;
                String jsonString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                JSONObject jSONObject = JSON.parseObject((String)jsonString);
                return jSONObject;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u83b7\u53d6 \u4e2d\u95f4\u4ef7 \u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String token = this.backGetToken();
        DynamicObject[] currentNum = BusinessDataServiceHelper.load((String)"bd_currency", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "!=", (Object)"CNY"), new QFilter("enable", "like", (Object)"1")});
        DynamicObject RMB = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"CNY")});
        DynamicObject rateTable = BusinessDataServiceHelper.loadSingle((String)"bd_exratetable", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"ERT-01")});
        for (DynamicObject datum : currentNum) {
            String curNum = datum.getString("number");
            JSONObject rs = this.getMidRs(token, curNum);
            if (null == rs) continue;
            JSONObject joData = rs.getJSONObject("data");
            DynamicObject histRate = BusinessDataServiceHelper.newDynamicObject((String)"yem_com_hisrate");
            histRate.set("yem_org", (Object)datum);
            histRate.set("yem_tar", (Object)RMB);
            if (null == joData) {
                return;
            }
            Double exchangeRate = joData.getDouble("exchangeRate");
            Double indirect = BigDecimal.ONE.divide(BigDecimal.valueOf(exchangeRate), 10, RoundingMode.HALF_UP).doubleValue();
            histRate.set("yem_excval", (Object)exchangeRate);
            histRate.set("yem_indirectexrate", (Object)indirect);
            histRate.set("yem_precision", (Object)"4");
            histRate.set("yem_effectdate", (Object)joData.getDate("exrateDate"));
            histRate.set("creator", (Object)joData.getDouble("yem_precision"));
            histRate.set("status", (Object)"C");
            histRate.set("enable", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{histRate});
            DynamicObject rate = BusinessDataServiceHelper.newDynamicObject((String)"bd_exrate_tree");
            rate.set("orgcur", (Object)datum);
            rate.set("cur", (Object)RMB);
            rate.set("excval", (Object)exchangeRate);
            rate.set("indirectexrate", (Object)indirect);
            rate.set("precision", (Object)"4");
            rate.set("effectdate", (Object)joData.getDate("exrateDate"));
            rate.set("status", (Object)"C");
            rate.set("enable", (Object)"1");
            rate.set("exctable", (Object)rateTable);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rate});
        }
    }
}

