/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.module.report.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import yem.base.common.utils.YEM;

public class CommonRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_FILTERAP = "reportcommfilterpanelap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        List<String> keys = this.getRptFilterCtrls(BasedataEdit.class);
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (this.isOrg(evt.getProperty())) {
            QFilter qFilter = new QFilter("id", "in", YEM.getUserChangeAbleOrgIds());
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getTreeFilterParameter().getQFilters().add(qFilter);
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        long orgId = YEM.requestContext().getOrgId();
        List<String> keys = this.getRptFilterCtrls(BasedataEdit.class);
        for (String key : keys) {
            DynamicProperty property = dataEntityType.getProperty(key);
            if (!this.isOrg((IDataEntityProperty)property)) continue;
            if (property instanceof BasedataProp) {
                model.setValue(key, (Object)orgId);
                continue;
            }
            if (!(property instanceof MulBasedataProp)) continue;
            model.setValue(key, (Object)new Object[]{orgId});
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        IReportView view = this.getView();
        IDataModel model = this.getModel();
        FilterInfo filterInfo = queryParam.getFilter();
        MainEntityType dataEntityType = model.getDataEntityType();
        ArrayList<String> fieldNames = new ArrayList<String>();
        List<String> keys = this.getRptFilterCtrls();
        for (String key : keys) {
            DynamicProperty iProperty = dataEntityType.getProperty(key);
            if (!this.isMustInput(iProperty) && !this.isOrg((IDataEntityProperty)iProperty) || !this.isNotInput(filterInfo.getValue(key))) continue;
            LocaleString displayName = iProperty.getDisplayName();
            fieldNames.add(displayName == null ? "" : displayName.getLocaleValue());
        }
        if (fieldNames.size() > 0) {
            view.showTipNotification(String.format("\u8bf7\u5148\u9009\u62e9%s\u3002", String.join((CharSequence)"\u3001", fieldNames)));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    private boolean isOrg(IDataEntityProperty iProperty) {
        if (iProperty == null) {
            return false;
        }
        String baseEntityId = "";
        if (iProperty instanceof BasedataProp) {
            BasedataProp property = (BasedataProp)iProperty;
            baseEntityId = property.getBaseEntityId();
        } else if (iProperty instanceof MulBasedataProp) {
            MulBasedataProp property = (MulBasedataProp)iProperty;
            baseEntityId = property.getBaseEntityId();
        }
        return "bos_org".equals(baseEntityId);
    }

    private List<String> getRptFilterCtrls() {
        return this.getRptFilterCtrls(Object.class);
    }

    private <T> List<String> getRptFilterCtrls(Class<T> myClass) {
        ArrayList<String> keys = new ArrayList<String>();
        IReportView view = this.getView();
        Container reportcommfilterpanelap = (Container)view.getControl(KEY_FILTERAP);
        List items = reportcommfilterpanelap.getItems();
        this.getRptFilterCtrls(myClass, keys, items);
        return keys;
    }

    private <T> void getRptFilterCtrls(Class<T> myClass, List<String> keys, List<Control> items) {
        for (Control item : items) {
            String key = item.getKey();
            if (myClass.isInstance(item)) {
                if (item instanceof DateRangeEdit) {
                    DateRangeEdit newItem = (DateRangeEdit)item;
                    keys.add(newItem.getStartDateFieldKey());
                    keys.add(newItem.getEndDateFieldKey());
                    continue;
                }
                keys.add(key);
            }
            if (!(item instanceof Container)) continue;
            this.getRptFilterCtrls(myClass, keys, ((Container)item).getItems());
        }
    }

    private boolean isMustInput(DynamicProperty iProperty) {
        if (iProperty instanceof FieldProp) {
            FieldProp property = (FieldProp)iProperty;
            return property.isMustInput();
        }
        if (iProperty instanceof BasedataProp) {
            BasedataProp property = (BasedataProp)iProperty;
            return property.isMustInput();
        }
        if (iProperty instanceof MulBasedataProp) {
            MulBasedataProp property = (MulBasedataProp)iProperty;
            return property.isMustInput();
        }
        return false;
    }

    private boolean isNotInput(Object propValue) {
        if (propValue == null) {
            return true;
        }
        if (propValue instanceof BigDecimal && ((BigDecimal)propValue).compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        if (propValue instanceof String && ((String)propValue).isEmpty()) {
            return true;
        }
        if (propValue instanceof Integer && (Integer)propValue == 0) {
            return true;
        }
        if (propValue instanceof Long && (Long)propValue == 0L) {
            return true;
        }
        return propValue instanceof DynamicObjectCollection && ((DynamicObjectCollection)propValue).size() == 0;
    }
}

