/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.module.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.MergeColumnRule;
import kd.bos.report.events.ReportExportInitializeEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.YEM;

public class MergeRptPlugin
extends AbstractReportFormPlugin {
    private List<Map<String, List<String>>> MERGE_RULES;
    private List<String> MERGE_COLUMN;
    private Map<String, List<String>> PACKAGE_MERGE;

    public void initMerge() {
        this.MERGE_RULES = new ArrayList<Map<String, List<String>>>();
        this.MERGE_COLUMN = new ArrayList<String>();
        this.PACKAGE_MERGE = new HashMap<String, List<String>>();
        String entityId = this.getView().getEntityId();
        String billKey = "yem_com_reportrpt".equals(entityId) ? "yem_com_repmergedata" : "yem_com_repmerge";
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String customParam = (String)showParameter.getCustomParam("reportName");
        QFilter qFilter = "yem_com_reportrpt".equals(entityId) ? new QFilter("number", "=", (Object)customParam) : new QFilter("yem_bill", "=", (Object)entityId);
        DynamicObject repmerge = BusinessDataServiceHelper.loadSingle((String)billKey, (String)"id", (QFilter[])new QFilter[]{qFilter, new QFilter("enable", "=", (Object)"1")});
        if (repmerge != null) {
            repmerge = BusinessDataServiceHelper.loadSingleFromCache((Object)repmerge.getLong("id"), (String)repmerge.getDynamicObjectType().getName());
            DynamicObjectCollection dimensionentry = repmerge.getDynamicObjectCollection("yem_com_dimensionentry");
            for (DynamicObject dimension : dimensionentry) {
                List basiskey = dimension.getDynamicObjectCollection("yem_com_basisentry").stream().map(x -> x.getString("yem_basiskey")).distinct().collect(Collectors.toList());
                DynamicObjectCollection mergeentry = dimension.getDynamicObjectCollection("yem_com_mergeentry");
                for (DynamicObject merge : mergeentry) {
                    this.addPublicMerge(merge.getString("yem_mergekey"), String.join((CharSequence)",", basiskey));
                }
            }
        }
    }

    public void addPublicMerge(String mergekey, String basiskey) {
        if (YEM.isEmpty(mergekey)) {
            return;
        }
        this.MERGE_COLUMN.add(mergekey);
        HashMap<String, List<String>> mergeRule = new HashMap<String, List<String>>();
        String[] split = basiskey.split(",");
        List<String> group = Arrays.asList(split);
        mergeRule.put("group", group);
        ArrayList<String> column = new ArrayList<String>();
        column.add(mergekey);
        mergeRule.put("column", column);
        this.MERGE_RULES.add(mergeRule);
        for (String groupKey : group) {
            List<String> columnsByFiled = new ArrayList<String>();
            if (this.PACKAGE_MERGE.containsKey(groupKey)) {
                columnsByFiled = this.PACKAGE_MERGE.get(groupKey);
            }
            if (!columnsByFiled.contains(mergekey)) {
                columnsByFiled.add(mergekey);
            }
            this.PACKAGE_MERGE.put(groupKey, columnsByFiled);
        }
    }

    public void setMergeColums(List<String> columns) {
        this.initMerge();
        columns.addAll(this.MERGE_COLUMN);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        this.initMerge();
        ReportColumn reportColumn = (ReportColumn)packageDataEvent.getSource();
        String fieldKey = reportColumn.getFieldKey();
        if (this.PACKAGE_MERGE.containsKey(fieldKey)) {
            List<String> keys = this.PACKAGE_MERGE.get(fieldKey);
            for (String key : keys) {
                this.merges(packageDataEvent, key, fieldKey);
            }
        }
    }

    public void merges(PackageDataEvent packageDataEvent, String groupKey, String fieldKey) {
        boolean isnull;
        Object data = packageDataEvent.getFormatValue();
        String nextData = this.getPageCache().get(groupKey + fieldKey);
        boolean bl = isnull = YEM.isEmpty(data) && YEM.isEmpty(nextData);
        if (isnull || nextData != null && !nextData.equals(data)) {
            packageDataEvent.getNoMergeKey().add(groupKey);
        }
        if (YEM.isNotEmpty(data)) {
            this.getPageCache().put(groupKey + fieldKey, data.toString());
        }
    }

    public void exportInitialize(ReportExportInitializeEvent event) {
        this.initMerge();
        ArrayList<MergeColumnRule> rules = new ArrayList<MergeColumnRule>();
        for (Map<String, List<String>> merge : this.MERGE_RULES) {
            rules.add(new MergeColumnRule(merge.get("group"), merge.get("column")));
        }
        event.setMergeColumnRules(rules);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
    }
}

