/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.module.report.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import yem.base.common.de.meta.utils.MetaPropertyHelper;
import yem.base.common.utils.YEM;

public class ReportDataBillPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        TextEdit basisname = (TextEdit)this.getControl("yem_basisname");
        basisname.addClickListener((ClickListener)this);
        TextEdit mergename = (TextEdit)this.getControl("yem_mergename");
        mergename.addClickListener((ClickListener)this);
        TextEdit fieldname = (TextEdit)this.getControl("yem_fieldname");
        fieldname.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "yem_basisname": 
            case "yem_mergename": {
                this.showFormEntry(key);
                break;
            }
            case "yem_fieldname": {
                DynamicObject bill = (DynamicObject)this.getModel().getValue("yem_bill");
                if (bill != null) {
                    String formKey = bill.getString("number");
                    ArrayList<String> entityKeys = new ArrayList<String>();
                    entityKeys.add(formKey);
                    MetaPropertyHelper.showPropertySelect((AbstractFormPlugin)this, key, formKey, true, entityKeys);
                    break;
                }
                this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u5bf9\u8c61\uff01");
            }
        }
    }

    public void showFormEntry(String key) {
        IFormView view = this.getView();
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("yem_com_entryinfor");
        fsp.setCustomParam("isMulti", (Object)true);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        view.showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "yem_basisname": {
                this.colsedEntryValue(e.getReturnData(), "yem_com_basisentry", "yem_basisname", "yem_basiskey");
                break;
            }
            case "yem_mergename": {
                this.colsedEntryValue(e.getReturnData(), "yem_com_mergeentry", "yem_mergename", "yem_mergekey");
                break;
            }
            case "yem_fieldname": {
                this.callBackEntryDataSample(this.getModel(), e);
            }
        }
    }

    public void callBackEntryDataSample(IDataModel model, ClosedCallBackEvent e) {
        DynamicObjectCollection data = (DynamicObjectCollection)e.getReturnData();
        if (YEM.isNotEmpty(data)) {
            HashSet<String> exsistCols = new HashSet<String>();
            for (DynamicObject row : model.getEntryEntity("yem_com_displayentry")) {
                exsistCols.add(row.getString("yem_fieldkey"));
            }
            for (int i = 0; i < data.size(); ++i) {
                DynamicObject info = (DynamicObject)data.get(i);
                String fullnumber = info.getString("yem_fullnumber");
                String fullname = info.getString("yem_fullname");
                String datatype = info.getString("yem_datatype");
                String basedatakey = info.getString("yem_basedatakey");
                if (exsistCols.contains(fullnumber)) continue;
                int index = i == 0 ? model.getEntryCurrentRowIndex("yem_com_displayentry") : model.createNewEntryRow("yem_com_displayentry");
                model.setValue("yem_fieldkey", (Object)fullnumber, index);
                model.setValue("yem_fieldname", (Object)fullname, index);
                model.setValue("yem_fieldtype", (Object)datatype, index);
                model.setValue("yem_basedatakey", (Object)basedatakey, index);
            }
        }
    }

    public void colsedEntryValue(Object returnData, String entryKey, String fieldName, String fieldKey) {
        IDataModel model = this.getModel();
        int parentIndex = model.getEntryCurrentRowIndex("yem_com_dimensionentry");
        DynamicObjectCollection data = (DynamicObjectCollection)returnData;
        if (YEM.isNotEmpty(data)) {
            HashSet<String> exsistCols = new HashSet<String>();
            for (DynamicObject row : model.getEntryRowEntity("yem_com_dimensionentry", parentIndex).getDynamicObjectCollection(entryKey)) {
                exsistCols.add(row.getString(fieldKey));
            }
            for (int i = 0; i < data.size(); ++i) {
                DynamicObject info = (DynamicObject)data.get(i);
                String number = info.getString("yem_number");
                String name = info.getString("yem_name");
                if (exsistCols.contains(number)) continue;
                int index = i == 0 ? model.getEntryCurrentRowIndex(entryKey) : model.createNewEntryRow(entryKey);
                model.setValue(fieldKey, (Object)number, index, parentIndex);
                model.setValue(fieldName, (Object)name, index, parentIndex);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldname;
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if ("yem_fieldname".equals(name) && YEM.isEmpty(fieldname = (String)this.getModel().getValue("yem_fieldname", rowIndex))) {
            this.getModel().setValue("yem_fieldkey", null, rowIndex);
            this.getModel().setValue("yem_fieldtype", null, rowIndex);
            this.getModel().setValue("yem_basedatakey", null, rowIndex);
        }
    }
}

