/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.module.report.form;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import yem.base.common.utils.RptUtil;
import yem.base.common.utils.YEM;

public class ReportRptListPlugin
extends AbstractReportListDataPlugin {
    private String reportName = "";

    public DataSet query(ReportQueryParam param, Object o) throws Throwable {
        return this.query(param);
    }

    public DataSet query(ReportQueryParam param) {
        FilterInfo filter = param.getFilter();
        this.reportName = filter.getString("yem_reportname");
        DynamicObject repmerge = BusinessDataServiceHelper.loadSingle((String)"yem_com_repmergedata", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.reportName), new QFilter("enable", "=", (Object)"1")});
        DataSet dataSet = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "bos_org", "id", null);
        if (repmerge != null) {
            repmerge = BusinessDataServiceHelper.loadSingleFromCache((Object)repmerge.getLong("id"), (String)"yem_com_repmergedata");
            DynamicObjectCollection entryRow = repmerge.getDynamicObjectCollection("yem_com_displayentry");
            List fieldkey = entryRow.stream().map(x -> x.getString("yem_fieldkey")).collect(Collectors.toList());
            DynamicObject bill = repmerge.getDynamicObject("yem_bill");
            dataSet = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), bill.getString("number"), String.join((CharSequence)",", fieldkey), null);
            List fieldkeyList = repmerge.getDynamicObjectCollection("yem_com_displayentry").stream().map(x -> x.getString("yem_fieldkey")).collect(Collectors.toList());
            DynamicObject yem_bill = repmerge.getDynamicObject("yem_bill");
            String billKey = yem_bill.getString("number");
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)billKey);
            DataEntityPropertyCollection properties = MetadataServiceHelper.getDataEntityType((String)billKey).getProperties();
            DynamicObjectCollection col_s = ORM.create().toPlainDynamicObjectCollection(dataSet.copy());
            for (DynamicObject entry : col_s) {
                for (IDataEntityProperty property : properties) {
                    if (!(property instanceof ComboProp) || !fieldkeyList.contains(property.getName())) continue;
                    ComboProp ComboProp2 = (ComboProp)type.findProperty(property.getName());
                    List comboItems = ComboProp2.getComboItems();
                    Map<Object, Object> map = comboItems.stream().collect(Collectors.toMap(ValueMapItem::getValue, ValueMapItem::getName));
                    LocaleString value = map.containsKey(entry.get(property.getName())) ? (LocaleString)map.get(entry.get(property.getName())) : null;
                    entry.set(property.getName(), (Object)value);
                }
            }
            dataSet = RptUtil.plainDataSet(((Object)((Object)this)).getClass().getName(), dataSet, col_s);
        }
        return dataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        DynamicObject repmerge = BusinessDataServiceHelper.loadSingle((String)"yem_com_repmergedata", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.reportName), new QFilter("enable", "=", (Object)"1")});
        if (repmerge != null) {
            repmerge = BusinessDataServiceHelper.loadSingleFromCache((Object)repmerge.getLong("id"), (String)"yem_com_repmergedata");
            DynamicObject yem_bill = repmerge.getDynamicObject("yem_bill");
            String billKey = yem_bill.getString("number");
            DynamicObjectCollection entryRow = repmerge.getDynamicObjectCollection("yem_com_displayentry");
            HashMap mapGroup = new HashMap();
            List doubleheadnameList = entryRow.stream().filter(x -> YEM.isNotEmpty(x.getString("yem_doubleheadname"))).map(x -> x.getString("yem_doubleheadname")).distinct().collect(Collectors.toList());
            Boolean isdoublehead = repmerge.getBoolean("yem_isdoublehead");
            if (isdoublehead.booleanValue()) {
                for (int i = 0; i < doubleheadnameList.size(); ++i) {
                    ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
                    reportColumnGroup.setFieldKey("yem_isdoublehead" + i + 1);
                    reportColumnGroup.setCaption(new LocaleString((String)doubleheadnameList.get(i)));
                    mapGroup.put(doubleheadnameList.get(i), reportColumnGroup);
                }
            }
            for (DynamicObject entity : entryRow) {
                String fieldtype = entity.getString("yem_fieldtype");
                String fieldkey = entity.getString("yem_fieldkey");
                String doubleheadname = entity.getString("yem_doubleheadname");
                String fieldType = "";
                String currKey = "";
                switch (fieldtype) {
                    case "TextProp": {
                        fieldType = "text";
                        break;
                    }
                    case "BigIntProp": {
                        fieldType = "bigint";
                        break;
                    }
                    case "QtyProp": {
                        fieldType = "qty";
                        break;
                    }
                    case "AmountProp": {
                        AmountProp property = (AmountProp)MetadataServiceHelper.getDataEntityType((String)billKey).getProperty(fieldkey);
                        currKey = property.getControlPropName();
                        fieldType = "amount";
                        break;
                    }
                    case "PriceProp": {
                        AmountProp priceproperty = (AmountProp)MetadataServiceHelper.getDataEntityType((String)billKey).getProperty(fieldkey);
                        currKey = priceproperty.getControlPropName();
                        fieldType = "price";
                        break;
                    }
                    case "ComboProp": {
                        fieldType = "combofield";
                        break;
                    }
                    case "BooleanProp": {
                        fieldType = "checkbox";
                        break;
                    }
                    case "DecimalProp": {
                        fieldType = "decimal";
                        break;
                    }
                    case "DateProp": {
                        fieldType = "date";
                        break;
                    }
                    case "OrgProp": 
                    case "BasedataProp": 
                    case "MaterielProp": {
                        fieldType = "basedata";
                        break;
                    }
                    case "UnitProp": {
                        fieldType = "unit";
                        break;
                    }
                    case "CurrencyProp": {
                        fieldType = "currency";
                    }
                }
                if (!YEM.isNotEmpty(fieldType)) continue;
                ReportColumn column = this.createReportColumn(fieldkey, entity.getString("yem_fieldname"), fieldType, entity.getString("yem_basedatakey"), currKey);
                if (YEM.isNotEmpty(doubleheadname) && isdoublehead.booleanValue()) {
                    ReportColumnGroup reportColumnGroup = (ReportColumnGroup)mapGroup.get(doubleheadname);
                    reportColumnGroup.getChildren().add(column);
                    continue;
                }
                columns.add((AbstractReportColumn)column);
            }
            if (isdoublehead.booleanValue()) {
                for (String key : mapGroup.keySet()) {
                    columns.add((AbstractReportColumn)mapGroup.get(key));
                }
            }
        }
        return columns;
    }

    private ReportColumn createReportColumn(String fieldkey, String fieldname, String fieldtype, String basedatakey, String currKey) {
        ReportColumn rptColumn = new ReportColumn();
        if ("basedata".equals(fieldtype) || "unit".equals(fieldtype)) {
            basedatakey = basedatakey.substring(basedatakey.indexOf("\uff08") + 1, basedatakey.indexOf("\uff09"));
            rptColumn = ReportColumn.createBaseDataColumn((String)fieldkey, (String)basedatakey);
        } else if ("currency".equals(fieldtype)) {
            rptColumn = ReportColumn.createCurrencyColumn((String)fieldkey);
        } else if ("amount".equals(fieldtype) || "price".equals(fieldtype)) {
            rptColumn.setCurrencyField(currKey);
        }
        rptColumn.setFieldKey(fieldkey);
        rptColumn.setCaption(new LocaleString(fieldname));
        rptColumn.setFieldType(fieldtype);
        return rptColumn;
    }
}

