/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;

public class BigDecimalUtils {
    public static BigDecimal zero = BigDecimal.ZERO;
    public static BigDecimal one = BigDecimal.ONE;
    public static BigDecimal ten = BigDecimal.TEN;
    public static BigDecimal one_handred = new BigDecimal("100");
    public static BigDecimal one_handred_ten = new BigDecimal("110");
    public static BigDecimal one_thousand = new BigDecimal("1000");
    public static BigDecimal ten_thousand = new BigDecimal("10000");
    public static BigDecimal one_million = new BigDecimal("1000000");

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            return zero;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Integer) {
            return new BigDecimal(((Integer)obj).toString());
        }
        if (obj instanceof Long) {
            return new BigDecimal(((Long)obj).toString());
        }
        if (obj instanceof Double) {
            return BigDecimal.valueOf((Double)obj);
        }
        if (obj.toString() == null) {
            return zero;
        }
        String str = obj.toString().trim();
        if (str.toLowerCase().contains("e")) {
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException e) {
                return zero;
            }
        }
        if (str.matches("^[+-]?\\d+[.\\d]?\\d*+$")) {
            return new BigDecimal(str);
        }
        try {
            DecimalFormat df = new DecimalFormat("#,###.##");
            df.setParseBigDecimal(true);
            return (BigDecimal)df.parse(str);
        }
        catch (ParseException e) {
            return zero;
        }
    }

    public static BigDecimal div(Object a, Object b, int scale) {
        BigDecimal aVal = BigDecimalUtils.toBigDecimal(a);
        BigDecimal bVal = BigDecimalUtils.toBigDecimal(b);
        if (bVal.compareTo(zero) == 0) {
            return zero;
        }
        return aVal.divide(bVal, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(BigDecimal a, BigDecimal b, int scale) {
        BigDecimal aVal = BigDecimalUtils.toBigDecimal(a);
        BigDecimal bVal = BigDecimalUtils.toBigDecimal(b);
        if (bVal.compareTo(zero) == 0) {
            return zero;
        }
        return aVal.divide(bVal, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal multiply(Object a, Object b, int scale) {
        BigDecimal aVal = BigDecimalUtils.toBigDecimal(a);
        BigDecimal bVal = BigDecimalUtils.toBigDecimal(b);
        return aVal.multiply(bVal).setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal multiply(BigDecimal a, BigDecimal b, int scale) {
        BigDecimal aVal = BigDecimalUtils.toBigDecimal(a);
        BigDecimal bVal = BigDecimalUtils.toBigDecimal(b);
        return aVal.multiply(bVal).setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal add(Object a, Object b, int scale) {
        BigDecimal aVal = BigDecimalUtils.toBigDecimal(a);
        BigDecimal bVal = BigDecimalUtils.toBigDecimal(b);
        return aVal.add(bVal).setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal add(BigDecimal a, BigDecimal b, int scale) {
        BigDecimal aVal = BigDecimalUtils.toBigDecimal(a);
        BigDecimal bVal = BigDecimalUtils.toBigDecimal(b);
        return aVal.add(bVal).setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal sub(Object a, Object b, int scale) {
        BigDecimal aVal = BigDecimalUtils.toBigDecimal(a);
        BigDecimal bVal = BigDecimalUtils.toBigDecimal(b);
        return aVal.subtract(bVal).setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal sub(BigDecimal a, BigDecimal b, int scale) {
        BigDecimal aVal = BigDecimalUtils.toBigDecimal(a);
        BigDecimal bVal = BigDecimalUtils.toBigDecimal(b);
        return aVal.subtract(bVal).setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal addOne(Object a, int scale) {
        return BigDecimalUtils.add(a, (Object)one, scale);
    }

    public static BigDecimal subOne(Object a, int scale) {
        return BigDecimalUtils.sub(a, (Object)one, scale);
    }

    public static String digitCapital(Object obj) {
        String p;
        String[] fraction = new String[]{"\u89d2", "\u5206"};
        String[] digit = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[][] unit = new String[][]{{"\u5143", "\u4e07", "\u4ebf"}, {"", "\u62fe", "\u4f70", "\u4edf"}};
        double n = BigDecimalUtils.toBigDecimal(obj).doubleValue();
        String head = n < 0.0 ? "\u8d1f" : "";
        n = Math.abs(n);
        String s = "";
        BigDecimal bigDecimal = new BigDecimal(Double.valueOf(n).toString());
        String nStr = bigDecimal.toString();
        String[] split = nStr.split("\\.");
        if (split.length > 1) {
            String decimalStr = split[1];
            if (decimalStr.length() > 2) {
                decimalStr = decimalStr.substring(0, 2);
            }
            int integer = Integer.parseInt(decimalStr);
            p = "";
            for (int i = 0; i < decimalStr.length() && i < fraction.length; ++i) {
                p = digit[integer % 10] + fraction[decimalStr.length() - i - 1] + p;
                integer /= 10;
            }
            s = p.replaceAll("(\u96f6.)+", "") + s;
        }
        if (s.isEmpty()) {
            s = "\u6574";
        }
        int integerPart = (int)Math.floor(n);
        for (int i = 0; i < unit[0].length && integerPart > 0; ++i) {
            p = "";
            for (int j = 0; j < unit[1].length && n > 0.0; ++j) {
                p = digit[integerPart % 10] + unit[1][j] + p;
                integerPart /= 10;
            }
            s = p.replaceAll("(\u96f6.)*\u96f6$", "").replaceAll("^$", "\u96f6") + unit[0][i] + s;
        }
        return head + s.replaceAll("(\u96f6.)*\u96f6\u5143", "\u5143").replaceFirst("(\u96f6.)+", "").replaceAll("(\u96f6.)+", "\u96f6").replaceAll("^\u6574$", "\u96f6\u5143\u6574");
    }

    public static BigDecimal up(Object obj, int scale) {
        return BigDecimalUtils.toBigDecimal(obj).setScale(scale, RoundingMode.UP);
    }

    public static BigDecimal down(Object obj, int scale) {
        return BigDecimalUtils.toBigDecimal(obj).setScale(scale, RoundingMode.DOWN);
    }

    public static BigDecimal ceil(Object obj, int scale) {
        return BigDecimalUtils.toBigDecimal(obj).setScale(scale, RoundingMode.CEILING);
    }

    public static BigDecimal floor(Object obj, int scale) {
        return BigDecimalUtils.toBigDecimal(obj).setScale(scale, RoundingMode.FLOOR);
    }
}

