/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.utils;

public class CnUpperCaser {
    private static final String[] NUMBERS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] IUNIT = new String[]{"\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] DUNIT = new String[]{"\u89d2", "\u5206", "\u5398"};

    public static String getCnString(String str) {
        String decimalStr;
        String integerStr;
        if ((str = str.replaceAll(",", "")).indexOf(".") > 0) {
            integerStr = str.substring(0, str.indexOf("."));
            decimalStr = str.substring(str.indexOf(".") + 1);
        } else if (str.indexOf(".") == 0) {
            integerStr = "";
            decimalStr = str.substring(1);
        } else {
            if (str.equals("0E-10")) {
                return "\u96f6\u5143\u6574";
            }
            integerStr = str;
            decimalStr = "00";
        }
        if (!integerStr.equals("") && !integerStr.equals("0E-10")) {
            try {
                integerStr = Long.toString(Long.parseLong(integerStr));
            }
            catch (NumberFormatException e) {
                str = "\u8d85\u51fa\u5904\u7406\u80fd\u529b\uff1a" + str;
                return str;
            }
            if (integerStr.equals("0")) {
                integerStr = "";
            }
        }
        if (integerStr.length() > IUNIT.length) {
            str = "\u8d85\u51fa\u5904\u7406\u80fd\u529b\uff1a" + str;
            return str;
        }
        int[] integers = CnUpperCaser.toArray(integerStr);
        boolean isMust5 = CnUpperCaser.isMust5(integerStr);
        int[] decimals = CnUpperCaser.toArray(decimalStr);
        if (decimals.length < 2) {
            return CnUpperCaser.getChineseInteger(integers, isMust5) + "\u6574";
        }
        if (decimals[1] == 0 && decimals[0] == 0) {
            return CnUpperCaser.getChineseInteger(integers, isMust5) + "\u6574";
        }
        if (decimals[1] == 0 && decimals[0] != 0) {
            return CnUpperCaser.getChineseInteger(integers, isMust5) + CnUpperCaser.getChineseDecimal(decimals) + "\u6574";
        }
        return CnUpperCaser.getChineseInteger(integers, isMust5) + CnUpperCaser.getChineseDecimal(decimals);
    }

    private static int[] toArray(String number) {
        int[] array = new int[number.length()];
        for (int i = 0; i < number.length(); ++i) {
            array[i] = Integer.parseInt(number.substring(i, i + 1));
        }
        return array;
    }

    private static String getChineseInteger(int[] integers, boolean isMust5) {
        StringBuffer chineseInteger = new StringBuffer("");
        int length = integers.length;
        for (int i = 0; i < length; ++i) {
            String key = "";
            if (integers[i] == 0) {
                if (length - i == 13) {
                    key = IUNIT[4];
                } else if (length - i == 9) {
                    key = IUNIT[8];
                } else if (length - i == 5 && isMust5) {
                    key = IUNIT[4];
                } else if (length - i == 1) {
                    key = IUNIT[0];
                }
                if (length - i > 1 && integers[i + 1] != 0) {
                    key = key + NUMBERS[0];
                }
            }
            chineseInteger.append(integers[i] == 0 ? key : NUMBERS[integers[i]] + IUNIT[length - i - 1]);
        }
        return chineseInteger.toString();
    }

    private static String getChineseDecimal(int[] decimals) {
        StringBuffer chineseDecimal = new StringBuffer("");
        for (int i = 0; i < decimals.length && i != 3; ++i) {
            chineseDecimal.append(decimals[i] == 0 ? "" : NUMBERS[decimals[i]] + DUNIT[i]);
        }
        return chineseDecimal.toString();
    }

    private static boolean isMust5(String integerStr) {
        int length = integerStr.length();
        if (length > 4) {
            String subInteger = "";
            subInteger = length > 8 ? integerStr.substring(length - 8, length - 4) : integerStr.substring(0, length - 4);
            return Integer.parseInt(subInteger) > 0;
        }
        return false;
    }
}

