/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static final String FORMAT_YMD = "yyyy-MM-dd";
    public static final String FORMAT_YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_yyyyMMdd = "yyyyMMdd";
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat formatHms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String formatDate(Date date, String format) {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(format);
        return simpleFormat.format(date);
    }

    public static String formatDate(Date date) {
        String datestr = "";
        if (date != null) {
            datestr = format.format(date);
        }
        return datestr;
    }

    public static String formatDateHms(Date date) {
        String datestr = "";
        if (date != null) {
            datestr = formatHms.format(date);
        }
        return datestr;
    }

    public static Date parseDate(String datestr) {
        Date date = null;
        if (datestr != null && !datestr.isEmpty() && !"null".equals(datestr)) {
            try {
                date = format.parse(datestr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return date;
    }

    public static Date parseDateHms(String datestr) {
        Date date = null;
        if (datestr != null && !datestr.isEmpty() && !"null".equals(datestr)) {
            try {
                date = formatHms.parse(datestr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return date;
    }

    public static int countDays(Date begin, Date end) {
        return (int)((end.getTime() - begin.getTime()) / 86400000L);
    }

    public static int countHours(Date begin, Date end) {
        return (int)((end.getTime() - begin.getTime()) / 3600000L);
    }

    public static int countActualDays(Date begin, Date end) {
        LocalDate start = begin.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate over = end.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return (int)(over.toEpochDay() - start.toEpochDay() + 1L);
    }

    public static int countMonth(Date begin, Date end) {
        Calendar beginIns = Calendar.getInstance();
        beginIns.setTime(begin);
        Calendar endIns = Calendar.getInstance();
        endIns.setTime(end);
        int diffYear = endIns.get(1) - beginIns.get(1);
        int deffMonth = diffYear * 12 + endIns.get(2) - beginIns.get(2);
        return deffMonth;
    }

    public static Date addDays(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static Date addMonth(Date date, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        calendar.add(2, month);
        return calendar.getTime();
    }

    public static Date getQuarterDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        calendar.add(2, -3);
        return calendar.getTime();
    }

    public static Date cleanDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getCurrYearFirst() {
        Calendar currCal = Calendar.getInstance();
        int currentYear = currCal.get(1);
        return DateUtil.getYearFirst(currentYear);
    }

    public static Date getCurrYearLast() {
        Calendar currCal = Calendar.getInstance();
        int currentYear = currCal.get(1);
        currCal.set(currentYear, 11, 31, 23, 59, 59);
        return currCal.getTime();
    }

    public static Date getYearFirst(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    public static Date getYearFirst(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(1, year);
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    public static Date getWeekStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(4, 0);
        calendar.set(7, 2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getWeekEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, calendar.getActualMaximum(7));
        calendar.add(7, 1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 99);
        return calendar.getTime();
    }

    public static Date getWeekStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(4, 0);
        calendar.set(7, 2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getWeekEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, calendar.getActualMaximum(7));
        calendar.add(7, 1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 99);
        return calendar.getTime();
    }

    public static Date getLastWeekStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.add(5, -7);
        calendar.set(7, 2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastWeekEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.add(5, -7);
        calendar.set(7, 1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 99);
        return calendar.getTime();
    }

    public static Date getYearLast(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        calendar.set(year, 11, 31, 23, 59, 59);
        return calendar.getTime();
    }

    public static Date getLastYearFirst(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(1, year - 1);
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    public static Date getLastYearEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        calendar.set(year - 1, 11, 31, 23, 59, 59);
        return calendar.getTime();
    }

    public static Date getThisMonthFirstDay() {
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getThisMonthEndDay() {
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        ca.set(11, 23);
        ca.set(12, 59);
        ca.set(13, 59);
        ca.set(14, 99);
        return ca.getTime();
    }

    public static Date getMonthFirstDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getMonthEndDay(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, ca.getActualMaximum(5));
        ca.set(11, 23);
        ca.set(12, 59);
        ca.set(13, 59);
        ca.set(14, 99);
        return ca.getTime();
    }

    public static Date getLastMonthFirstDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(2, c.get(2) - 1);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getLastMonthEndDay(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(2, ca.get(2) - 1);
        ca.set(5, ca.getActualMaximum(5));
        ca.set(11, 23);
        ca.set(12, 59);
        ca.set(13, 59);
        ca.set(14, 99);
        return ca.getTime();
    }

    public static Date getLastMonthDay(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(2, ca.get(2) - 1);
        return ca.getTime();
    }

    public static Date getMonthFirstDayLastYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(1, c.get(1) - 1);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getMonthEndDayLastYear(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(1, ca.get(1) - 1);
        ca.set(5, ca.getActualMaximum(5));
        ca.set(11, 23);
        ca.set(12, 59);
        ca.set(13, 59);
        ca.set(14, 99);
        return ca.getTime();
    }

    public static Date getQuarterFirst(int quarter) {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        cal.clear();
        if (quarter == 1) {
            cal.set(year, 0, 1, 0, 0, 0);
        } else if (quarter == 2) {
            cal.set(year, 3, 1, 0, 0, 0);
        } else if (quarter == 3) {
            cal.set(year, 6, 1, 0, 0, 0);
        } else {
            cal.set(year, 9, 1, 0, 0, 0);
        }
        return cal.getTime();
    }

    public static Date getQuarterLast(int quarter) {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        cal.clear();
        if (quarter == 1) {
            cal.set(year, 2, 31, 23, 59, 59);
        } else if (quarter == 2) {
            cal.set(year, 5, 30, 23, 59, 59);
        } else if (quarter == 3) {
            cal.set(year, 8, 30, 23, 59, 59);
        } else {
            cal.set(year, 11, 31, 23, 59, 59);
        }
        return cal.getTime();
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        }
        return cal.getTime();
    }

    public static Date getStartOfDay(Date date) {
        return DateUtil.localDateTimeToDate(LocalDateTime.of(DateUtil.dateToLocalDate(date), LocalTime.MIN));
    }

    public static Date getEndOfDay(Date date) {
        return DateUtil.localDateTimeToDate(LocalDateTime.of(DateUtil.dateToLocalDate(date), LocalTime.MAX));
    }

    public static LocalDate dateToLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date localDateTimeToDate(LocalDateTime date) {
        return Date.from(date.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date localDateToDate(LocalDate date) {
        return Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate getStartOfYear(int year) {
        return LocalDate.of(year, 1, 1);
    }

    public static int getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2);
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return DateUtil.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        return cal1 != null && cal2 != null && cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameMonth(Date d1, Date d2) {
        return DateUtil.isSameDay(DateUtil.getMonthFirstDay(d1), DateUtil.getMonthFirstDay(d2));
    }
}

