/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.utils;

import java.math.BigDecimal;

public class RMBEnBigAmt {
    private static final String[] majorNames = new String[]{" ", " thousand ", " million ", " billion ", " trillion ", " quadrillion ", " quintillion "};
    private static final String[] tensNames = new String[]{" ", " ten ", " twenty ", " thirty ", " forty ", " fifty ", " sixty ", " seventy ", " eighty ", " ninety "};
    private static final String[] numNames = new String[]{" ", " one ", " two ", " three ", " four ", " five ", " six ", " seven ", " eight ", " nine ", " ten ", " eleven ", " twelve ", " thirteen ", " fourteen ", " fifteen ", " sixteen ", " seventeen ", " eighteen ", " nineteen "};

    public static String convertEnDes(BigDecimal val, String prefix, String currencyISO, String suffix) {
        if (val == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append(" ");
        String[] amtEnDesc = RMBEnBigAmt.getAmtEnDesc(val);
        sb.append(currencyISO).append(" ");
        sb.append(amtEnDesc[0]).append(" ");
        if (amtEnDesc[1].trim().length() != 0 && !"zero".equalsIgnoreCase(amtEnDesc[1].trim())) {
            sb.append("and ").append(amtEnDesc[1]).append(" cents ");
        }
        sb.append(suffix).append(" ");
        return sb.toString().toUpperCase();
    }

    private static String convertLessThanOneThousand(long number) {
        String soFar;
        if (number % 100L < 20L) {
            soFar = numNames[(int)(number % 100L)];
            number /= 100L;
        } else {
            soFar = numNames[(int)(number % 10L)];
            soFar = tensNames[(int)((number /= 10L) % 10L)] + soFar;
            number /= 10L;
        }
        if (number == 0L) {
            return soFar;
        }
        return numNames[(int)number] + "hundred " + soFar;
    }

    public static String convert(long number) {
        if (number == 0L) {
            return "zero ";
        }
        String prefix = " ";
        if (number < 0L) {
            number = -number;
            prefix = "negative ";
        }
        String soFar = " ";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = RMBEnBigAmt.convertLessThanOneThousand(n);
                soFar = s + majorNames[place] + soFar;
            }
            ++place;
        } while ((number /= 1000L) > 0L);
        return (prefix + soFar).trim();
    }

    private static String[] getAmtEnDesc(BigDecimal val) {
        String[] ret = new String[2];
        val = val.setScale(2, 4);
        String valDes = String.valueOf(val);
        String[] valSplit = valDes.split("\\.");
        long part0 = Long.parseLong(valSplit[0]);
        ret[0] = RMBEnBigAmt.convert(part0);
        try {
            int part1 = Integer.parseInt(valSplit[1]);
            ret[1] = RMBEnBigAmt.convert(part1);
        }
        catch (Exception ex) {
            ret[1] = "";
        }
        return ret;
    }
}

