/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.JoinHint;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;

public class RptUtil {
    public static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (col != null) {
            for (DynamicObject baseData : col) {
                list.add(baseData.getPkValue());
            }
        }
        return list.toArray();
    }

    public static List<String> getBaseDataPkIdStrList(DynamicObjectCollection col) {
        ArrayList<String> list = new ArrayList<String>();
        if (col != null) {
            for (DynamicObject baseData : col) {
                list.add(baseData.getString("id"));
            }
        }
        return list;
    }

    public static List<String> getDataSetAliasList(DataSet dataSet) {
        return RptUtil.getDataSetAliasList(dataSet, true, null);
    }

    public static List<String> getDataSetAliasList(DataSet dataSet, String joinKey) {
        return RptUtil.getDataSetAliasList(dataSet, false, joinKey);
    }

    public static String[] getDataSetFiledAlias(DataSet dataSet) {
        return RptUtil.getDataSetAliasList(dataSet, true, null).toArray(new String[0]);
    }

    public static String[] getDataSetFiledAlias(DataSet dataSet, String joinKey) {
        return RptUtil.getDataSetAliasList(dataSet, false, joinKey).toArray(new String[0]);
    }

    private static List<String> getDataSetAliasList(DataSet dataSet, boolean isLeft, String joinKey) {
        Stream flatMap = Stream.of(dataSet.getRowMeta().getFields()).flatMap(v -> Stream.of(v.getAlias()));
        return (isLeft ? flatMap : flatMap.filter(v -> !v.equals(joinKey))).collect(Collectors.toList());
    }

    public static JoinHint getJoinHint(boolean nullAsZero) {
        JoinHint joinHint = new JoinHint();
        joinHint.setNullAsZero(nullAsZero);
        return joinHint;
    }

    public static DataSet zeroNullNums(DataSet dataSet) {
        return dataSet.select((String[])Stream.of(dataSet.getRowMeta().getFields()).flatMap(v -> {
            String value;
            DataType dataType = v.getDataType();
            String alias = v.getAlias();
            switch (dataType.ordinal) {
                case 2: {
                    value = "0";
                    break;
                }
                case 3: {
                    value = "0l";
                    break;
                }
                case 4: 
                case 5: {
                    value = "0.0";
                    break;
                }
                default: {
                    return Stream.of(alias);
                }
            }
            return Stream.of(String.format("(case when %s is null then %s else %s end) %s", alias, value, alias, alias));
        }).toArray(String[]::new));
    }

    public static DataSet plainDataSet(String algoKey, DataSet dataSet, DynamicObjectCollection dataObjs) {
        RowMeta rowMeta = dataSet.getRowMeta();
        int fieldCount = rowMeta.getFieldCount();
        ArrayList<Object[]> collection = new ArrayList<Object[]>();
        for (DynamicObject dataObj : dataObjs) {
            Object[] obj = new Object[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                obj[i] = dataObj.get(i);
            }
            collection.add(obj);
        }
        return Algo.create((String)algoKey).createDataSet(new Input[]{new CollectionInput(rowMeta, collection)});
    }
}

