/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Base64;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.session.EncreptSessionUtils;
import yem.base.common.utils.HttpHelper;
import yem.base.common.utils.YEM;

public class TokenUtil {
    private String mainUrl;
    private String appId;
    private String appSecuret;
    private String tenantid;
    private String accountId;
    private String user;
    private String usertype = "Mobile";
    private String language = "zh_CN";

    public TokenUtil(String mainUrl, String appId, String appSecuret, String user) {
        this.mainUrl = mainUrl;
        this.appId = appId;
        this.appSecuret = appSecuret;
        this.user = user;
    }

    public TokenUtil(String mainUrl, String appId, String appSecuret, String tenantid, String accountId, String user) {
        this.mainUrl = mainUrl;
        this.appId = appId;
        this.appSecuret = appSecuret;
        this.tenantid = tenantid;
        this.accountId = accountId;
        this.user = user;
    }

    public TokenUtil(String mainUrl, String appId, String appSecuret, String tenantid, String accountId, String user, String usertype) {
        this.mainUrl = mainUrl;
        this.appId = appId;
        this.appSecuret = appSecuret;
        this.tenantid = tenantid;
        this.accountId = accountId;
        this.user = user;
        this.usertype = usertype;
    }

    public static String getEncreptURL(String url) {
        return EncreptSessionUtils.encryptSession((String)url);
    }

    public String getAccessToken() {
        String access_token = null;
        try {
            CacheConfigInfo localConfig = new CacheConfigInfo();
            localConfig.setMaxItemSize(100);
            localConfig.setTimeout(300);
            String tokenKey = String.format("Token_Cache_%s_%s_%s_%s_%s_%s", this.mainUrl, this.appId, this.tenantid, this.accountId, this.user, this.usertype);
            tokenKey = Base64.getEncoder().encodeToString(tokenKey.getBytes());
            LocalMemoryCache localcache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("yem", tokenKey, localConfig);
            access_token = (String)localcache.get("access_token");
            if (YEM.isEmpty(access_token)) {
                JSONObject param = new JSONObject();
                param.put("appId", (Object)this.appId);
                param.put("appSecuret", (Object)this.appSecuret);
                param.put("tenantid", (Object)this.tenantid);
                param.put("accountId", (Object)this.accountId);
                param.put("language", (Object)this.language);
                String body = HttpHelper.httpPost(this.mainUrl + "/api/getAppToken.do", param.toJSONString());
                String apptoken = JSON.parseObject((String)body).getJSONObject("data").getString("app_token");
                param = new JSONObject();
                param.put("user", (Object)this.user);
                param.put("apptoken", (Object)apptoken);
                param.put("tenantid", (Object)this.tenantid);
                param.put("accountId", (Object)this.accountId);
                param.put("usertype", (Object)this.usertype);
                param.put("language", (Object)this.language);
                body = HttpHelper.httpPost(this.mainUrl + "/api/login.do", param.toJSONString());
                JSONObject data = JSON.parseObject((String)body).getJSONObject("data");
                if (data.getBoolean("success").booleanValue()) {
                    access_token = data.getString("access_token");
                    localcache.put("access_token", (Object)access_token);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return access_token;
    }
}

