/*
 * Decompiled with CFR 0.152.
 */
package yem.base.common.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.ClientActions;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import org.apache.commons.lang.StringUtils;

public class YEM {
    public static RequestContext requestContext() {
        return RequestContext.get();
    }

    public static long getCurrentUserId() {
        return YEM.requestContext().getCurrUserId();
    }

    public static DynamicObject getCurrentUser() {
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        return BusinessDataServiceHelper.loadSingleFromCache((Object)currentUserId, (String)"bos_user");
    }

    public static DynamicObject getCurrentUser(String Username) {
        QFilter qf1 = new QFilter("name", "=", (Object)Username);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{qf1});
    }

    public static long getCurrentOrgId() {
        return YEM.requestContext().getOrgId();
    }

    public static HasPermOrgResult getUserChangeAbleOrg() {
        return YEM.getUserChangeAbleOrg(YEM.getCurrentUserId());
    }

    public static List<Long> getUserChangeAbleOrgIds() {
        return YEM.getUserChangeAbleOrg().getHasPermOrgs();
    }

    public static HasPermOrgResult getUserChangeAbleOrg(long userId) {
        return UserServiceHelper.getUserChangeAbleOrg((long)userId, (boolean)true);
    }

    public static List<Long> getUserChangeAbleOrgIds(long userId) {
        return YEM.getUserChangeAbleOrg(userId).getHasPermOrgs();
    }

    public static MainEntityType getDataEntityType(String entityKey) {
        return EntityMetadataCache.getDataEntityType((String)entityKey);
    }

    public static OperateOption getOption() {
        return OperateOption.create();
    }

    public static OperateOption getOptionNoMsg() {
        OperateOption option = YEM.getOption();
        option.setVariableValue("isshowmessage", Boolean.toString(false));
        return option;
    }

    public static OperateOption getOptionNoWeb() {
        OperateOption option = YEM.getOption();
        option.setVariableValue("mutex_ignoremodify", Boolean.toString(true));
        return option;
    }

    public static OperateOption getOptionHasRight() {
        OperateOption option = YEM.getOption();
        option.setVariableValue("ishasright", Boolean.toString(true));
        return option;
    }

    public static OperateOption getOptionNotModifyDate() {
        OperateOption option = YEM.getOption();
        option.setVariableValue("updateModifyDate", Boolean.toString(false));
        return option;
    }

    public static String getOpMsg(OperationResult opResult) {
        if (opResult == null) {
            return "";
        }
        List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
        String msg = opResult.getMessage();
        for (int i = 0; i < allErrorOrValidateInfo.size(); ++i) {
            IOperateInfo iOperateInfo = (IOperateInfo)allErrorOrValidateInfo.get(i);
            msg = i == 0 ? msg + "\u539f\u56e0:" : msg;
            msg = msg + String.format("%s\u3001%s ", i + 1, iOperateInfo.getMessage());
        }
        return msg;
    }

    public static String getOpErrorMsgNoTitle(OperationResult opResult) {
        if (opResult == null) {
            return "";
        }
        List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
        String msg = "";
        for (int i = 0; i < allErrorOrValidateInfo.size(); ++i) {
            IOperateInfo iOperateInfo = (IOperateInfo)allErrorOrValidateInfo.get(i);
            msg = i == 0 ? msg + "\u539f\u56e0:" : msg;
            msg = msg + String.format("%s\u3001%s ", i + 1, iOperateInfo.getMessage());
        }
        return msg;
    }

    public static String exceptionToStr(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String error = sw.toString();
        return error;
    }

    public static BigDecimal getUnitRate(Object material, Object srcUnit, Object desUnit) {
        BigDecimal unitRate = BigDecimal.ZERO;
        if (material == null || srcUnit == null || desUnit == null) {
            return unitRate;
        }
        Long materialId = material instanceof DynamicObject ? ((DynamicObject)material).getLong("id") : (material instanceof String ? Long.valueOf((String)material) : (Long)material).longValue();
        Long srcUnitId = srcUnit instanceof DynamicObject ? ((DynamicObject)srcUnit).getLong("id") : (srcUnit instanceof String ? Long.valueOf((String)srcUnit) : (Long)srcUnit).longValue();
        Long desUnitId = desUnit instanceof DynamicObject ? ((DynamicObject)desUnit).getLong("id") : (desUnit instanceof String ? Long.valueOf((String)desUnit) : (Long)desUnit).longValue();
        if (srcUnitId.longValue() == desUnitId.longValue()) {
            return BigDecimal.ONE;
        }
        DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        if (muConv != null && muConv.getInt("numerator") != 0) {
            unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
        }
        return unitRate;
    }

    public static BigDecimal getExchangeRate(Object exchangeRateTable, Object sourceCurrency, Object targetCurrency, Date date) {
        Long targetCurrencyId;
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (exchangeRateTable == null || sourceCurrency == null || targetCurrency == null) {
            return exchangeRate;
        }
        Date date2 = date = date == null ? new Date() : date;
        Long exchangeRateTableId = exchangeRateTable instanceof DynamicObject ? ((DynamicObject)exchangeRateTable).getLong("id") : (exchangeRateTable instanceof String ? Long.valueOf((String)exchangeRateTable) : (Long)exchangeRateTable).longValue();
        Long sourceCurrencyId = sourceCurrency instanceof DynamicObject ? ((DynamicObject)sourceCurrency).getLong("id") : (sourceCurrency instanceof String ? Long.valueOf((String)sourceCurrency) : (Long)sourceCurrency).longValue();
        if (sourceCurrencyId.equals(targetCurrencyId = Long.valueOf(targetCurrency instanceof DynamicObject ? ((DynamicObject)targetCurrency).getLong("id") : (targetCurrency instanceof String ? Long.valueOf((String)targetCurrency) : (Long)targetCurrency).longValue()))) {
            return BigDecimal.ONE;
        }
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)date);
        return exchangeRate == null ? BigDecimal.ZERO : exchangeRate;
    }

    public static void changeCtlColor(IFormView view, String key, String backColor, String foreColor) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("bc", backColor);
        paramMap.put("fc", foreColor);
        view.updateControlMetadata(key, paramMap);
    }

    public static void changeCtlColor(IFormView view, String key, String backColor) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("bc", backColor);
        view.updateControlMetadata(key, paramMap);
    }

    public static void changeRowColor(IFormView view, String entryKey, int index, String backColor, String foreColor) {
        YEM.changeRowColor(view, entryKey, new int[]{index}, backColor, foreColor);
    }

    public static void changeRowColor(IFormView view, String entryKey, int[] indexs, String backColor, String foreColor) {
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        ClientActions.createRowStyleBuilder().setRows(indexs).setBackColor(backColor).setForeColor(foreColor).buildStyle().build().invokeControlMethod(proxy, entryKey);
    }

    public static void changeCellColor(IFormView view, String entryKey, String fieldKey, int index, String backColor, String foreColor) {
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        CellStyle cs = new CellStyle();
        cs.setBackColor(backColor);
        cs.setForeColor(foreColor);
        cs.setFieldKey(fieldKey);
        cs.setRow(index);
        cellStyles.add(cs);
        ClientActions.createCellStyle().addAll(cellStyles).invokeControlMethod(proxy, entryKey);
    }

    public static void changeCellColor(IFormView view, String entryKey, String fieldKey, int index, String backColor) {
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        CellStyle cs = new CellStyle();
        cs.setBackColor(backColor);
        cs.setFieldKey(fieldKey);
        cs.setRow(index);
        cellStyles.add(cs);
        ClientActions.createCellStyle().addAll(cellStyles).invokeControlMethod(proxy, entryKey);
    }

    public static long sendMessage(List<Long> receiverslist, String type, String title, String msg, String tag) {
        RequestContext requestContext = YEM.requestContext();
        String userName = requestContext.getUserName();
        MessageInfo message = new MessageInfo();
        message.setUserIds(receiverslist);
        message.setSenderName(userName);
        message.setType(type);
        message.setTitle(title);
        message.setContent(msg);
        message.setTag(tag);
        return MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String || o instanceof StringBuilder || o instanceof StringBuffer) {
            return o.toString().trim().isEmpty();
        }
        if (o instanceof Long) {
            return (Long)o == 0L;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).compareTo(BigDecimal.ZERO) == 0;
        }
        if (o instanceof Object[]) {
            return ((Object[])o).length == 0;
        }
        if (!(o instanceof DynamicObject)) {
            return o instanceof Collection && ((Collection)o).isEmpty();
        }
        DynamicObject obj = (DynamicObject)o;
        return obj.getPkValue() == null || (Long)obj.getPkValue() == 0L;
    }

    public static boolean isNotEmpty(Object o) {
        return !YEM.isEmpty(o);
    }

    public static String substringAfterLast(String str, String symbol) {
        return StringUtils.substringAfterLast((String)str, (String)symbol);
    }

    public static String substringBeforeLast(String str, String symbol) {
        return StringUtils.substringBeforeLast((String)str, (String)symbol);
    }

    public static String formatInteger(String format, Integer seq) {
        return String.format(format, seq);
    }

    public static Map<String, String> getComboProp(DynamicObjectType dynamicObjectType, String fieldKey, Boolean straight) {
        HashMap<String, String> comboItemMap = new HashMap<String, String>();
        DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
        ComboProp comboProp = (ComboProp)properties.get((Object)fieldKey);
        List comboItems = comboProp.getComboItems();
        for (ValueMapItem comboItem : comboItems) {
            String name = comboItem.getName().toString();
            String value = comboItem.getValue();
            if (!straight.booleanValue()) {
                comboItemMap.put(value, name);
                continue;
            }
            comboItemMap.put(name, value);
        }
        return comboItemMap;
    }
}

