/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ts.conmmon.utils.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import yem.base.common.utils.YEM;
import yem.wm.ts.conmmon.utils.api.RSAUtil;
import yem.wm.ts.conmmon.utils.api.SecurityUtil;
import yem.wm.ts.conmmon.webapi.constant.ErrorCodeEnum;

public class ApiCallUtil {
    private static final CloseableHttpClient httpClient = HttpClients.createDefault();
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static JSONObject doRequest(HttpUriRequest request) throws Exception {
        try (CloseableHttpResponse response = httpClient.execute(request);){
            int code = response.getStatusLine().getStatusCode();
            if (code != 200) {
                throw new RuntimeException("HTTP\u72b6\u6001\u5f02\u5e38\uff1aHTTP" + code);
            }
            String jsonResponse = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            JSONObject jSONObject = JSONObject.parseObject((String)jsonResponse);
            return jSONObject;
        }
    }

    public static boolean verifyStatusCode(JSONObject jsonObject, boolean ignore) {
        if (ignore) {
            return true;
        }
        if (jsonObject.containsKey((Object)"code")) {
            String code = jsonObject.getString("code");
            if ("0000".equals(code)) {
                return true;
            }
            throw new RuntimeException("\u63a5\u53e3\u72b6\u6001\u4e0d\u6210\u529f\uff0c" + code + " " + ErrorCodeEnum.message(code));
        }
        return false;
    }

    public static boolean verifySign(JSONObject jsonObject) {
        if (jsonObject == null) {
            return false;
        }
        String sign = jsonObject.getString("sign");
        String content = jsonObject.getString("content");
        boolean verify = RSAUtil.verify(content, sign, "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQChX0zg3fiLVceLSgvGqIczm4jGywrDBEJxWkWAiXQipcNVDV/Wr/SUWuOYSgVESRXmDTPThY1+PpPh/AH/DrFLXnv4fZoraftkvaA0wmKV0pxnw8+uwt3WeAub/LGpatgA5+ZqgE+xTamP5nNPOTJwajLofdo5dlLWLE2KrM6dCQIDAQAB");
        return verify;
    }

    public static Object decryptResponseContent(JSONObject jsonObject) {
        String content = jsonObject.getString("content");
        String decryptContent = SecurityUtil.decrypt3DES("c6VT3O9tsThexYXF9iuemz5T", content);
        if (YEM.isEmpty((Object)decryptContent)) {
            return jsonObject;
        }
        return JSON.parse((String)decryptContent);
    }

    public static JSONObject toJsonObject(Object obj) {
        Field[] fields;
        JSONObject jsonObject = new JSONObject();
        if (obj == null) {
            return jsonObject;
        }
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(JSONField.class)) continue;
            field.setAccessible(true);
            try {
                Object value = field.get(obj);
                if (value == null) continue;
                jsonObject.put(field.getName(), value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }

    public static String convertToBase64(InputStream inputStream) throws IOException {
        int bytesRead;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        byte[] fileBytes = out.toByteArray();
        return Base64.getEncoder().encodeToString(fileBytes);
    }
}

