/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ts.conmmon.utils.api;

import java.util.Date;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import yem.base.common.utils.YEM;

public class ApiLogUtil {
    private final String number;
    private final long id;
    private final DynamicObject logObject;
    private Date start;
    private final Log log = LogFactory.getLog(ApiLogUtil.class);

    public ApiLogUtil(String url) {
        this.logObject = BusinessDataServiceHelper.newDynamicObject((String)"yem_ts_apilog");
        this.id = DB.genGlobalLongId();
        long orgId = YEM.getCurrentOrgId();
        this.number = CodeRuleServiceHelper.getNumber((String)"yem_ts_apilog", (DynamicObject)this.logObject, (String)String.valueOf(orgId));
        this.logObject.set("billstatus", (Object)"A");
        this.logObject.set("yem_url", (Object)url);
        this.logObject.set("org", (Object)orgId);
        this.logObject.set("creator", (Object)YEM.getCurrentUserId());
        this.logObject.set("id", (Object)this.id);
        this.logObject.set("billno", (Object)this.number);
    }

    public void logRequest(String origin, String crypt) {
        this.start = new Date();
        this.logObject.set("createtime", (Object)this.start);
        this.logObject.set("yem_req_srt_tag", (Object)origin);
        this.logObject.set("yem_reqenencode_str_tag", (Object)crypt);
        if (!this.save()) {
            this.log.error("\u4fdd\u5b58\u8bf7\u6c42\u65e5\u5fd7\u5931\u8d25\uff01");
            this.log.error("[REQUEST][{}][{}] origin: {}", new Object[]{this.id, this.number, origin});
            this.log.error("[REQUEST][{}][{}] crypt: {}", new Object[]{this.id, this.number, crypt});
        }
    }

    public void logResponse(String origin, String decrypt) {
        Date end = new Date();
        this.logObject.set("yem_time", (Object)(end.getTime() - this.start.getTime()));
        this.logObject.set("yem_resp_srt_tag", (Object)origin);
        this.logObject.set("yem_respdecode_str_tag", (Object)decrypt);
        if (!this.save()) {
            this.log.error("\u4fdd\u5b58\u54cd\u5e94\u65e5\u5fd7\u5931\u8d25\uff01");
            this.log.error("[RESPONSE][{}][{}] origin: {}", new Object[]{this.id, this.number, origin});
            this.log.error("[RESPONSE][{}][{}] decrypt: {}", new Object[]{this.id, this.number, decrypt});
        }
    }

    private boolean save() {
        try {
            OperateOption option = YEM.getOption();
            option.setVariableValue("mutex_ignoremodify", Boolean.toString(false));
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_ts_apilog", (DynamicObject[])new DynamicObject[]{this.logObject}, (OperateOption)option);
            return result.isSuccess();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25\uff01");
            return false;
        }
    }
}

