/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ts.conmmon.webapi.constant;

import java.util.HashMap;
import java.util.Map;

public enum ErrorCodeEnum {
    SUCCESS("0000", "\u6210\u529f"),
    SYSTEM_ERROR("9000", "\u7cfb\u7edf\u5f02\u5e38"),
    SIGNATURE_VERIFICATION_FAILED("9001", "\u9a8c\u7b7e\u5931\u8d25"),
    PARAMETER_ERROR("9002", "\u53c2\u6570\u5f02\u5e38"),
    PACKAGE_ERROR("9003", "\u5957\u9910\u5f02\u5e38"),
    NOT_REGISTERED_OR_PACKAGE_EXPIRED("2001", "\u672a\u5907\u6848\u6216\u5957\u9910\u5df2\u8fc7\u671f"),
    INSUFFICIENT_PACKAGE_BALANCE("2010", "\u670d\u52a1\u53ef\u884c\uff0c\u4f46\u5957\u9910\u4f59\u91cf\u4e0d\u8db3"),
    LOGIN_EXPIRES("3000", "\u7535\u5c40\u767b\u5f55\u5931\u6548"),
    SERVICE_PROCESSING_ERROR("9999", "\u670d\u52a1\u5904\u7406\u5f02\u5e38");

    private final String code;
    private final String message;
    private static final Map<String, String> CODE_TO_MESSAGE_MAP;

    private ErrorCodeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static String message(String code) {
        return CODE_TO_MESSAGE_MAP.getOrDefault(code, "\u672a\u77e5\u9519\u8bef\u7801");
    }

    static {
        CODE_TO_MESSAGE_MAP = new HashMap<String, String>();
        for (ErrorCodeEnum errorCodeEnum : ErrorCodeEnum.values()) {
            CODE_TO_MESSAGE_MAP.put(errorCodeEnum.getCode(), errorCodeEnum.getMessage());
        }
    }
}

