/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.base.ed.filearchiving.dynamic;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.de.utils.F7Helper;
import yem.base.common.utils.DynamicObjectUtil;

public class FileArchivingHomeFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_ENTRY = "yem_entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"yem_view"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        QFilter qFilter = F7Helper.getEnableFilter();
        qFilter.and("level", "=", (Object)1);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"yem_ed_filearchivetpl");
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"yem_ed_filearchivetpl", (String)selectFields, (QFilter[])qFilter.toArray());
        model.deleteEntryData(KEY_ENTRY);
        for (DynamicObject bill : bills) {
            int index = model.createNewEntryRow(KEY_ENTRY);
            model.setValue("yem_tplname", bill.get("name"), index);
            model.setValue("yem_user", bill.get("modifier"), index);
            model.setValue("yem_updatetime", bill.get("modifytime"), index);
            model.setValue("yem_archivingtpl", bill.getPkValue(), index);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "yem_view": {
                this.clickView();
                break;
            }
        }
    }

    private void clickView() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int rowIndex = model.getEntryCurrentRowIndex(KEY_ENTRY);
        DynamicObject archivingTpl = (DynamicObject)model.getValue("yem_archivingtpl", rowIndex);
        if (archivingTpl != null) {
            ReportShowParameter showParameter = new ReportShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId("yem_ed_filearchivingquery");
            ReportQueryParam reportQueryParam = new ReportQueryParam();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.addFilterItem("yem_archivingtpl", (Object)archivingTpl);
            reportQueryParam.setFilter(filterInfo);
            showParameter.setQueryParam(reportQueryParam);
            view.showForm((FormShowParameter)showParameter);
        }
    }
}

