/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.base.ed.filearchiving.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import yem.base.common.de.meta.utils.MetaPropertyHelper;
import yem.base.common.de.utils.ShowFormUtil;
import yem.base.common.utils.YEM;

public class FileArchivingTplBillPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String[] BILL_COLS = new String[]{"yem_billcol", "yem_billcolno"};
    private static final String[] REL_COLS = new String[]{"yem_left", "yem_thiscol", "yem_thiscolno", "yem_qcp", "yem_relcol", "yem_relcolno", "yem_right", "yem_andor"};

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.bindFilterGrid();
        this.initSettings();
    }

    private void initSettings() {
        this.bindOrderbyCol();
        this.bindFilters();
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bindFilterGridData();
    }

    private void bindOrderbyCol() {
        IDataModel model = this.getModel();
        String yem_orderbycolno = (String)model.getValue("yem_orderbycolno");
        DynamicObject yem_relationbill = (DynamicObject)model.getValue("yem_relationbill");
        if (yem_relationbill != null && !yem_orderbycolno.isEmpty()) {
            String bill = yem_relationbill.getString("number");
            model.setValue("yem_orderbycol", (Object)MetaPropertyHelper.getEntityLangName((String)bill, (String)yem_orderbycolno));
        }
    }

    private void bindFilters() {
        String yem_colmap = this.getModel().getDataEntity().getString("yem_relation");
        JSONArray entry = null;
        if (StringUtils.isNotEmpty((String)yem_colmap)) {
            entry = JSON.parseArray((String)yem_colmap);
        }
        this.batchFilterEntry("yem_filters", entry);
    }

    private void batchFilterEntry(String entryName, JSONArray entry) {
        IDataModel model = this.getModel();
        model.deleteEntryData(entryName);
        if (entry != null) {
            for (int i = 0; i < entry.size(); ++i) {
                JSONObject rowData = entry.getJSONObject(i);
                int index = model.createNewEntryRow(entryName);
                Set keySet = rowData.keySet();
                block12: for (String key : keySet) {
                    String bill = "";
                    String billKey = rowData.getString(key);
                    switch (key) {
                        case "yem_thiscol": 
                        case "yem_relcol": {
                            continue block12;
                        }
                        case "yem_thiscolno": {
                            bill = ((DynamicObject)model.getValue("yem_requirebill")).getString("number");
                            model.setValue("yem_thiscol", (Object)MetaPropertyHelper.getEntityLangName((String)bill, (String)billKey), index);
                            model.setValue(key, rowData.get((Object)key), index);
                            continue block12;
                        }
                        case "yem_relcolno": {
                            bill = ((DynamicObject)model.getValue("yem_relationbill")).getString("number");
                            model.setValue("yem_relcol", (Object)MetaPropertyHelper.getEntityLangName((String)bill, (String)billKey), index);
                            model.setValue(key, rowData.get((Object)key), index);
                            continue block12;
                        }
                    }
                    model.setValue(key, rowData.get((Object)key), index);
                }
            }
        }
    }

    private void bindFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("yem_filtergridap");
        DynamicObject yem_relationbill = (DynamicObject)this.getModel().getValue("yem_relationbill");
        if (yem_relationbill != null) {
            filterGrid.setEntityNumber(yem_relationbill.getString("number"));
        } else {
            filterGrid.setEntityNumber("1122");
        }
    }

    private void bindFilterGridData() {
        FilterCondition filterCondition;
        String yem_filtergird = this.getModel().getDataEntity().getString("yem_filtergird");
        if (!StringUtils.isBlank((String)yem_filtergird) && (filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)yem_filtergird, FilterCondition.class)) != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("yem_filtergridap");
            filterGrid.SetValue(filterCondition);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"yem_billcol", "yem_thiscol", "yem_relcol", "yem_orderbycol"});
        ((BasedataEdit)this.getControl("yem_requirebill")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("yem_relationbill")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "yem_billcol": {
                this.clickBillCol(evt, key, "yem_relationbill", true, true);
                break;
            }
            case "yem_thiscol": {
                this.clickBillCol(evt, key, "yem_requirebill", false, true);
                break;
            }
            case "yem_relcol": {
                this.clickBillCol(evt, key, "yem_relationbill", false, false);
                break;
            }
            case "yem_orderbycol": {
                this.clickBillColAny(evt, key, "yem_relationbill", false);
            }
        }
    }

    private void clickBillCol(EventObject evt, String key, String baseCol, boolean isMulti, boolean isAddEntry) {
        DynamicObject requireBill = MetaPropertyHelper.getAndCheckF7Value((IFormView)this.getView(), (String)baseCol);
        if (requireBill != null) {
            String formKey = requireBill.getString("number");
            ShowFormUtil.selectField((AbstractFormPlugin)this, (String)key, (String)formKey);
        }
    }

    private void clickBillColAny(EventObject evt, String key, String baseCol, boolean isMulti) {
        DynamicObject requireBill = MetaPropertyHelper.getAndCheckF7Value((IFormView)this.getView(), (String)baseCol);
        if (requireBill != null) {
            String entityName = requireBill.getString("number");
            MetaPropertyHelper.showPropertySelect((AbstractFormPlugin)this, (String)key, (String)entityName, (boolean)isMulti);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "yem_relationbill": {
                this.relBillChanged(e);
            }
        }
    }

    private void relBillChanged(PropertyChangedArgs e) {
        this.bindFilterGrid();
        this.getView().updateView("yem_filtergridap");
        this.getModel().deleteEntryData("yem_colsmap");
        this.getModel().deleteEntryData("yem_filters");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("yem_filtergridap");
        filterGrid.SetValue(new FilterCondition());
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String key = e.getActionId();
        IDataModel model = this.getModel();
        switch (key) {
            case "yem_billcol": {
                this.billColCallBack(e);
                break;
            }
            case "yem_thiscol": {
                this.callBackEntryData(model, e, "yem_relationbill", "yem_filters", "yem_thiscolno", "yem_thiscol", true);
                break;
            }
            case "yem_relcol": {
                this.callBackEntryData(model, e, "yem_relationbill", "yem_filters", "yem_relcolno", "yem_relcol", true);
                break;
            }
        }
    }

    private void billColCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        String number = (String)e.getReturnData();
        if (YEM.isNotEmpty((Object)number)) {
            HashSet<String> exsistCols = new HashSet<String>();
            for (DynamicObject row : model.getEntryEntity("yem_colsmap")) {
                exsistCols.add(row.getString("yem_billcolno"));
            }
            if (!exsistCols.contains(number)) {
                int index = model.getEntryCurrentRowIndex("yem_colsmap");
                model.setValue("yem_billcolno", (Object)number, index);
                model.setValue("yem_billcolfunc", (Object)number, index);
                DynamicObject requireBill = MetaPropertyHelper.getAndCheckF7Value((IFormView)this.getView(), (String)"yem_relationbill");
                if (requireBill != null) {
                    String entityName = requireBill.getString("number");
                    String langName = MetaPropertyHelper.getEntityLangName((String)entityName, (String)number);
                    model.setValue("yem_billcol", (Object)langName, index);
                }
            }
        }
    }

    private void callBackEntryData(IDataModel model, ClosedCallBackEvent e, String baseCol, String entryKey, String colNo, String col, boolean ableExsist) {
        String number = (String)e.getReturnData();
        if (YEM.isNotEmpty((Object)number)) {
            HashSet<String> exsistCols = new HashSet<String>();
            for (DynamicObject row : model.getEntryEntity(entryKey)) {
                exsistCols.add(row.getString(colNo));
            }
            if (ableExsist || !exsistCols.contains(number)) {
                int index = model.getEntryCurrentRowIndex(entryKey);
                model.setValue(colNo, (Object)number, index);
                DynamicObject requireBill = MetaPropertyHelper.getAndCheckF7Value((IFormView)this.getView(), (String)baseCol);
                if (requireBill != null) {
                    String entityName = requireBill.getString("number");
                    String langName = MetaPropertyHelper.getEntityLangName((String)entityName, (String)number);
                    model.setValue(col, (Object)langName, index);
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        IDataEntityProperty p = e.getProperty();
        switch (key = p.getName()) {
            case "yem_requirebill": 
            case "yem_relationbill": {
                this.beforeRequireBill(e);
            }
        }
    }

    private void beforeRequireBill(BeforeF7SelectEvent e) {
        QFilter qFilter = new QFilter("modeltype", "in", (Object)new String[]{"BillFormModel", "BaseFormModel"});
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.beforeSave(e);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        OperationResult operationResult = e.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            this.bindFilterGridData();
            this.initSettings();
        }
    }

    private void beforeSave(BeforeDoOperationEventArgs e) {
        IDataModel model = this.getModel();
        String yem_colmap = this.parseBillCol2Json(BILL_COLS, "yem_colsmap");
        model.setValue("yem_colmap", (Object)yem_colmap);
        String yem_filters = this.parseRelCol2Json(REL_COLS, "yem_filters");
        model.setValue("yem_relation", (Object)yem_filters);
        String yem_filtergird = this.parseFilterGrid2Json("yem_filtergridap");
        model.setValue("yem_filtergird", (Object)yem_filtergird);
    }

    private String parseBillCol2Json(String[] colsName, String entryKey) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryKey);
        if (rows.isEmpty()) {
            return null;
        }
        JSONObject json = new JSONObject(colsName.length);
        for (String col : colsName) {
            JSONArray values = new JSONArray(rows.size());
            for (DynamicObject row : rows) {
                values.add((Object)row.getString(col));
            }
            json.put(col, (Object)values);
        }
        return json.toJSONString();
    }

    private String parseRelCol2Json(String[] relCols, String entryKey) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryKey);
        if (rows.isEmpty()) {
            return null;
        }
        JSONArray json = new JSONArray(rows.size());
        for (DynamicObject row : rows) {
            JSONObject values = new JSONObject(relCols.length);
            for (String col : relCols) {
                String value = row.getString(col);
                values.put(col, (Object)value);
            }
            json.add((Object)values);
        }
        return json.toJSONString();
    }

    private String parseFilterGrid2Json(String filterGridKey) {
        String filter = "";
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filterGridKey);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        if (filterCondition != null) {
            filter = SerializationUtils.toJsonString((Object)filterCondition);
        }
        return filter;
    }
}

