/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.base.ed.filearchiving.report;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import yem.base.common.utils.YEM;
import yem.wm.base.ed.filearchiving.utils.FileArchivingUtil;

public class FileArchivingRptListPlugin
extends AbstractReportListDataPlugin {
    private static final String algoKey = FileArchivingRptListPlugin.class.getName();
    private static final String KEY_TREE_NODE_FILTER = "treeNodeFilter";

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        return FileArchivingRptListPlugin.queryData(reportQueryParam);
    }

    public static DataSet queryData(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject archivingTpl = FileArchivingUtil.getArchivingTpl(filterInfo);
        String entityKey = archivingTpl.getString("yem_relationbill.number");
        DynamicObjectCollection colsMap = archivingTpl.getDynamicObjectCollection("yem_colsmap");
        ArrayList<String> selectFields = new ArrayList<String>();
        for (DynamicObject row : colsMap) {
            String billCol = row.getString("yem_billcolno");
            String billColFunc = row.getString("yem_billcolfunc");
            selectFields.add(billColFunc + " as " + billCol);
        }
        DataSet dataSet = ORM.create().queryDataSet(algoKey, entityKey, String.join((CharSequence)",", selectFields), null);
        Map customParam = queryParam.getCustomParam();
        String treeNodeFilter = (String)customParam.get(KEY_TREE_NODE_FILTER);
        if (YEM.isNotEmpty((Object)treeNodeFilter)) {
            dataSet = dataSet.where(treeNodeFilter);
        }
        return dataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject archivingTpl = FileArchivingUtil.getArchivingTpl(filterInfo);
        DynamicObjectCollection colsMap = archivingTpl.getDynamicObjectCollection("yem_colsmap");
        for (DynamicObject row : colsMap) {
            String billCol = row.getString("yem_billcolno");
            String billColName = row.getString("yem_billcol");
            ReportColumn reportColumn = new ReportColumn();
            reportColumn.setFieldType("text");
            reportColumn.setFieldKey(billCol);
            reportColumn.setCaption(new LocaleString(billColName));
            columns.add((AbstractReportColumn)reportColumn);
        }
        return super.getColumns(columns);
    }
}

