/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.base.ed.filearchiving.report;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.ORM;
import kd.bos.report.IReportView;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.YEM;
import yem.wm.base.ed.filearchiving.report.FileArchivingRptListPlugin;
import yem.wm.base.ed.filearchiving.utils.FileArchivingUtil;

public class FileArchivingRptPlugin
extends AbstractReportFormPlugin
implements TreeNodeClickListener {
    private static final String KEY_TREE_NODE_FILTER = "treeNodeFilter";
    private static final String KEY_TREE_VIEW_FILTER = "treeViewFilter";
    private static final String KEY_TREE_CLICK = "treeNodeClick";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tree = (TreeView)this.getView().getControl("yem_treeviewap");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        IPageCache pageCache = this.getPageCache();
        String treeNodeFilter = pageCache.get(KEY_TREE_NODE_FILTER);
        String treeNodeClick = pageCache.get(KEY_TREE_CLICK);
        queryParam.getCustomParam().put(KEY_TREE_NODE_FILTER, treeNodeFilter);
        if (YEM.isEmpty((Object)treeNodeClick)) {
            this.initFilterFields();
            this.intiTree(queryParam, pageCache);
        } else {
            pageCache.remove(KEY_TREE_CLICK);
        }
    }

    private void intiTree(ReportQueryParam queryParam, IPageCache pageCache) {
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject archivingTpl = FileArchivingUtil.getArchivingTpl(filterInfo);
        DynamicObjectCollection colsMap = archivingTpl.getDynamicObjectCollection("yem_colsmap");
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (DynamicObject row : colsMap) {
            String billCol = row.getString("yem_billcolno");
            String treeLevel = row.getString("yem_treelevel");
            if (!YEM.isNotEmpty((Object)treeLevel)) continue;
            treeMap.put(treeLevel, billCol);
        }
        DataSet dataSet = FileArchivingRptListPlugin.queryData(queryParam);
        DynamicObjectCollection dynamicObjects = ORM.create().toPlainDynamicObjectCollection(dataSet);
        TreeNode rootNode = new TreeNode("", archivingTpl.getString("number"), archivingTpl.getString("name"));
        rootNode.setIsOpened(true);
        JSONObject cacheObject = new JSONObject();
        this.initNodes(rootNode, (Collection<DynamicObject>)dynamicObjects, treeMap, 1, cacheObject);
        pageCache.putBigObject(KEY_TREE_VIEW_FILTER, cacheObject.toJSONString());
        TreeView tree = (TreeView)this.getView().getControl("yem_treeviewap");
        tree.deleteAllNodes();
        tree.addNode(rootNode);
    }

    private void initNodes(TreeNode parentNode, Collection<DynamicObject> dynamicObjects, Map<String, String> treeMap, int level, JSONObject cacheObject) {
        String fieldKey = treeMap.get("" + level++);
        if (fieldKey == null) {
            return;
        }
        Map<Object, List<DynamicObject>> listMap = dynamicObjects.stream().collect(Collectors.groupingBy(x -> {
            Object value = x.get(fieldKey);
            return value == null ? "" : value;
        }));
        for (Map.Entry<Object, List<DynamicObject>> entry : listMap.entrySet()) {
            Object groupValue = entry.getKey();
            List<DynamicObject> list = entry.getValue();
            String groupValueStr = groupValue.toString();
            String nodeId = fieldKey + "#" + groupValueStr;
            TreeNode node = new TreeNode(parentNode.getId(), nodeId, groupValueStr);
            node.setIsOpened(true);
            this.initNodes(node, list, treeMap, level, cacheObject);
            parentNode.addChild(node);
            String whereStr = YEM.isNotEmpty((Object)groupValueStr) ? String.format("%s = '%s'", fieldKey, groupValueStr) : String.format("%s = '%s' or %s is null", fieldKey, groupValueStr, fieldKey);
            cacheObject.put(nodeId, (Object)whereStr);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        String nodeId = (String)evt.getNodeId();
        IPageCache pageCache = this.getPageCache();
        if ("0".equals(nodeId)) {
            pageCache.put(KEY_TREE_NODE_FILTER, null);
        } else {
            String treeViewFilterJson = pageCache.getBigObject(KEY_TREE_VIEW_FILTER);
            JSONObject cacheObject = JSONObject.parseObject((String)treeViewFilterJson);
            String treeNodeFilter = (String)cacheObject.get((Object)nodeId);
            pageCache.put(KEY_TREE_NODE_FILTER, treeNodeFilter);
        }
        pageCache.put(KEY_TREE_CLICK, String.valueOf(true));
        ReportFilter reportFilter = (ReportFilter)this.getView().getControl("reportfilterap");
        reportFilter.search();
    }

    public void initPropertyChanged(PropertyChangedArgs e) {
        super.initPropertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if ("yem_archivingtpl".equals(fieldKey)) {
            this.initFilterFields();
        }
    }

    private void initFilterFields() {
        IReportView view = this.getView();
        IDataModel model = this.getModel();
        ArrayList<String> showFilterFields = new ArrayList<String>();
        ArrayList<String> hideFilterFields = new ArrayList<String>();
        DynamicObject archivingTpl = (DynamicObject)model.getValue("yem_archivingtpl");
        if (archivingTpl != null) {
            archivingTpl = BusinessDataServiceHelper.loadSingleFromCache((Object)archivingTpl.getPkValue(), (String)archivingTpl.getDynamicObjectType().getName());
            DynamicObjectCollection filtersMap = archivingTpl.getDynamicObjectCollection("yem_filtersmap");
            TreeMap<String, Integer> countMap = new TreeMap<String, Integer>();
            for (DynamicObject row : filtersMap) {
                String filterColName = row.getString("yem_filtercolname");
                String filterColType = row.getString("yem_filtercoltype");
                String fBaseDataType = row.getString("yem_fbasedatatype");
                String filterShowFlex = row.getString("yem_filtershowflex");
                int fieldCount = countMap.containsKey(filterColType) ? (Integer)countMap.get(filterColType) + 1 : 1;
                countMap.put(filterColType, fieldCount);
                String tag = "A".equals(filterShowFlex) ? "_f" : ("B".equals(filterShowFlex) ? "_m" : "");
                String filterColNo = filterColType + tag + fieldCount;
                showFilterFields.add(filterColNo);
                FieldEdit control = (FieldEdit)view.getControl(filterColNo);
                if (control == null) continue;
                control.setCaption(new LocaleString(filterColName));
            }
        }
        ArrayList<String> filterColTypes = new ArrayList<String>();
        filterColTypes.add("yem_textfield");
        filterColTypes.add("yem_daterangefield");
        filterColTypes.add("yem_datefield");
        filterColTypes.add("yem_basedatafield");
        filterColTypes.add("yem_mulbasedatafield");
        filterColTypes.add("yem_checkboxfield");
        filterColTypes.add("yem_combofield");
        for (int i = 1; i <= 5; ++i) {
            for (String filterColType : filterColTypes) {
                String key1 = filterColType + "_f" + i;
                String key2 = filterColType + "_m" + i;
                if (!showFilterFields.contains(key1)) {
                    hideFilterFields.add(key1);
                }
                if (showFilterFields.contains(key2)) continue;
                hideFilterFields.add(key2);
            }
        }
        view.setVisible(Boolean.valueOf(true), showFilterFields.toArray(new String[0]));
        view.setVisible(Boolean.valueOf(false), hideFilterFields.toArray(new String[0]));
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType type;
        super.getEntityType(e);
        try {
            type = e.getNewEntityType() == null ? (MainEntityType)e.getOriginalEntityType().clone() : e.getNewEntityType();
        }
        catch (CloneNotSupportedException exception) {
            throw new KDBizException((Throwable)exception, BosErrorCode.systemError, new Object[0]);
        }
        this.baseDataPropInit(type, "yem_mulbasedatafield_f1", "bd_supplier");
        this.baseDataPropInit(type, "yem_basedatafield_m1", "bd_supplier");
        e.setNewEntityType(type);
    }

    private void baseDataPropInit(MainEntityType type, String propertyKey, String entityId) {
        DynamicProperty property = type.getProperty(propertyKey);
        if (property instanceof MulBasedataProp) {
            MulBasedataProp prop = (MulBasedataProp)property;
            prop.setBaseEntityId(entityId);
            IDataEntityType itemType = prop.getItemType();
            BasedataProp baseProp = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
            baseProp.setBaseEntityId(entityId);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            baseProp.setComplexType((IDataEntityType)dataEntityType);
            PKFieldProp bd_idProp1 = (PKFieldProp)prop.getItemType().getProperties().get((Object)"fbasedataid_id");
            itemType.getProperties().remove((Object)bd_idProp1);
            Object bd_idProp = dataEntityType.getPrimaryKey() instanceof VarcharProp ? new VarcharProp() : new LongProp();
            bd_idProp.setPrimaryKey(false);
            bd_idProp.setName("fbasedataid_id");
            baseProp.setRefIdProp((IDataEntityProperty)bd_idProp);
            ((DynamicObjectType)itemType).addProperty((DynamicProperty)bd_idProp);
        } else if (property instanceof BasedataProp) {
            BasedataProp baseProp = (BasedataProp)property;
            baseProp.setBaseEntityId(entityId);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            baseProp.setComplexType((IDataEntityType)dataEntityType);
        }
    }
}

