/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.service.common.chart;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AmountOfExportLine
extends AbstractFormPlugin {
    private static final String[] xStr = new String[]{"01\u6708", "02\u6708", "03\u6708", "04\u6708", "05\u6708", "06\u6708", "07\u6708", "08\u6708", "09\u6708", "10\u6708", "11\u6708", "12\u6708"};
    private static Map<String, BigDecimal> datas = null;
    private static Map<Integer, Map> map = null;
    private static Set<String> legendName = new HashSet<String>();
    private static int year;

    public void registerListener(EventObject e) {
        Button button = (Button)this.getControl("yem_buttonap1");
        Button button2 = (Button)this.getControl("yem_addbu");
        if (button != null) {
            button.addClickListener((ClickListener)this);
        }
        if (button2 != null) {
            button2.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        Control control2 = this.getControl("yem_pointlinechartap");
        PointLineChart lineChart = null;
        if (control2 instanceof PointLineChart) {
            lineChart = (PointLineChart)control2;
        }
        if ("yem_buttonap1".equals(control.getKey())) {
            String tempYear = (String)this.getModel().getValue("yem_textfield");
            if (tempYear.isEmpty()) {
                this.getView().showMessage("\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            if (year == Integer.valueOf(tempYear)) {
                this.getView().showMessage("\u5f53\u524d\u5e74\u4efd\u5df2\u9ed8\u8ba4\u67e5\u8be2\uff0c\u65e0\u9700\u518d\u6b21\u67e5\u8be2");
                return;
            }
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            for (String name : legendName) {
                map.put(name + "\u5e74", false);
                if (!tempYear.equals(name)) continue;
                map.put(name + "\u5e74", true);
            }
            lineChart.setLegendPropValue("selected", map);
            year = Integer.valueOf(tempYear);
            datas = this.dateMakes(year);
            this.drawChart(lineChart, year);
        } else if ("yem_addbu".equals(control.getKey())) {
            String tempYear = (String)this.getModel().getValue("yem_textfield");
            if (tempYear.isEmpty()) {
                this.getView().showMessage("\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            if (year == Integer.valueOf(tempYear)) {
                this.getView().showMessage("\u5f53\u524d\u5e74\u4efd\u5df2\u9ed8\u8ba4\u67e5\u8be2\uff0c\u65e0\u9700\u65b0\u589e\u67e5\u8be2");
                return;
            }
            LinkedHashMap<Integer, Map> map = new LinkedHashMap<Integer, Map>();
            map.put(year, datas);
            int addYear = Integer.valueOf(tempYear);
            Map<String, BigDecimal> addDatas = this.dateMakes(addYear);
            map.put(addYear, addDatas);
            HashMap<String, Boolean> temp = new HashMap<String, Boolean>();
            temp.put(tempYear + "\u5e74", true);
            lineChart.setLegendPropValue("selected", temp);
            this.drawChart(lineChart, map);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Control control = this.getControl("yem_pointlinechartap");
        PointLineChart lineChart = null;
        if (control instanceof PointLineChart) {
            lineChart = (PointLineChart)control;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        year = calendar.get(1);
        datas = this.dateMakes(year);
        this.drawChart(lineChart, year);
    }

    public void drawChart(PointLineChart lineChart, int year) {
        Axis x = lineChart.createXAxis("\u6708\u4efd", AxisType.category);
        x.setPropValue("nameLocation", (Object)"end");
        HashMap<String, String> nameTextStyle = new HashMap<String, String>();
        nameTextStyle.put("color", "black");
        HashMap<String, String[]> axisLine = new HashMap<String, String[]>();
        String[] symbolArr = new String[]{"none", "arrow"};
        axisLine.put("symbol", symbolArr);
        x.setPropValue("axisLine", axisLine);
        x.setCategorys(xStr);
        x.setPropValue("nameTextStyle", nameTextStyle);
        Axis y = lineChart.createYAxis("\u91d1\u989d(\u4e07\u5143)", AxisType.value);
        this.singleDrawChar(lineChart, datas, year, "#6890FB");
        lineChart.setShowTooltip(true);
        lineChart.setShowLegend(true);
        HashMap<String, Object> grid = new HashMap<String, Object>();
        grid.put("right", "50");
        grid.put("left", "10");
        grid.put("containLabel", true);
        lineChart.addProperty("grid", grid);
        lineChart.refresh();
    }

    public void drawChart(PointLineChart lineChart, Map<Integer, Map> years) {
        Axis x = lineChart.createXAxis("\u6708\u4efd", AxisType.category);
        x.setPropValue("nameLocation", (Object)"end");
        HashMap<String, String> nameTextStyle = new HashMap<String, String>();
        nameTextStyle.put("color", "black");
        HashMap<String, String[]> axisLine = new HashMap<String, String[]>();
        String[] symbolArr = new String[]{"none", "arrow"};
        axisLine.put("symbol", symbolArr);
        x.setPropValue("axisLine", axisLine);
        x.setCategorys(xStr);
        x.setPropValue("nameTextStyle", nameTextStyle);
        Axis y = lineChart.createYAxis(" \u91d1\u989d\u5408\u8ba1/\u4e07\u5143", AxisType.value);
        lineChart.setShowTooltip(true);
        lineChart.setShowLegend(true);
        HashMap<String, Object> grid = new HashMap<String, Object>();
        grid.put("right", "50");
        grid.put("left", "10");
        grid.put("containLabel", true);
        lineChart.addProperty("grid", grid);
        String[] colors = new String[]{"#6890FB", "#A3FEB5"};
        int colorIndex = 0;
        for (int temp : years.keySet()) {
            this.singleDrawChar(lineChart, years.get(temp), temp, colors[colorIndex]);
            ++colorIndex;
        }
        lineChart.refresh();
    }

    public Map<String, BigDecimal> dateMakes(int years) {
        LinkedHashMap<String, BigDecimal> datas = new LinkedHashMap<String, BigDecimal>();
        int[] months = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        for (int month : months) {
            startCal.set(years, month, 1, 0, 0, 0);
            endCal.set(1, years);
            endCal.set(2, month + 1);
            endCal.set(5, 0);
            endCal.set(10, 23);
            endCal.set(12, 59);
            endCal.set(13, 59);
            ArrayList<QFilter> cifList = new ArrayList<QFilter>();
            cifList.add(QFilter.of((String)"yem_billtypefield.name = ?", (Object[])new Object[]{"\u51fa\u53e3\u62a5\u5173\u5355"}));
            cifList.add(QFilter.of((String)"yem_cusdecstatusname = ?", (Object[])new Object[]{"\u7ed3\u5173"}));
            cifList.add(new QFilter("yem_fiedatets", ">=", (Object)startCal.getTime()));
            cifList.add(new QFilter("yem_fiedatets", "<=", (Object)endCal.getTime()));
            Map map = BusinessDataServiceHelper.loadFromCache((String)"yem_ca_cusdec", (String)"yem_sumlocdecltotal", (QFilter[])cifList.toArray(new QFilter[0]));
            BigDecimal sum = BigDecimal.ZERO;
            for (Object temp : map.keySet()) {
                DynamicObject dy = (DynamicObject)map.get(temp);
                BigDecimal db = dy.getBigDecimal("yem_sumlocdecltotal");
                sum = sum.add(db);
            }
            datas.put(month + 1 + "", sum);
        }
        return datas;
    }

    public void singleDrawChar(PointLineChart lineChart, Map<String, BigDecimal> map, int year, String color) {
        Number[] values = new Number[xStr.length];
        for (int i = 0; i < xStr.length; ++i) {
            values[i] = i < 9 ? map.get(String.valueOf(xStr[i].charAt(1))).divide(new BigDecimal(10000.0), 2, 4) : map.get(xStr[i].substring(0, 2)).divide(new BigDecimal(10000.0), 2, 4);
        }
        LineSeries series = lineChart.createLineSeries(year + "\u5e74");
        legendName.add(year + "");
        series.setData(values);
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("color", color);
        HashMap<String, String> itemStyle = new HashMap<String, String>();
        itemStyle.put("color", color);
        series.setPropValue("lineStyle", lineStyle);
        series.setPropValue("itemStyle", itemStyle);
    }
}

