/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.service.common.chart;

import com.alibaba.nacos.api.utils.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AmountOfExports
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String start_key = "yem_starttime";
    private static final String end_key = "yem_endtime";
    private static final String button_key = "yem_select";
    private static Map<String, BigDecimal>[] cifMaps = null;
    private static Map<String, BigDecimal>[] fobMaps = null;
    private static Map<String, BigDecimal>[] exwMaps = null;
    private static int endYear = 0;
    private static int startYear = 1;
    private DecimalFormat df = new DecimalFormat("#,##0.00");
    private static final String[] xStr = new String[]{"01\u6708", "02\u6708", "03\u6708", "04\u6708", "05\u6708", "06\u6708", "07\u6708", "08\u6708", "09\u6708", "10\u6708", "11\u6708", "12\u6708"};
    private static Set<String> legendName = new HashSet<String>();

    public void registerListener(EventObject e) {
        Button textEdit = (Button)this.getControl(button_key);
        EntryGrid entryGrid = (EntryGrid)this.getControl("yem_entryentity");
        if (textEdit != null) {
            textEdit.addClickListener((ClickListener)this);
        }
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Control control = this.getControl("yem_histogramchartap");
        if (control instanceof HistogramChart) {
            HistogramChart barChart = (HistogramChart)control;
            Calendar cal = Calendar.getInstance();
            Date nowDate = new Date();
            cal.setTime(nowDate);
            endYear = cal.get(1);
            startYear = endYear - 1;
            int yearDiffer = endYear - startYear;
            cifMaps = new Map[yearDiffer + 1];
            fobMaps = new Map[yearDiffer + 1];
            exwMaps = new Map[yearDiffer + 1];
            BigDecimal cifSum = this.method(yearDiffer, startYear, "CIF", cifMaps, 0);
            BigDecimal fobSum = this.method(yearDiffer, startYear, "FOB", fobMaps, 1);
            BigDecimal exwSum = this.method(yearDiffer, startYear, "EXW", exwMaps, 2);
            this.getModel().setValue("yem_deal", (Object)"\u603b\u989d", 3);
            this.getModel().setValue("yem_outmoney", (Object)("$" + this.df.format(cifSum.add(fobSum).add(exwSum)).toString()), 3);
            this.drawChart(barChart, cifMaps, startYear);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        Control control1 = this.getControl("yem_histogramchartap");
        HistogramChart barChart = (HistogramChart)control1;
        if (StringUtils.equals((CharSequence)entryGrid.getKey(), (CharSequence)"yem_entryentity")) {
            if (evt.getRow() == 0) {
                this.drawChart(barChart, cifMaps, startYear, "CIF");
            }
            if (evt.getRow() == 1) {
                this.drawChart(barChart, fobMaps, startYear, "FOB");
            }
            if (evt.getRow() == 2) {
                this.drawChart(barChart, exwMaps, startYear, "EXW");
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        Control control1 = this.getControl("yem_histogramchartap");
        HistogramChart barChart = (HistogramChart)control1;
        if (StringUtils.equals((CharSequence)control.getKey(), (CharSequence)button_key)) {
            barChart.clearData();
            String staOb = (String)this.getModel().getValue(start_key);
            String endOb = (String)this.getModel().getValue(end_key);
            if (StringUtils.isEmpty((CharSequence)staOb) || StringUtils.isEmpty((CharSequence)endOb)) {
                this.getView().showMessage("\u5f00\u59cb\u6216\u622a\u6b62\u5e74\u4efd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2!");
                return;
            }
            int startTemp = Integer.valueOf(staOb);
            int endTemp = Integer.valueOf(endOb);
            if (startTemp == startYear && endTemp == endYear) {
                this.getView().showMessage("\u9ed8\u8ba4\u6570\u636e\u4e3a" + startYear + "-" + endYear + " \u65e0\u9700\u91cd\u590d\u67e5\u8be2");
                return;
            }
            endYear = endTemp;
            startYear = startTemp;
            int yearDiffer = endYear - startYear;
            if (yearDiffer + 1 > 3) {
                this.getView().showMessage("\u6700\u591a\u53ea\u5141\u8bb8\u540c\u65f6\u67e5\u8be23\u5e74\u6570\u636e");
                return;
            }
            if (yearDiffer < 0) {
                this.getView().showMessage("\u8d77\u59cb\u5e74\u4efd\u65e0\u6cd5\u5927\u4e8e\u622a\u6b62\u5e74\u4efd");
                return;
            }
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            for (String name : legendName) {
                map.put(name + "\u5e74", false);
                for (int i = 0; i <= yearDiffer; ++i) {
                    if (!(startYear + i + "").equals(name)) continue;
                    map.put(name + "\u5e74", true);
                }
            }
            barChart.setLegendPropValue("selected", map);
            barChart.setTitlePropValue("text", (Object)"zz");
            barChart.setShowTitle(true);
            cifMaps = new Map[yearDiffer + 1];
            fobMaps = new Map[yearDiffer + 1];
            exwMaps = new Map[yearDiffer + 1];
            BigDecimal cifSum = this.method(yearDiffer, startYear, "CIF", cifMaps, 0);
            BigDecimal fobSum = this.method(yearDiffer, startYear, "FOB", fobMaps, 1);
            BigDecimal exwSum = this.method(yearDiffer, startYear, "EXW", exwMaps, 2);
            this.getModel().setValue("yem_deal", (Object)"\u603b\u989d", 3);
            this.getModel().setValue("yem_outmoney", (Object)("$" + this.df.format(cifSum.add(fobSum).add(exwSum)).toString()), 3);
            barChart.clearData();
            this.drawChart(barChart, cifMaps, startYear);
        }
    }

    public BigDecimal method(int yearDiffer, int startYear, String type, Map<String, BigDecimal>[] cifMaps, int rowIndex) {
        for (int i = 0; i <= yearDiffer; ++i) {
            Map<String, BigDecimal> map = this.dateMakes(startYear + i, type);
            cifMaps[i] = map;
        }
        this.getModel().setValue("yem_deal", (Object)type, rowIndex);
        BigDecimal sum = BigDecimal.ZERO;
        for (Map<String, BigDecimal> temp : cifMaps) {
            Collection<BigDecimal> col = temp.values();
            BigDecimal sumTemp = BigDecimal.ZERO;
            for (BigDecimal temp1 : col) {
                sumTemp = temp1.add(sumTemp);
            }
            sum = sumTemp.add(sum);
        }
        sum = sum.divide(new BigDecimal(1.0), 2, 4);
        this.getModel().setValue("yem_outmoney", (Object)("$" + this.df.format(sum).toString()), rowIndex);
        return sum;
    }

    public Map<String, BigDecimal> dateMakes(int years, String type) {
        LinkedHashMap<String, BigDecimal> datas = new LinkedHashMap<String, BigDecimal>();
        int[] months = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        for (int month : months) {
            startCal.set(years, month, 1, 0, 0, 0);
            endCal.set(1, years);
            endCal.set(2, month + 1);
            endCal.set(5, 0);
            endCal.set(10, 23);
            endCal.set(12, 59);
            endCal.set(13, 59);
            ArrayList<QFilter> cifList = new ArrayList<QFilter>();
            cifList.add(QFilter.of((String)"yem_transmodbase.name = ?", (Object[])new Object[]{type}));
            cifList.add(new QFilter("yem_fiedatets", ">=", (Object)startCal.getTime()));
            cifList.add(new QFilter("yem_fiedatets", "<=", (Object)endCal.getTime()));
            cifList.add(QFilter.of((String)"yem_cusdecstatusname = ?", (Object[])new Object[]{"\u7ed3\u5173"}));
            Map map = BusinessDataServiceHelper.loadFromCache((String)"yem_ca_cusdec", (String)"yem_sumlocdecltotal", (QFilter[])cifList.toArray(new QFilter[0]));
            BigDecimal sum = BigDecimal.ZERO;
            for (Object temp : map.keySet()) {
                DynamicObject dy = (DynamicObject)map.get(temp);
                BigDecimal db = dy.getBigDecimal("yem_sumlocdecltotal");
                sum = sum.add(db);
            }
            datas.put(month + 1 + "", sum);
        }
        return datas;
    }

    public void drawChart(HistogramChart barChart, Map<String, BigDecimal>[] cifMaps, int startYear) {
        String type = "CIF";
        Axis y = barChart.createYAxis("\u91d1\u989d(\u4e07\u5143)", AxisType.value);
        HashMap<String, Number[]> nameTextStyle = new HashMap<String, Number[]>();
        Number[] padding = new Number[]{0, 0, 0, 100};
        nameTextStyle.put("padding", padding);
        y.setPropValue("nameTextStyle", nameTextStyle);
        Axis x = barChart.createXAxis("", AxisType.category);
        x.setPropValue("data", (Object)xStr);
        if (cifMaps.length == 1) {
            this.singleDrawChar(barChart, cifMaps[0], startYear, "#EC6114");
        } else {
            String[] colors = new String[]{"#6890FB", "#A3FEB5", "#F4DE6C"};
            for (int i = 0; i < cifMaps.length; ++i) {
                this.singleDrawChar(barChart, cifMaps[i], startYear + i, colors[i]);
            }
        }
        barChart.setShowTitle(false);
        barChart.setTitlePropValue("text", (Object)("\u6210\u4ea4\u65b9\u5f0f(" + type + ")\u6708\u5ea6\u51fa\u53e3\u989d(\u7f8e\u5143)\u540c\u6bd4\u7edf\u8ba1"));
        HashMap<String, Integer> textStyle = new HashMap<String, Integer>();
        textStyle.put("fontSize", 27);
        barChart.setTitlePropValue("textStyle", textStyle);
        barChart.setTitlePropValue("left", (Object)20);
        barChart.setShowTooltip(true);
        barChart.setShowLegend(true);
        barChart.setLegendVertical(false);
        barChart.setLegendPropValue("right", (Object)20);
        barChart.setLegendPropValue("top", (Object)40);
        barChart.refresh();
    }

    public void drawChart(HistogramChart barChart, Map<String, BigDecimal>[] cifMaps, int startYear, String type) {
        Axis y = barChart.createYAxis("\u91d1\u989d/(\u4e07\u5143)", AxisType.value);
        HashMap nameTextStyle = new HashMap();
        y.setPropValue("nameTextStyle", nameTextStyle);
        Axis x = barChart.createXAxis("\u6708\u4efd", AxisType.category);
        x.setPropValue("data", (Object)xStr);
        if (cifMaps.length == 1) {
            this.singleDrawChar(barChart, cifMaps[0], startYear, "#6890FB");
        } else {
            String[] colors = new String[]{"#6890FB", "#A3FEB5", "#F4DE6C"};
            for (int i = 0; i < cifMaps.length; ++i) {
                this.singleDrawChar(barChart, cifMaps[i], startYear + i, colors[i]);
            }
        }
        barChart.setShowTitle(false);
        barChart.setTitlePropValue("text", (Object)("\u6210\u4ea4\u65b9\u5f0f(" + type + ")\u6708\u5ea6\u51fa\u53e3\u989d(\u7f8e\u5143)\u540c\u6bd4\u7edf\u8ba1"));
        HashMap<String, Integer> textStyle = new HashMap<String, Integer>();
        textStyle.put("fontSize", 27);
        barChart.setTitlePropValue("textStyle", textStyle);
        barChart.setTitlePropValue("left", (Object)20);
        barChart.setShowTooltip(true);
        barChart.setShowLegend(true);
        barChart.setLegendVertical(false);
        barChart.setLegendPropValue("right", (Object)20);
        barChart.setLegendPropValue("top", (Object)40);
        barChart.refresh();
    }

    public void singleDrawChar(HistogramChart barChart, Map<String, BigDecimal> map, int startYear, String color) {
        Number[] values = new Number[xStr.length];
        for (int i = 0; i < xStr.length; ++i) {
            values[i] = i < 9 ? map.get(String.valueOf(xStr[i].charAt(1))).divide(BigDecimal.valueOf(10000.0), 2, 4) : map.get(xStr[i].substring(0, 2)).divide(BigDecimal.valueOf(10000.0), 2, 4);
        }
        BarSeries barSeries = barChart.createBarSeries(startYear + "\u5e74");
        legendName.add(startYear + "");
        barSeries.setData(values);
        barSeries.setColor(color);
        HashMap<String, Boolean> label = new HashMap<String, Boolean>();
        label.put("show", false);
        barSeries.setPropValue("label", label);
    }
}

