/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.service.common.chart;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CustomsBrokerTolerate
extends AbstractFormPlugin {
    public void createNewData(BizDataEventArgs e) {
        Control control = this.getControl("yem_histogramchartap");
        HistogramChart chart = null;
        if (control instanceof HistogramChart) {
            chart = (HistogramChart)control;
        }
        Date date = new Date();
        Calendar nowCal = Calendar.getInstance();
        nowCal.setTime(date);
        ArrayList<QFilter> qlist = new ArrayList<QFilter>();
        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        startCal.set(nowCal.get(1), 0, 1, 0, 0, 0);
        endCal.set(1, nowCal.get(1));
        endCal.set(2, 12);
        endCal.set(5, -1);
        endCal.set(10, 23);
        endCal.set(12, 59);
        endCal.set(13, 59);
        qlist.add(new QFilter("yem_updatetime", ">=", (Object)startCal.getTime()));
        qlist.add(new QFilter("yem_updatetime", "<=", (Object)endCal.getTime()));
        Map map = BusinessDataServiceHelper.loadFromCache((String)"yem_ca_repairnote", (String)"yem_agentname", (QFilter[])qlist.toArray(new QFilter[0]));
        LinkedHashMap<String, Integer> datas = new LinkedHashMap<String, Integer>();
        for (Object temp : map.keySet()) {
            DynamicObject dy = (DynamicObject)map.get(temp);
            String db = dy.getString("yem_agentname");
            if (!datas.containsKey(db)) {
                datas.put(db, 1);
                continue;
            }
            datas.put(db, (Integer)datas.get(db) + 1);
        }
        ArrayList<QFilter> totallist = new ArrayList<QFilter>();
        Calendar startCal1 = Calendar.getInstance();
        Calendar endCal1 = Calendar.getInstance();
        startCal1.set(nowCal.get(1), 0, 1, 0, 0, 0);
        endCal1.set(1, nowCal.get(1));
        endCal1.set(2, 12);
        endCal1.set(5, -1);
        endCal1.set(10, 23);
        endCal1.set(12, 59);
        endCal1.set(13, 59);
        totallist.add(new QFilter("yem_fiedatets", ">=", (Object)startCal1.getTime()));
        totallist.add(new QFilter("yem_fiedatets", "<=", (Object)endCal1.getTime()));
        LinkedHashMap<String, BigDecimal> totalDatas = new LinkedHashMap<String, BigDecimal>();
        for (String key : datas.keySet()) {
            ArrayList<QFilter> temp = new ArrayList<QFilter>();
            temp.addAll(totallist);
            temp.add(new QFilter("yem_agentname", "=", (Object)key));
            int count = BusinessDataServiceHelper.loadFromCache((String)"yem_ca_cusdec", (String)"yem_entryid", (QFilter[])temp.toArray(new QFilter[0])).size();
            double yValue = count == 0 ? 0.0 : (double)((Integer)datas.get(key)).intValue() / (double)count;
            BigDecimal tempDe = new BigDecimal(yValue).divide(new BigDecimal(1.0), 4, 4).multiply(new BigDecimal(100));
            totalDatas.put(key, tempDe);
        }
        if (chart != null) {
            this.drawChart(chart, totalDatas);
        }
    }

    public void drawChart(HistogramChart chart, Map<String, BigDecimal> map) {
        Axis y = chart.createYAxis("", AxisType.category);
        Axis x = chart.createXAxis("", AxisType.value);
        x.setPropValue("name", (Object)"\u5dee\u9519\u7387(%)");
        HashMap<String, Object> axisLine = new HashMap<String, Object>();
        axisLine.put("show", true);
        String[] symbolArr = new String[]{"none", "arrow"};
        axisLine.put("symbol", symbolArr);
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("color", "#333");
        axisLine.put("lineStyle", lineStyle);
        x.setPropValue("axisLine", axisLine);
        HashMap<String, Object> grid = new HashMap<String, Object>();
        grid.put("right", "110");
        grid.put("left", "10");
        grid.put("top", "10");
        grid.put("containLabel", true);
        chart.addProperty("grid", grid);
        BarSeries barSeries = chart.createSeries("\u5dee\u9519\u7387");
        ArrayList<Map.Entry<String, BigDecimal>> tempList = new ArrayList<Map.Entry<String, BigDecimal>>(map.entrySet());
        Collections.sort(tempList, new Comparator<Map.Entry<String, BigDecimal>>(){

            @Override
            public int compare(Map.Entry<String, BigDecimal> o1, Map.Entry<String, BigDecimal> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        Number[] values = new Number[map.size()];
        ArrayList yList = new ArrayList();
        int i = 0;
        for (Map.Entry entry : tempList) {
            values[i] = (Number)entry.getValue();
            yList.add(entry.getKey());
            ++i;
        }
        barSeries.setData(values);
        y.setCategorys(yList);
        HashMap<String, Object> label = new HashMap<String, Object>();
        label.put("position", "right");
        label.put("show", true);
        barSeries.setPropValue("label", label);
        barSeries.setColor("#6890FB");
        chart.setShowTooltip(true);
        chart.refresh();
    }
}

