/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.service.common.chart;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import yem.wm.conmmon.common.DateUtils;
import yem.wm.conmmon.common.StringUtils;
import yem.wm.service.common.chart.MyTask;

public class CustomsErrorRate
extends AbstractBillPlugIn
implements ProgresssListener {
    private static final String KEY_PROGRESSBAR = "yem_errorrate";
    public static final String CACHEKEY_PROGRESS = "progress";
    public static final String CACHEKEY_STARTPROPGRESS = "startprogress";
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"CustomsErrorRate", (int)1);

    public void afterCreateNewData(EventObject e) {
        long userOrgid = RequestContext.get().getOrgId();
        QFilter deletqFilter = new QFilter("yem_decmodtypename", "=", (Object)"\u64a4\u9500\u7533\u8bf7");
        deletqFilter.and(new QFilter("org.id", "=", (Object)userOrgid));
        DynamicObject[] deleterepairnote = BusinessDataServiceHelper.load((String)"yem_ca_repairnote", (String)"id,billno", (QFilter[])new QFilter[]{deletqFilter}, null);
        if (deleterepairnote.length > 0) {
            ((Label)this.getControl("yem_deletemonad")).setText(String.valueOf(deleterepairnote.length));
        }
        QFilter changeqFilter = new QFilter("yem_decmodtypename", "=", (Object)"\u4fee\u6539\u7533\u8bf7");
        changeqFilter.and(new QFilter("org.id", "=", (Object)userOrgid));
        DynamicObject[] changerepairnote = BusinessDataServiceHelper.load((String)"yem_ca_repairnote", (String)"id,billno", (QFilter[])new QFilter[]{changeqFilter}, null);
        if (changerepairnote.length > 0) {
            ((Label)this.getControl("yem_changemonad")).setText(String.valueOf(changerepairnote.length));
        }
        ((Label)this.getControl("yem_totalerror")).setText(String.valueOf(deleterepairnote.length + changerepairnote.length));
        this.start();
    }

    public void onProgress(ProgressEvent arg0) {
        String startProgress = this.getPageCache().get(CACHEKEY_STARTPROPGRESS);
        if (StringUtils.isBlank((String)startProgress)) {
            arg0.setProgress(0);
            return;
        }
        int progress = 0;
        String cacheProgress = this.getPageCache().get(CACHEKEY_PROGRESS);
        if (StringUtils.isNotEmpty((String)cacheProgress)) {
            progress = this.getProgress();
        }
        if (progress >= 100) {
            progress = 99;
            this.stop();
        }
        if (startProgress.equals("false")) {
            // empty if block
        }
        arg0.setProgress(progress);
    }

    public int getProgress() {
        long userOrgid = RequestContext.get().getOrgId();
        Date StartDate = DateUtils.getCurrentFirstOfYear();
        Date EndDate = DateUtils.getCurrentLastOfYear();
        int progress = 0;
        QFilter cusdecqFilter = new QFilter("org.id", "=", (Object)userOrgid);
        cusdecqFilter.and(new QFilter("yem_fddatets", ">=", (Object)StartDate));
        cusdecqFilter.and(new QFilter("yem_fddatets", "<=", (Object)EndDate));
        DynamicObject[] cusdec = BusinessDataServiceHelper.load((String)"yem_ca_cusdec", (String)"id,billno,yem_entryid", (QFilter[])new QFilter[]{cusdecqFilter}, null);
        if (cusdec.length > 0) {
            int sumcusdec = cusdec.length;
            QFilter repairqFilter = new QFilter("org.id", "=", (Object)userOrgid);
            repairqFilter.and(new QFilter("yem_ddate", ">=", (Object)StartDate));
            repairqFilter.and(new QFilter("yem_ddate", "<=", (Object)EndDate));
            DynamicObject[] repairnote = BusinessDataServiceHelper.load((String)"yem_ca_repairnote", (String)"id,billno,yem_decmodtypename", (QFilter[])new QFilter[]{repairqFilter}, null);
            if (repairnote.length > 0) {
                int sumrepairnote = repairnote.length;
                DecimalFormat df = new DecimalFormat("0.00");
                String maerialRatio = df.format((float)sumrepairnote / (float)sumcusdec * 100.0f);
                BigDecimal maerialRat = new BigDecimal(maerialRatio);
                String bd1 = maerialRat.setScale(0, 4).toString();
                progress = Integer.valueOf(bd1);
            }
        }
        return progress;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    private void start() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.start();
        this.getPageCache().put(CACHEKEY_STARTPROPGRESS, "true");
        this.getPageCache().put(CACHEKEY_PROGRESS, "0");
        MyTask myTask = new MyTask(RequestContext.get(), this.getView().getPageId());
        threadPool.execute((Runnable)myTask);
    }

    private void stop() {
        this.getPageCache().put(CACHEKEY_STARTPROPGRESS, "false");
    }
}

