/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.service.common.chart;

import com.alibaba.druid.util.StringUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;

public class Histogram
extends AbstractFormPlugin
implements TabSelectListener {
    private static LocalDate today = LocalDate.now();
    private static LocalDate MonthAgo = today.minusDays(30L);
    private static final String SELECTBYDAY = "yem_tabpageap";
    private static final String SELECTBYMONTH = "yem_tabpageap1";
    private Map<Date, Integer> dataCountMap = new HashMap<Date, Integer>();
    private Map<String, Integer> monthCountMap = new HashMap<String, Integer>();
    private DynamicObjectCollection dy = QueryServiceHelper.query((String)"yem_ca_cusdec", (String)"yem_fiedatets", null);

    public void registerListener(EventObject e) {
        TabPage searchByDate = (TabPage)this.getView().getControl(SELECTBYDAY);
        TabPage searchByMonth = (TabPage)this.getView().getControl(SELECTBYMONTH);
        Tab search = (Tab)this.getView().getControl("yem_tabap");
        searchByDate.addClickListener((ClickListener)this);
        searchByMonth.addClickListener((ClickListener)this);
        search.addTabSelectListener((TabSelectListener)this);
    }

    public void click(EventObject evt) {
        Control control = this.getControl("yem_histogramchartap");
        HistogramChart barchart = (HistogramChart)control;
        if (StringUtils.equals((String)SELECTBYDAY, (String)((TabPage)evt.getSource()).getKey())) {
            this.afterCreateNewData(evt);
        } else if (StringUtils.equals((String)SELECTBYMONTH, (String)((TabPage)evt.getSource()).getKey())) {
            this.drawChartByMonth(barchart);
        }
        barchart.refresh();
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        Control control = this.getControl("yem_histogramchartap");
        HistogramChart barchart = (HistogramChart)control;
        String subTabKey = tabSelectEvent.getTabKey();
        if (StringUtils.equals((String)SELECTBYDAY, (String)subTabKey)) {
            this.drawChartByMonth(barchart);
        } else if (StringUtils.equals((String)SELECTBYMONTH, (String)subTabKey)) {
            this.drawChart(barchart);
        }
        barchart.refresh();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Control control = this.getControl("yem_histogramchartap");
        HistogramChart barchart = (HistogramChart)control;
        this.drawChartByMonth(barchart);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void drawChart(HistogramChart barchart) {
        Histogram.setHistogram(barchart);
        barchart.setShowTooltip(true);
        barchart.setLegendVertical(true);
        Axis x = barchart.createXAxis("\u65e5\u671f", AxisType.category);
        Axis y = barchart.createYAxis("\u6570\u91cf", AxisType.value);
        String[] date = new String[30];
        LocalDate today = LocalDate.now();
        for (int i = 0; i < 30; ++i) {
            String formattedDate;
            LocalDate localdate = today.minusDays(i);
            date[i] = formattedDate = localdate.format(DateTimeFormatter.ofPattern("M\u6708d\u65e5"));
        }
        BarSeries barSeries = barchart.createBarSeries("\u62a5\u5173\u6570\u91cf");
        for (DynamicObject temp : this.dy) {
            Date d = temp.getDate("yem_fiedatets");
            if (d == null || d.compareTo(Date.from(MonthAgo.atStartOfDay(ZoneId.systemDefault()).toInstant())) < 0 || d.compareTo(Date.from(today.atStartOfDay(ZoneId.systemDefault()).toInstant())) > 0) continue;
            this.dataCountMap.put(d, this.dataCountMap.getOrDefault(date, 0) + 1);
        }
        LocalDate[] dates = new LocalDate[30];
        for (int i = 0; i < 30; ++i) {
            dates[i] = today.minusDays(i);
        }
        Number[] values = new Number[30];
        for (int i = 0; i < 30; ++i) {
            Integer value = this.dataCountMap.get(Timestamp.valueOf(dates[i].atStartOfDay()));
            values[i] = value != null ? value : 0;
        }
        x.setPropValue("data", (Object)date);
        String randomColor = "#6890FB";
        barSeries.setData(values);
        barSeries.setColor(randomColor);
        barSeries.setBarWidth("50%");
        barchart.refresh();
    }

    public void drawChartByMonth(HistogramChart barchart) {
        Histogram.setHistogram(barchart);
        Axis x = barchart.createXAxis("\u65e5\u671f", AxisType.category);
        Axis y = barchart.createYAxis("\u6570\u91cf", AxisType.value);
        String[] dates = new String[12];
        ArrayList<String> months = new ArrayList<String>(Arrays.asList("\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"));
        LocalDate today = LocalDate.now();
        for (int i = 0; i < 12; ++i) {
            dates[i] = (String)months.get(i);
        }
        int currentYear = today.getYear();
        int currentMonth = today.getMonthValue();
        ArrayList displayedMonths = new ArrayList();
        for (int i = 0; i < 12; ++i) {
            int year = currentYear;
            int month = currentMonth - i;
            if (month <= 0) {
                month += 12;
                --year;
            }
            String key = year + "\u5e74" + month + "\u6708";
            displayedMonths.add(months.get(month - 1));
            dates[i] = key;
        }
        BarSeries barSeries = barchart.createBarSeries("\u62a5\u5173\u6570\u91cf");
        block2: for (DynamicObject temp : this.dy) {
            Date d = temp.getDate("yem_fiedatets");
            if (d == null) continue;
            LocalDate localDate = d.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            String formattedDate = localDate.format(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708"));
            for (String date : dates) {
                if (!formattedDate.equals(date)) continue;
                this.monthCountMap.merge(date, 1, Integer::sum);
                continue block2;
            }
        }
        for (String date : dates) {
            if (this.monthCountMap.containsKey(date)) continue;
            this.monthCountMap.put(date, 0);
        }
        Number[] values = new Number[12];
        for (int i = 0; i < values.length; ++i) {
            LocalDate date = today.minusMonths(i);
            String formattedDate = date.format(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708"));
            if (!this.monthCountMap.containsKey(formattedDate)) continue;
            values[i] = this.monthCountMap.get(formattedDate);
        }
        dates = (String[])Arrays.stream(dates).filter(this.monthCountMap::containsKey).toArray(String[]::new);
        x.setPropValue("data", (Object)dates);
        barSeries.setData(values);
        String randomColor = "#6890FB";
        barSeries.setColor(randomColor);
        barSeries.setBarWidth("50%");
        barchart.refresh();
    }

    public static String generateRandomColor() {
        Random random = new Random();
        int red = random.nextInt(256);
        int green = random.nextInt(256);
        int blue = random.nextInt(256);
        String color = String.format("#%02x%02x%02x", red, green, blue);
        return color;
    }

    private static String[] filterDates(String[] date, Map<Date, Integer> dataCountMap) {
        SimpleDateFormat inputDateFormat = new SimpleDateFormat("M\u6708d\u65e5");
        ArrayList<String> filteredDates = new ArrayList<String>();
        Calendar currentCalendar = Calendar.getInstance();
        int currentYear = currentCalendar.get(1);
        for (String dateString : date) {
            try {
                Date parsedDate = inputDateFormat.parse(dateString);
                Calendar parsedCalendar = Calendar.getInstance();
                parsedCalendar.setTime(parsedDate);
                parsedCalendar.set(1, currentYear);
                if (!dataCountMap.containsKey(parsedCalendar.getTime())) continue;
                filteredDates.add(dateString);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return filteredDates.toArray(new String[0]);
    }

    public static void setHistogram(HistogramChart barchart) {
        barchart.clearData();
        boolean isShowTitle = true;
        barchart.setShowTitle(isShowTitle);
        barchart.setTitlePropValue("text", (Object)"\u62a5\u5173\u6570\u91cf\u7edf\u8ba1");
        boolean isShowLegend = true;
        barchart.setShowLegend(isShowLegend);
        boolean isLegendVertical = true;
        barchart.setLegendVertical(isLegendVertical);
        barchart.setLegendPropValue("right", (Object)20);
    }
}

