/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.service.common.chart;

import com.alibaba.druid.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RateEvent;
import kd.bos.form.control.events.RateListener;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;

public class Query
extends AbstractFormPlugin
implements RateListener {
    private String[] mapPlaces = new String[0];
    private Map<String, Object> mapDate = new HashMap<String, Object>();
    private DynamicObjectCollection dy = QueryServiceHelper.query((String)"yem_ca_cusdec", (String)"yem_ciqentyportcodename,yem_sumdecltotal,yem_fiedatets", null, (String)"yem_sumdecltotal");
    private BigDecimal totalAmount = BigDecimal.ZERO.setScale(2);
    private Map<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>();
    private Date beginDay = new Date(0L);
    private Date endDay = new Date(123, 11, 31);
    private String[] colors = new String[]{"#6890FB", "#A3FEB5", "#F4DE6C", "#E87278", "#87D8F7", "#5FBF92"};

    public void click(EventObject evt) {
        if (StringUtils.equals((String)"yem_query", (String)((Control)evt.getSource()).getKey())) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection rows = (DynamicObjectCollection)this.getModel().getValue("yem_haiguankouan");
            if (rows != null) {
                this.mapPlaces = new String[rows.size()];
                int i = 0;
                for (DynamicObject row : rows) {
                    String basedataName;
                    DynamicObject basedataObj = row.getDynamicObject("fbasedataid");
                    this.mapPlaces[i] = basedataName = basedataObj.get("name").toString();
                    ++i;
                }
            }
            DateRangeEdit headFieldEdit = (DateRangeEdit)this.getView().getControl("yem_daterangefield");
            String key_headdatestart = headFieldEdit.getStartDateFieldKey();
            String key_headdateend = headFieldEdit.getEndDateFieldKey();
            Date headdatestart = (Date)this.getModel().getValue(key_headdatestart);
            Date headdateend = (Date)this.getModel().getValue(key_headdateend);
            if (headdatestart != null) {
                this.beginDay = headdatestart;
            }
            if (headdateend != null) {
                this.endDay = headdateend;
            }
        }
        PieChart pieChart = (PieChart)this.getControl("yem_piechartap");
        this.drawChart(pieChart);
        pieChart.refresh();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        PieChart pieChart = (PieChart)this.getControl("yem_piechartap");
        this.drawChart(pieChart);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void update(RateEvent evt) {
        PieChart pieChart = (PieChart)this.getControl("yem_piechartap");
        this.drawChart(pieChart);
        pieChart.refresh();
    }

    public void drawChart(PieChart pieChart) {
        BigDecimal b;
        BigDecimal a;
        HashMap<String, BigDecimal> queryAmountMap;
        ItemValue[] data;
        pieChart.clearData();
        pieChart.setLegendVertical(true);
        pieChart.setShowTooltip(true);
        pieChart.setLegendPropValue("right", (Object)0);
        pieChart.setLegendPropValue("bottom", (Object)100);
        pieChart.setMargin(Position.top, "20px");
        PieSeries series = pieChart.createPieSeries("\u62a5\u5173\u91d1\u989d");
        series.setRadius("60%", "80%");
        series.setCenter("50%", "60%");
        series.setPropValue("height", (Object)"100%");
        for (DynamicObject temp : this.dy) {
            String haiguankouan = temp.getString("yem_ciqentyportcodename");
            BigDecimal amount = temp.getBigDecimal("yem_sumdecltotal").stripTrailingZeros();
            Date date = temp.getDate("yem_fiedatets");
            if (date == null || date.compareTo(this.beginDay) < 0 || date.compareTo(this.endDay) > 0) continue;
            if (this.amountMap.containsKey(haiguankouan)) {
                BigDecimal currentAmount = this.amountMap.get(haiguankouan);
                this.amountMap.put(haiguankouan, currentAmount.add(amount));
            } else {
                this.amountMap.put(haiguankouan, amount);
            }
            this.totalAmount = this.totalAmount.add(amount);
        }
        if (this.mapPlaces.length > 10) {
            data = new ItemValue[6];
            queryAmountMap = new HashMap<String, BigDecimal>();
            for (int i = 0; i < this.mapPlaces.length; ++i) {
                queryAmountMap.put(this.mapPlaces[i], this.amountMap.get(this.mapPlaces[i]));
            }
            List top6Entries = queryAmountMap.entrySet().stream().map(entry -> {
                if (entry.getValue() == null) {
                    entry.setValue(BigDecimal.ZERO);
                }
                return entry;
            }).sorted(Map.Entry.comparingByValue().reversed()).limit(6L).collect(Collectors.toList());
            for (int i = 0; i < 6; ++i) {
                ItemValue data2;
                a = (BigDecimal)((Map.Entry)top6Entries.get(i)).getValue();
                b = this.totalAmount;
                BigDecimal c = a.divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP);
                String randomColor = this.colors[i];
                data[i] = data2 = new ItemValue((String)((Map.Entry)top6Entries.get(i)).getKey(), (Number)c.setScale(2, RoundingMode.DOWN), randomColor);
            }
            Label label = new Label();
            label.setShow(true);
            label.setFormatter("{b}\n{c}");
            series.setLabel(label);
            series.setData(data);
        } else if (this.mapPlaces.length == 0) {
            data = new ItemValue[6];
            List top6Entries = this.amountMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(6L).collect(Collectors.toList());
            for (int i = 0; i < top6Entries.size(); ++i) {
                ItemValue data2;
                BigDecimal a2 = (BigDecimal)((Map.Entry)top6Entries.get(i)).getValue();
                BigDecimal b2 = this.totalAmount;
                BigDecimal c = a2.divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP);
                String randomColor = this.colors[i];
                data[i] = data2 = new ItemValue((String)((Map.Entry)top6Entries.get(i)).getKey(), (Number)c.setScale(2, RoundingMode.DOWN), randomColor);
            }
            boolean isEmpty = true;
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == null) continue;
                isEmpty = false;
                break;
            }
            if (!isEmpty) {
                Label label = new Label();
                label.setShow(true);
                label.setFormatter("{b}\n{c}");
                series.setLabel(label);
                series.setData(data);
            }
        } else {
            data = new ItemValue[this.mapPlaces.length];
            queryAmountMap = new HashMap();
            for (int i = 0; i < this.mapPlaces.length; ++i) {
                if (this.amountMap.containsKey(this.mapPlaces[i])) {
                    queryAmountMap.put(this.mapPlaces[i], this.amountMap.get(this.mapPlaces[i]));
                    continue;
                }
                queryAmountMap.put(this.mapPlaces[i], BigDecimal.ZERO);
            }
            List top6Entries = queryAmountMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(this.mapPlaces.length).collect(Collectors.toList());
            for (int i = 0; i < this.mapPlaces.length; ++i) {
                ItemValue data2;
                a = (BigDecimal)((Map.Entry)top6Entries.get(i)).getValue();
                b = this.totalAmount;
                BigDecimal c = a.divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP);
                String randomColor = this.colors[i];
                data[i] = data2 = new ItemValue((String)((Map.Entry)top6Entries.get(i)).getKey(), (Number)c.setScale(2, RoundingMode.DOWN), randomColor);
            }
            Label label = new Label();
            label.setShow(true);
            label.setFormatter("{b}\n{c}");
            series.setLabel(label);
            series.setData(data);
        }
    }
}

