/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.wmtpl.billtpl.convert;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import yem.base.common.module.amt.model.AmountModel;
import yem.base.common.module.amt.utils.AmtUtil;
import yem.base.common.utils.BigDecimalUtils;

public class BillAmountConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] findByEntityKey;
        String name = this.getTgtMainType().getName();
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity extendedDataEntity : findByEntityKey = targetExtDataEntitySet.FindByEntityKey(name)) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            this.loadData(dataEntity);
        }
    }

    private void loadData(DynamicObject dataEntity) {
        boolean inputAmt = dataEntity.getBoolean("yem_inputamount");
        boolean isTax = dataEntity.getBoolean("yem_istax");
        BigDecimal exRate = dataEntity.getBigDecimal("yem_exrate");
        DynamicObject curr = dataEntity.getDynamicObject("yem_fromcurr");
        int pricePrecision = curr == null ? 2 : curr.getInt("priceprecision");
        int amtPrecision = curr == null ? 2 : curr.getInt("amtprecision");
        DynamicObject currBase = dataEntity.getDynamicObject("yem_tocurr");
        int amtBasePrecision = currBase == null ? 2 : currBase.getInt("amtprecision");
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumAmtBase = BigDecimal.ZERO;
        BigDecimal sumAmtTax = BigDecimal.ZERO;
        BigDecimal sumAmtTaxBase = BigDecimal.ZERO;
        BigDecimal sumAmtRate = BigDecimal.ZERO;
        BigDecimal sumAmtRateBase = BigDecimal.ZERO;
        DynamicObjectCollection materialentry = dataEntity.getDynamicObjectCollection("yem_materialentry");
        DataEntityPropertyCollection properties = materialentry.getDynamicObjectType().getProperties();
        for (DynamicObject entity : materialentry) {
            BigDecimal qty = entity.getBigDecimal("yem_qty");
            BigDecimal price = entity.getBigDecimal("yem_price");
            BigDecimal taxPrice = entity.getBigDecimal("yem_pricetax");
            BigDecimal taxRate = entity.getBigDecimal("yem_taxratevalue");
            BigDecimal amt = entity.getBigDecimal("yem_amt");
            BigDecimal taxAmt = entity.getBigDecimal("yem_amttax");
            int priceUom = properties.containsKey((Object)"yem_priceuom") ? entity.getInt("yem_priceuom") : 1;
            AmountModel amountModel = AmtUtil.calculate((boolean)isTax, (boolean)inputAmt, (BigDecimal)qty, (BigDecimal)price, (BigDecimal)taxPrice, (BigDecimal)amt, (BigDecimal)taxAmt, null, (BigDecimal)taxRate, (int)priceUom, (int)pricePrecision, (int)amtPrecision);
            BigDecimal newAmt = BigDecimal.ZERO;
            BigDecimal newAmtTax = BigDecimal.ZERO;
            BigDecimal newAmtRate = BigDecimal.ZERO;
            if (inputAmt) {
                if (isTax) {
                    newAmt = amountModel.getAmt();
                } else {
                    newAmtTax = amountModel.getTaxAmt();
                }
                entity.set("yem_price", (Object)amountModel.getPrice());
                entity.set("yem_pricetax", (Object)amountModel.getTaxPrice());
            } else {
                if (isTax) {
                    entity.set("yem_price", (Object)amountModel.getPrice());
                } else {
                    entity.set("yem_pricetax", (Object)amountModel.getTaxPrice());
                }
                newAmt = amountModel.getAmt();
                newAmtTax = amountModel.getTaxAmt();
            }
            newAmtRate = amountModel.getTax();
            entity.set("yem_amt", (Object)newAmt);
            entity.set("yem_amttax", (Object)newAmtTax);
            entity.set("yem_taxrateamt", (Object)newAmtRate);
            BigDecimal amtBase = BigDecimalUtils.multiply((BigDecimal)newAmt, (BigDecimal)exRate, (int)amtBasePrecision);
            BigDecimal newAmtTaxBase = BigDecimalUtils.multiply((BigDecimal)newAmtTax, (BigDecimal)exRate, (int)amtBasePrecision);
            BigDecimal newAmtRateBase = BigDecimalUtils.multiply((BigDecimal)newAmtRate, (BigDecimal)exRate, (int)amtBasePrecision);
            entity.set("yem_amtbase", (Object)amtBase);
            entity.set("yem_amttaxbase", (Object)newAmtTaxBase);
            entity.set("yem_taxrateamtbase", (Object)newAmtRateBase);
            sumAmt = sumAmt.add(newAmt);
            sumAmtBase = sumAmtBase.add(amtBase);
            sumAmtTax = sumAmtTax.add(newAmtTax);
            sumAmtTaxBase = sumAmtTaxBase.add(newAmtTaxBase);
            sumAmtRate = sumAmtRate.add(newAmtRate);
            sumAmtRateBase = sumAmtRateBase.add(newAmtRateBase);
        }
        dataEntity.set("yem_amount", (Object)sumAmt);
        dataEntity.set("yem_amountbase", (Object)sumAmtBase);
        dataEntity.set("yem_amounttax", (Object)sumAmtTax);
        dataEntity.set("yem_amounttaxbase", (Object)sumAmtTaxBase);
        dataEntity.set("yem_taxrateamount", (Object)sumAmtRate);
        dataEntity.set("yem_taxrateamountbase", (Object)sumAmtRateBase);
    }
}

