/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.wmtpl.billtpl.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import yem.base.common.utils.OrgUtil;
import yem.base.common.utils.StringUtils;
import yem.base.common.utils.YEM;
import yem.wm.base.com.component.utils.ComponentUtil;

public class BillTplBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter fsp = e.getFormShowParameter();
        String billtype = fsp.getFormConfig().getEntityTypeId();
        DynamicObject template = ComponentUtil.loadTemplate((String)billtype);
        if (template != null) {
            List compIds = ComponentUtil.getCompIds((DynamicObject)template);
            for (Long compId : compIds) {
                DynamicObject compBill = BusinessDataServiceHelper.loadSingleFromCache((Object)compId, (String)"yem_com_regcomponent");
                String plugin = compBill.getString("yem_plugin");
                if (!YEM.isNotEmpty((Object)plugin)) continue;
                fsp.addCustPlugin(plugin);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (YEM.isEmpty((Object)org)) {
            return;
        }
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)YEM.getCurrentUserId(), (String)"bos_user");
        this.setDeptValue(user, org, model, true);
        DynamicObject[] operatorgroup = BusinessDataServiceHelper.load((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C"), BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)org.getLong("id")), new QFilter("entryentity.operator", "=", (Object)YEM.getCurrentUserId())});
        if (operatorgroup.length > 0) {
            model.setValue("yem_bizgroup", (Object)operatorgroup[0].getLong("id"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        boolean isSuccess = false;
        if (afterDoOperationEventArgs.getOperationResult() != null) {
            isSuccess = afterDoOperationEventArgs.getOperationResult().isSuccess();
        }
        if (StringUtils.isNotEmpty((String)(key = afterDoOperationEventArgs.getOperateKey())) && isSuccess && key.equals("yem_bizcanceledit")) {
            this.showCancelReasonEditForm(afterDoOperationEventArgs);
        }
        if (StringUtils.isNotEmpty((String)key) && isSuccess && key.equals("yem_bothattachload")) {
            this.bothAttachLoad();
        }
    }

    private void bothAttachLoad() {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("yem_wmtpl_attachmentback");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(formShowParameter);
    }

    private void showCancelReasonEditForm(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (YEM.isNotEmpty((Object)operationResult) && operationResult.isSuccess()) {
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("yem_wmtpl_cancelreason");
            formShowParameter.setCustomParam("formids", (Object)String.valueOf(model.getValue("id")));
            formShowParameter.setCustomParam("formkey", (Object)model.getDataEntityType().getName());
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            view.showForm(formShowParameter);
        }
    }

    private void setDeptValue(DynamicObject user, DynamicObject org, IDataModel model, boolean ischange) {
        Long deptId;
        List<Long> orgSubDeptIds = this.getOrgSubDept(org);
        DynamicObject[] orgrelation_dept = BusinessDataServiceHelper.load((String)"bos_org_orgrelation_dept", (String)"toorg", (QFilter[])new QFilter[]{new QFilter("fromorg", "=", (Object)org.getLong("id"))});
        List deptIds = Arrays.stream(orgrelation_dept).filter(x -> x.getDynamicObject("toorg") != null).map(x -> x.getDynamicObject("toorg").getLong("id")).collect(Collectors.toList());
        orgSubDeptIds.addAll(deptIds);
        DynamicObjectCollection entryentity = user.getDynamicObjectCollection("entryentity");
        List userDeptIdInfor = entryentity.stream().filter(x -> orgSubDeptIds.contains(x.getDynamicObject("dpt").getLong("id"))).collect(Collectors.toList());
        List ispartjob_true = userDeptIdInfor.stream().filter(x -> x.getBoolean("ispartjob")).map(x -> x.getDynamicObject("dpt").getLong("id")).collect(Collectors.toList());
        List ispartjob_false = userDeptIdInfor.stream().filter(x -> !x.getBoolean("ispartjob")).map(x -> x.getDynamicObject("dpt").getLong("id")).collect(Collectors.toList());
        Long l = ispartjob_true.size() > 0 ? (Long)ispartjob_true.get(0) : (deptId = ispartjob_false.size() > 0 ? (Long)ispartjob_false.get(0) : Long.valueOf(0L));
        if (ischange) {
            model.setValue("yem_department", (Object)deptId);
        } else {
            DynamicObject dataEntity = model.getDataEntity(true);
            this.getModel().updateCache();
            dataEntity.set("yem_department", (Object)deptId);
            this.getView().updateView("yem_department");
        }
    }

    private List<Long> getOrgSubDept(DynamicObject org) {
        DynamicObject[] depts = BusinessDataServiceHelper.load((String)"bos_adminorg", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C"), new QFilter("structure.fullname", "like", (Object)("%" + org.getString("name") + "%")), new QFilter("orgpattern.number", "=", (Object)"Orgform06")});
        return Arrays.stream(depts).map(x -> x.getLong("id")).collect(Collectors.toList());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "org": {
                this.orgProPertyChanged();
                break;
            }
            case "yem_department": {
                this.deptProPretyChanged();
                break;
            }
            case "yem_operator": {
                this.operatorProPertyChanged();
            }
        }
    }

    private void operatorProPertyChanged() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject operator = (DynamicObject)model.getValue("yem_operator");
        if (operator == null) {
            return;
        }
        operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getLong("id"), (String)operator.getDataEntityType().getName());
        this.setDeptValue(operator, org, model, false);
    }

    private void deptProPretyChanged() {
        IDataModel model = this.getModel();
        DynamicObject department = (DynamicObject)model.getValue("yem_department");
        DynamicObject operator = (DynamicObject)model.getValue("yem_operator");
        if (operator != null) {
            operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getLong("id"), (String)operator.getDataEntityType().getName());
            DynamicObjectCollection entryentity = operator.getDynamicObjectCollection("entryentity");
            List deptIds = entryentity.stream().map(x -> x.getDynamicObject("dpt").getLong("id")).collect(Collectors.toList());
            if (department != null && !deptIds.contains(department.getLong("id"))) {
                model.setValue("yem_operator", null);
            }
        }
    }

    private void orgProPertyChanged() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            DynamicObject operator = (DynamicObject)model.getValue("yem_operator");
            if (operator == null) {
                return;
            }
            operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getLong("id"), (String)operator.getDataEntityType().getName());
            this.setDeptValue(operator, org, model, true);
        }
    }

    public void registerListener(EventObject e) {
        ((BasedataEdit)this.getControl("org")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("yem_department")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("yem_bizgroup")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("yem_operator")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit yem_org = (BasedataEdit)this.getControl("yem_org");
        if (yem_org != null) {
            yem_org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "org": 
            case "yem_org": {
                this.setOrgF7Filter(e, name);
                break;
            }
            case "yem_department": {
                this.setDeptF7Filter(e);
                break;
            }
            case "yem_bizgroup": {
                this.setGroupF7Filter(e);
                break;
            }
            case "yem_operator": {
                this.setOperatorF7Filter(e);
            }
        }
    }

    private void setOperatorF7Filter(BeforeF7SelectEvent e) {
        IDataModel model = this.getView().getModel();
        DynamicObject yemDepartment = (DynamicObject)model.getValue("yem_department");
        DynamicObject bizgroup = (DynamicObject)model.getValue("yem_bizgroup");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (yemDepartment != null) {
            qFilters.add(new QFilter("entryentity.dpt", "=", (Object)yemDepartment.getLong("id")));
        }
        if (bizgroup != null) {
            bizgroup = BusinessDataServiceHelper.loadSingleFromCache((Object)bizgroup.getLong("id"), (String)bizgroup.getDataEntityType().getName());
            DynamicObjectCollection entryentity = bizgroup.getDynamicObjectCollection("entryentity");
            List userIds = entryentity.stream().filter(x -> x.getDynamicObject("operator") != null).map(x -> x.getDynamicObject("operator").getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", userIds));
        }
        if (qFilters.size() > 0) {
            this.f7SetFilters(e, qFilters);
        }
    }

    private void setGroupF7Filter(BeforeF7SelectEvent e) {
        DynamicObject yem_operator = (DynamicObject)this.getModel().getValue("yem_operator");
        if (yem_operator == null) {
            return;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("entryentity.operator", "in", (Object)yem_operator.getLong("id")));
        this.f7SetFilters(e, qFilters);
    }

    private void setOrgF7Filter(BeforeF7SelectEvent e, String name) {
        boolean isFieldExist = MetadataServiceHelper.getDataEntityType((String)this.getView().getEntityId()).getAllFields().containsKey("yem_orgtype");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("orgpattern", "in", (Object)OrgUtil.getOrgPattern()));
        if (isFieldExist) {
            String yem_orgtype = (String)this.getModel().getValue("yem_orgtype");
            if ("org".equals(name) || yem_orgtype.equals("bos_org") && "yem_org".equals(name)) {
                this.f7SetFilters(e, qFilters);
            }
        } else {
            this.f7SetFilters(e, qFilters);
        }
    }

    public void setDeptF7Filter(BeforeF7SelectEvent e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        List<Long> orgSubDept = this.getOrgSubDept(org);
        DynamicObject[] orgrelation_dept = BusinessDataServiceHelper.load((String)"bos_org_orgrelation_dept", (String)"toorg", (QFilter[])new QFilter[]{new QFilter("fromorg", "=", (Object)org.getLong("id"))});
        List deptIds = Arrays.stream(orgrelation_dept).filter(x -> x.getDynamicObject("toorg") != null).map(x -> x.getDynamicObject("toorg").getLong("id")).collect(Collectors.toList());
        orgSubDept.addAll(deptIds);
        qFilters.add(new QFilter("id", "in", orgSubDept));
        this.f7SetFilters(e, qFilters);
    }

    private void f7SetFilters(BeforeF7SelectEvent e, List<QFilter> qFilters) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setQFilters(qFilters);
    }
}

