/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.wmtpl.billtpl.form;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import yem.base.common.module.amt.utils.AmtUtil;
import yem.base.common.utils.BigDecimalUtils;

public class BillTplEntryBillPlugin
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.amtFieldEnableSet();
    }

    private void amtFieldEnableSet() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("yem_istax");
        boolean inputAmt = (Boolean)model.getValue("yem_inputamount");
        DynamicObjectCollection entryEntity = model.getEntryEntity("yem_materialentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            view.setEnable(Boolean.valueOf(isTax && !inputAmt), i, new String[]{"yem_pricetax"});
            view.setEnable(Boolean.valueOf(isTax && inputAmt), i, new String[]{"yem_amttax"});
            view.setEnable(Boolean.valueOf(!isTax && !inputAmt), i, new String[]{"yem_price"});
            view.setEnable(Boolean.valueOf(!isTax && inputAmt), i, new String[]{"yem_amt"});
            view.setEnable(Boolean.valueOf(inputAmt), i, new String[]{"yem_taxrateamt"});
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryKey = e.getEntryProp().getName();
        if ("yem_materialentry".equals(entryKey)) {
            this.amtFieldEnableSet();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        switch (fieldKey) {
            case "yem_inputamount": {
                this.amtFieldEnableSet();
                break;
            }
            case "yem_istax": {
                this.isTaxChanged();
                this.amtFieldEnableSet();
                break;
            }
            case "yem_qty": 
            case "yem_priceuom": 
            case "yem_taxratevalue": 
            case "yem_price": 
            case "yem_pricetax": {
                this.calculateAndSetEntryValue(e, fieldKey);
                break;
            }
            case "yem_amt": {
                this.calculateAndSetEntryValue(e, fieldKey);
                this.calculateBaseAmt("yem_amt", "yem_amtbase", rowIndex);
                break;
            }
            case "yem_amttax": {
                this.calculateAndSetEntryValue(e, fieldKey);
                this.calculateBaseAmt("yem_amttax", "yem_amttaxbase", rowIndex);
                break;
            }
            case "yem_taxrateamt": {
                this.calculateBaseAmt("yem_taxrateamt", "yem_taxrateamtbase", rowIndex);
                break;
            }
            case "yem_exrate": {
                this.exRateChanged();
                break;
            }
        }
    }

    private void exRateChanged() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("yem_materialentry");
        for (int i = 0; i < entry.size(); ++i) {
            this.calculateBaseAmt("yem_amt", "yem_amtbase", i);
            this.calculateBaseAmt("yem_amttax", "yem_amttaxbase", i);
            this.calculateBaseAmt("yem_taxrateamt", "yem_taxrateamtbase", i);
        }
    }

    private void calculateBaseAmt(String fieldKey, String amtBaseFieldKey, int rowIndex) {
        IDataModel model = this.getModel();
        BigDecimal exRate = (BigDecimal)model.getValue("yem_exrate");
        DynamicObject curr = (DynamicObject)model.getValue("yem_tocurr");
        int amtPrecision = curr == null ? 2 : curr.getInt("amtprecision");
        BigDecimal amt = (BigDecimal)model.getValue(fieldKey, rowIndex);
        BigDecimal amtBase = BigDecimalUtils.multiply((BigDecimal)amt, (BigDecimal)exRate, (int)amtPrecision);
        model.setValue(amtBaseFieldKey, (Object)amtBase, rowIndex);
    }

    private void calculateAndSetEntryValue(PropertyChangedArgs e, String fieldKey) {
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        boolean inputAmt = (Boolean)model.getValue("yem_inputamount");
        boolean isTax = (Boolean)model.getValue("yem_istax");
        if (!(!"yem_amttax".equals(fieldKey) || inputAmt && isTax)) {
            return;
        }
        if ("yem_amt".equals(fieldKey) && (!inputAmt || isTax)) {
            return;
        }
        if ("yem_pricetax".equals(fieldKey) && (inputAmt || !isTax)) {
            return;
        }
        if ("yem_price".equals(fieldKey) && (inputAmt || isTax)) {
            return;
        }
        DynamicObject curr = (DynamicObject)model.getValue("yem_fromcurr");
        int pricePrecision = curr == null ? 2 : curr.getInt("priceprecision");
        int amtPrecision = curr == null ? 2 : curr.getInt("amtprecision");
        DynamicObject entity = model.getEntryRowEntity("yem_materialentry", rowIndex);
        AmtUtil.calculateAndSetEntryValue((boolean)isTax, (boolean)inputAmt, (String)"yem_qty", (String)"yem_price", (String)"yem_pricetax", (String)"yem_priceuom", (String)"yem_taxratevalue", (String)"yem_amt", (String)"yem_amttax", (String)"yem_taxrateamt", (int)pricePrecision, (int)amtPrecision, (DynamicObject)entity, (IFormView)view, (int)rowIndex);
    }

    private void isTaxChanged() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        boolean inputAmt = (Boolean)model.getValue("yem_inputamount");
        boolean isTax = (Boolean)model.getValue("yem_istax");
        DynamicObject curr = (DynamicObject)model.getValue("yem_fromcurr");
        int pricePrecision = curr == null ? 2 : curr.getInt("priceprecision");
        int amtPrecision = curr == null ? 2 : curr.getInt("amtprecision");
        DynamicObjectCollection entryEntity = model.getEntryEntity("yem_materialentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject row = (DynamicObject)entryEntity.get(i);
            AmtUtil.calculateAndSetEntryValue((boolean)isTax, (boolean)inputAmt, (String)"yem_qty", (String)"yem_price", (String)"yem_pricetax", (String)"yem_priceuom", (String)"yem_taxratevalue", (String)"yem_amt", (String)"yem_amttax", (String)"yem_taxrateamt", (int)pricePrecision, (int)amtPrecision, (DynamicObject)row, (IFormView)view, (int)i);
        }
    }
}

