/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.wmtpl.billtpl.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ToolbarAp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.utils.YEM;

public class TpvChangePlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(TpvChangePlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        TpvChangePlugin.pageCacheSetValue(this.getModel(), this.getPageCache(), operate);
        if ("tpv_changetem".equals(operateKey)) {
            TpvChangePlugin.doChange(args, this.getModel(), this.getView(), this.getPageCache());
        } else {
            String param = this.getPageCache().get("change");
            if (kd.bos.util.StringUtils.isNotEmpty((String)param) && Boolean.parseBoolean(param)) {
                operate.getOption().setVariableValue("tpv_changetem", "true");
            } else {
                operate.getOption().setVariableValue("tpv_changetem", "false");
            }
        }
    }

    public static void doChange(BeforeDoOperationEventArgs args, IDataModel model, IFormView view, IPageCache pageCache) {
        DynamicObject data = model.getDataEntity();
        boolean lock = MutexHelper.require((IFormView)view, (String)data.getDynamicObjectType().getName(), (Object)data.getPkValue(), (String)"tpv_changetem", (boolean)false, (StringBuilder)new StringBuilder());
        if (lock) {
            args.setCancel(true);
            String billstatus = data.getString("billstatus");
            if ("C".equals(billstatus) || "B".equals(billstatus)) {
                pageCache.put("change", "true");
                pageCache.put("billstatus", data.getString("billstatus"));
                pageCache.put("id", data.getDataEntityType().getName() + "-" + data.getString("id"));
                data.set("billstatus", (Object)"A");
                List<String> itemkeys = TpvChangePlugin.recoverVisible(view);
                if (null != itemkeys && itemkeys.size() > 0) {
                    view.setVisible(Boolean.FALSE, itemkeys.toArray(new String[0]));
                }
                view.updateView();
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)data.getPkValue(), (String)data.getDynamicObjectType().getName());
                object.set("billstatus", (Object)"A");
                SaveServiceHelper.update((DynamicObject)object);
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u662f\u5df2\u5ba1\u6838\u6216\u5df2\u63d0\u4ea4\u7684\u6570\u636e\u624d\u53ef\u4ee5\u5feb\u901f\u4fee\u6539\u3002", (String)"MasterDataHelper_0", (String)"bd-master-business", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public static List<String> recoverVisible(IFormView view) {
        String id = MetadataDao.getIdByNumber((String)view.getModel().getDataEntityType().getName(), (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        List items = formMeta.getItems();
        ArrayList<String> itemkeys = new ArrayList<String>();
        for (ControlAp item : items) {
            String name = item.getName().getLocaleValue();
            String key = item.getKey();
            if (!"titlepanelflex".equals(key)) continue;
            for (ControlAp itemDown : ((FlexPanelAp)item).getItems()) {
                String keyDowm = itemDown.getKey();
                if (!"titlepanel".equals(keyDowm)) continue;
                for (ControlAp itemDownDowm : ((FlexPanelAp)itemDown).getItems()) {
                    String keyDowmDowm = itemDownDowm.getKey();
                    if (!"tbmain".equals(keyDowmDowm)) continue;
                    for (ControlAp itemDownDowmDowm : ((ToolbarAp)itemDownDowm).getItems()) {
                        String keyDowmDowmDowm = itemDownDowmDowm.getKey();
                        if ("bar_save".equals(keyDowmDowmDowm) || "bar_close".equals(keyDowmDowmDowm)) continue;
                        itemkeys.add(keyDowmDowmDowm);
                    }
                }
            }
        }
        return itemkeys;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        String param = this.getPageCache().get("change");
        if ("bar_close".equals(key) && kd.bos.util.StringUtils.isNotEmpty((String)param) && Boolean.parseBoolean(param)) {
            TpvChangePlugin.restoreData(this.getView(), this.getPageCache());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String param = this.getPageCache().get("change");
        if (kd.bos.util.StringUtils.isNotEmpty((String)param) && Boolean.parseBoolean(param)) {
            TpvChangePlugin.restoreData(this.getView(), this.getPageCache());
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        String param = this.getPageCache().get("change");
        if (kd.bos.util.StringUtils.isNotEmpty((String)param) && Boolean.parseBoolean(param)) {
            TpvChangePlugin.restoreData(this.getView(), this.getPageCache());
        }
    }

    public static void restoreData(IFormView view, IPageCache pageCache) {
        String[] object;
        Long pk = 0L;
        String dynamicObjectType = "";
        String id = pageCache.get("id");
        if (StringUtils.isNotEmpty((CharSequence)id) && (object = id.split("-")) != null && object.length >= 1) {
            dynamicObjectType = object[0];
            pk = Long.parseLong(object[1]);
        }
        if (pk != 0L) {
            try {
                DynamicObject objectS = BusinessDataServiceHelper.loadSingle((Object)pk, (String)dynamicObjectType);
                String billstatus = pageCache.get("billstatus");
                if (YEM.isNotEmpty((Object)billstatus)) {
                    objectS.set("billstatus", (Object)billstatus);
                }
                SaveServiceHelper.update((DynamicObject)objectS);
            }
            catch (Exception var7) {
                log.error(var7.getLocalizedMessage());
            }
        }
        pageCache.remove("id");
        pageCache.remove("billstatus");
        pageCache.remove("change");
    }

    public static void pageCacheSetValue(IDataModel model, IPageCache pageCache, FormOperate oper) {
        Long pkId = (Long)model.getDataEntity().getPkValue();
        if (oper.getOperateKey().equals("copy")) {
            if (pkId == 0L) {
                return;
            }
            pageCache.put("copyMatId", String.valueOf(pkId));
        } else if (oper.getOperateKey().equals("new") && pkId == 0L) {
            pageCache.put("dataid", String.valueOf(pkId));
        }
    }
}

