/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.wmtpl.company.dynamic;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.wm.wmtpl.company.utils.BothCardHelper;

public class CompanyBankInforFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        EntryGrid entryGrid = (EntryGrid)view.getControl("yem_entryentity");
        List properties_this = entryGrid.getItems().stream().map(Control::getKey).collect(Collectors.toList());
        DynamicObject org = (DynamicObject)parentModel.getValue("yem_org");
        if (org != null) {
            org = BusinessDataServiceHelper.loadSingleFromCache((Object)org.getLong("id"), (String)org.getDataEntityType().getName());
            DynamicObjectCollection banksentry = org.getDynamicObjectCollection("yem_banksentry");
            DataEntityPropertyCollection properties = banksentry.getDynamicObjectType().getProperties();
            for (DynamicObject bank : banksentry) {
                int row = model.createNewEntryRow("yem_entryentity");
                for (IDataEntityProperty property : properties) {
                    String name = property.getName();
                    if (!properties_this.contains(name)) continue;
                    model.setValue(name, bank.get(name), row);
                }
            }
            this.getView().addClientCallBack("yem_entryentity");
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String name = e.getName();
        if ("yem_entryentity".equals(name)) {
            BothCardHelper.setDefaultBase(this.getView(), "yem_org");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            BothCardHelper.closeParentValue(this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }
}

