/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.wmtpl.company.dynamic;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.wm.wmtpl.company.utils.BothCardHelper;

public class CusBankFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)this.getControl("yem_entryentity");
        List properties_this = entryGrid.getItems().stream().map(Control::getKey).collect(Collectors.toList());
        IDataModel parentModel = this.getView().getParentView().getModel();
        DynamicObject customer = (DynamicObject)parentModel.getValue("yem_customer");
        if (customer != null) {
            customer = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getLong("id"), (String)customer.getDataEntityType().getName());
            DynamicObjectCollection banksentry = customer.getDynamicObjectCollection("entry_bank");
            DataEntityPropertyCollection properties = banksentry.getDynamicObjectType().getProperties();
            for (DynamicObject bank : banksentry) {
                int row = model.createNewEntryRow("yem_entryentity");
                for (IDataEntityProperty property : properties) {
                    String name = property.getName();
                    if (!properties_this.contains(name)) continue;
                    model.setValue(name, bank.get(name), row);
                }
                model.setValue("yem_customeracct", bank.get("bankaccount"), row);
                model.setValue("yem_customeracctname", bank.get("accountname"), row);
                DynamicObject bankf7 = bank.getDynamicObject("bank");
                model.setValue("yem_customerbankf7", (Object)bankf7, row);
                model.setValue("yem_customerbank", (Object)(bankf7 != null ? bankf7.getString("name") : ""), row);
                model.setValue("yem_customercurr", bank.get("currency"), row);
                model.setValue("yem_customerisdef", bank.get("isdefault_bank"), row);
            }
            this.getView().addClientCallBack("yem_entryentity");
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String name = e.getName();
        if ("yem_entryentity".equals(name)) {
            BothCardHelper.setDefaultBase(this.getView(), "yem_customer");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            BothCardHelper.closeParentValue(this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }
}

