/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.wmtpl.company.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.DynamicObjectUtil;

public class BothCardHelper {
    public static void fillCoInfo(AbstractBillPlugIn form, DynamicObject org, boolean isValue) {
        String yem_orgtype;
        IFormView view = form.getView();
        IDataModel model = view.getModel();
        if (isValue) {
            model.setValue("yem_org", (Object)org.getLong("id"));
        }
        if ("yem_bd_companyinfo".equals(yem_orgtype = (String)model.getValue("yem_orgtype"))) {
            if (org != null) {
                model.setValue("yem_companyaddr", (Object)org.getString("yem_addresscn"));
                List<String> fields = BothCardHelper.getFlexFields(view, "yem_companyinfo");
                DynamicObjectCollection banksentry = org.getDynamicObjectCollection("yem_banksentry");
                List banksentryDefault = banksentry.stream().filter(x -> x.getBoolean("yem_isdefaultbank")).collect(Collectors.toList());
                if (banksentryDefault.size() > 0) {
                    DynamicObject row = (DynamicObject)banksentryDefault.get(0);
                    BothCardHelper.setSameFieldValue(model, row, fields);
                } else {
                    model.setValue("yem_companybank", null);
                    model.setValue("yem_companyacct", null);
                }
                DynamicObjectCollection linkmanentry = org.getDynamicObjectCollection("yem_linkmanentry");
                List manentryDefault = linkmanentry.stream().filter(x -> x.getBoolean("yem_isdefaultlinkman")).collect(Collectors.toList());
                if (manentryDefault.size() > 0) {
                    DynamicObject row = (DynamicObject)linkmanentry.get(0);
                    BothCardHelper.setSameFieldValue(model, row, fields);
                    model.setValue("yem_companylinkman", row.get("yem_contactperson"));
                    model.setValue("yem_companytel", row.get("yem_phonenum"));
                } else {
                    model.setValue("yem_companylinkman", null);
                    model.setValue("yem_companytel", null);
                }
            }
        } else {
            model.setValue("yem_companyaddr", (Object)org.getString("contactaddress"));
            DynamicObject yem_operator = (DynamicObject)model.getValue("yem_operator");
            if (yem_operator != null) {
                yem_operator = BusinessDataServiceHelper.loadSingleFromCache((Object)yem_operator.getLong("id"), (String)yem_operator.getDataEntityType().getName());
                model.setValue("yem_companylinkman", (Object)yem_operator.getString("name"));
                model.setValue("yem_companytel", (Object)yem_operator.getString("phone"));
            }
        }
    }

    public static void setSameFieldValue(IDataModel model, DynamicObject row, List<String> fields) {
        DataEntityPropertyCollection properties = row.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (!fields.contains(name)) continue;
            model.setValue(name, row.get(name));
        }
    }

    public static DynamicObject queryCompany(DynamicObject org) {
        String selectfields = DynamicObjectUtil.getSelectfields((String)"yem_bd_companyinfo", (boolean)false);
        selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"yem_bd_companyinfo", (String)"yem_banksentry", (boolean)false);
        selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"yem_bd_companyinfo", (String)"yem_linkmanentry", (boolean)false);
        return BusinessDataServiceHelper.loadSingle((String)"yem_bd_companyinfo", (String)selectfields, (QFilter[])new QFilter[]{new QFilter("yem_org", "=", (Object)org.getLong("id"))});
    }

    public static void showChangePage(AbstractBillPlugIn form, String formId) {
        IFormView view = form.getView();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(formId);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)form, formId));
        view.showForm(parameter);
    }

    public static void setCustomerInfor(AbstractFormPlugin form) {
        IFormView view = form.getView();
        IDataModel model = view.getModel();
        DynamicObject customer = (DynamicObject)model.getValue("yem_customer");
        if (customer != null) {
            customer = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getLong("id"), (String)customer.getDataEntityType().getName());
            List<String> fields = BothCardHelper.getFlexFields(view, "yem_companyinfo");
            DynamicObject bank_row = BothCardHelper.getBankDefault(customer);
            if (bank_row != null) {
                BothCardHelper.setSameFieldValue(model, bank_row, fields);
                String bank = bank_row.getDynamicObject("bank") != null ? bank_row.getDynamicObject("bank").getString("name") : "";
                model.setValue("yem_customerbank", (Object)bank);
                model.setValue("yem_customeracct", bank_row.get("bankaccount"));
            } else {
                model.setValue("yem_customerbank", null);
                model.setValue("yem_customeracct", null);
            }
            DynamicObject linkman_row = BothCardHelper.getLinkmanDefault(customer);
            if (linkman_row != null) {
                BothCardHelper.setSameFieldValue(model, linkman_row, fields);
                model.setValue("yem_customerlinkman", (Object)linkman_row.getString("contactperson"));
                model.setValue("yem_customertel", linkman_row.get("phone"));
                DynamicObject associatedaddress = linkman_row.getDynamicObject("associatedaddress");
                if (associatedaddress != null) {
                    associatedaddress = BusinessDataServiceHelper.loadSingleFromCache((Object)associatedaddress.getLong("id"), (String)associatedaddress.getDataEntityType().getName());
                    model.setValue("yem_customeraddr", associatedaddress.get("detailaddress"));
                } else {
                    model.setValue("yem_customeraddr", null);
                }
            } else {
                model.setValue("yem_customerlinkman", null);
                model.setValue("yem_customertel", null);
                model.setValue("yem_customeraddr", null);
            }
        } else {
            List<String> fields = BothCardHelper.getFlexFields(view, "yem_flex_cus_info");
            for (String field : fields) {
                model.setValue(field, null);
            }
        }
    }

    private static DynamicObject getLinkmanDefault(DynamicObject customer) {
        DynamicObjectCollection linkmanentry = customer.getDynamicObjectCollection("entry_linkman");
        List manentryDefault = linkmanentry.stream().filter(x -> x.getBoolean("isdefault_linkman")).collect(Collectors.toList());
        return manentryDefault.size() > 0 ? (DynamicObject)manentryDefault.get(0) : (linkmanentry.size() > 0 ? (DynamicObject)linkmanentry.get(0) : null);
    }

    private static DynamicObject getBankDefault(DynamicObject customer) {
        DynamicObjectCollection bankentry = customer.getDynamicObjectCollection("entry_bank");
        List bankentryDefault = bankentry.stream().filter(x -> x.getBoolean("isdefault_bank")).collect(Collectors.toList());
        return bankentryDefault.size() > 0 ? (DynamicObject)bankentryDefault.get(0) : (bankentry.size() > 0 ? (DynamicObject)bankentry.get(0) : null);
    }

    public static void setSupplierInfor(AbstractFormPlugin form) {
        IFormView view = form.getView();
        IDataModel model = view.getModel();
        DynamicObject supplier = (DynamicObject)model.getValue("yem_supplier");
        if (supplier != null) {
            supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getLong("id"), (String)supplier.getDataEntityType().getName());
            List<String> fields = BothCardHelper.getFlexFields(view, "yem_companyinfo");
            DynamicObject bank_row = BothCardHelper.getBankDefault(supplier);
            if (bank_row != null) {
                BothCardHelper.setSameFieldValue(model, bank_row, fields);
                String bank = bank_row.getDynamicObject("bank") != null ? bank_row.getDynamicObject("bank").getString("name") : "";
                model.setValue("yem_supplierbank", (Object)bank);
                model.setValue("yem_supplieracct", bank_row.get("bankaccount"));
            } else {
                model.setValue("yem_supplierbank", null);
                model.setValue("yem_supplieracct", null);
            }
            DynamicObject linkman_row = BothCardHelper.getLinkmanDefault(supplier);
            if (linkman_row != null) {
                BothCardHelper.setSameFieldValue(model, linkman_row, fields);
                model.setValue("yem_supplierlinkman", (Object)linkman_row.getString("contactperson"));
                model.setValue("yem_suppliertel", linkman_row.get("phone"));
                DynamicObject associatedaddress = linkman_row.getDynamicObject("associatedaddress");
                if (associatedaddress != null) {
                    associatedaddress = BusinessDataServiceHelper.loadSingleFromCache((Object)associatedaddress.getLong("id"), (String)associatedaddress.getDataEntityType().getName());
                    model.setValue("yem_supplieraddr", associatedaddress.get("detailaddress"));
                } else {
                    model.setValue("yem_supplieraddr", null);
                }
            } else {
                model.setValue("yem_supplierlinkman", null);
                model.setValue("yem_suppliertel", null);
                model.setValue("yem_supplieraddr", null);
            }
        } else {
            List<String> fields = BothCardHelper.getFlexFields(view, "yem_flex_gys_info");
            for (String field : fields) {
                model.setValue(field, null);
            }
        }
    }

    public static void setCustManInfor(AbstractBillPlugIn form, Object returnData) {
        DynamicObject data = (DynamicObject)returnData;
        IFormView view = form.getView();
        IDataModel model = view.getModel();
        List<String> fields = BothCardHelper.getFlexFields(view, "yem_companyinfo");
        if (data != null) {
            BothCardHelper.setSameFieldValue(model, data, fields);
        }
    }

    public static List<String> getFlexFields(IFormView view, String flexKey) {
        Container companyinfo = (Container)view.getControl(flexKey);
        ArrayList<String> fields = new ArrayList<String>();
        List<String> flexControl = companyinfo.getItems().stream().map(Control::getKey).collect(Collectors.toList());
        BothCardHelper.getFlexControl(view, fields, flexControl);
        return fields;
    }

    private static void getFlexControl(IFormView view, List<String> fields, List<String> flexControl) {
        for (String item : flexControl) {
            Control control = view.getControl(item);
            if (control instanceof Container) {
                Container flex = (Container)control;
                List<String> properties = flex.getItems().stream().map(Control::getKey).collect(Collectors.toList());
                if (properties.size() <= 0) continue;
                BothCardHelper.getFlexControl(view, fields, properties);
                continue;
            }
            if (!(control instanceof FieldEdit)) continue;
            fields.add(item);
        }
    }

    public static void closeParentValue(AbstractFormPlugin plugin) {
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        int selectRows = ((EntryGrid)view.getControl("yem_entryentity")).getEntryState().getFocusRow();
        DynamicObject row = model.getEntryRowEntity("yem_entryentity", selectRows);
        view.returnDataToParent((Object)row);
        view.close();
    }

    public static void setDefaultBase(IFormView view, String baseKey) {
        DynamicObjectCollection collection = view.getModel().getEntryEntity("yem_entryentity");
        for (int i = 0; i < collection.size(); ++i) {
            view.getModel().setValue(baseKey, view.getParentView().getModel().getValue(baseKey), i);
        }
    }
}

