/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.wmtpl.fieldmap.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.plugin.args.LoadFuncTypesEventArgs;
import kd.bos.entity.botp.runtime.ConvertFuncLoader;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;
import yem.base.common.utils.YEM;

public class FieldMapBillPlugin
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        switch (name) {
            case "yem_targetentity": {
                this.setTargetVAlue(true);
                break;
            }
            case "yem_sourcefield": {
                if (!YEM.isEmpty((Object)newValue)) break;
                this.getModel().setValue("yem_sourcekey", (Object)"", rowIndex);
                break;
            }
            case "yem_formulas": {
                if (!YEM.isEmpty((Object)newValue)) break;
                this.getModel().setValue("yem_math", (Object)"", rowIndex);
                break;
            }
        }
    }

    public void setTargetVAlue(boolean isdelete) {
        if (isdelete) {
            this.getModel().deleteEntryData("yem_fieldcontrast_e");
        }
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity("yem_fieldcontrast_e");
        List targetfield = entryRows.stream().map(x -> x.getString("yem_targetkey")).collect(Collectors.toList());
        DynamicObject targetentity = (DynamicObject)this.getModel().getValue("yem_targetentity");
        if (targetentity == null) {
            return;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)targetentity.getString("number"));
        for (EntityType entityType : dataEntityType.getAllEntities().values()) {
            for (IDataEntityProperty property : entityType.getFields().values()) {
                if (!(property instanceof IFieldHandle)) continue;
                DynamicProperty field = (DynamicProperty)property;
                String targetFieldKey = field.getName();
                String targetFieldName = this.buildPropFullCaption(property);
                if (targetfield.contains(targetFieldKey)) continue;
                int rowIndex = this.getModel().createNewEntryRow("yem_fieldcontrast_e");
                this.getModel().setValue("yem_targetkey", (Object)targetFieldKey, rowIndex);
                this.getModel().setValue("yem_targetfield", (Object)targetFieldName, rowIndex);
            }
        }
    }

    public String buildPropFullCaption(IDataEntityProperty property) {
        LocaleString displayCaption;
        ArrayList<String> captions = new ArrayList<String>();
        IDataEntityType parentType = property.getParent();
        if (parentType instanceof MainEntityType) {
            captions.add("\u5355\u636e\u5934");
        } else if (parentType instanceof EntityType) {
            displayCaption = parentType.getDisplayName();
            captions.add(displayCaption == null ? "" : displayCaption.toString());
        }
        if (property instanceof DynamicProperty) {
            displayCaption = property.getDisplayName();
            captions.add(displayCaption == null ? property.getName() : displayCaption.toString());
        } else {
            captions.add(property.getName());
        }
        return StringUtils.join((Object[])captions.toArray(), (String)".");
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"yem_sourcefield", "yem_formulas"});
        this.addItemClickListeners(new String[]{"yem_advcontoolbarap"});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "yem_sourcefield": {
                this.showSourceField();
                break;
            }
            case "yem_formulas": {
                this.showFormula();
            }
        }
    }

    public void showFormula() {
        DynamicObject sourceentity = (DynamicObject)this.getModel().getValue("yem_sourceentity");
        if (sourceentity == null) {
            this.getView().showErrorNotification("\u8bf7\u5148\u586b\u5199\u6e90\u5355\u5b9e\u4f53\u3002");
            return;
        }
        DynamicObject targetentity = (DynamicObject)this.getModel().getValue("yem_targetentity");
        MainEntityType targeEntityType = MetadataServiceHelper.getDataEntityType((String)targetentity.getString("number"));
        int row = this.getModel().getEntryCurrentRowIndex("yem_fieldcontrast_e");
        String targetPropName = (String)this.getModel().getValue("yem_targetkey", row);
        IDataEntityProperty targetProperty = targeEntityType.findProperty(targetPropName);
        if (targetProperty == null || targetProperty instanceof AttachmentProp) {
            return;
        }
        MainEntityType sourceMainType = MetadataServiceHelper.getDataEntityType((String)sourceentity.getString("number"));
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludePKField(true);
        TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceMainType, (PropTreeBuildOption)option);
        for (EntityType entityType : sourceMainType.getAllEntities().values()) {
            List childPath;
            if (entityType instanceof MainEntityType || (childPath = billTreeNode.getChildPath(entityType.getName())).size() <= 0) continue;
            billTreeNode = billTreeNode.deleteChildNode(entityType.getName());
        }
        String billNodeJson = SerializationUtils.toJsonString((Object)billTreeNode);
        String formula = (String)this.getModel().getValue("yem_math", row);
        if (StringUtils.isBlank((CharSequence)formula)) {
            CRFormula crFormula = new CRFormula();
            formula = SerializationUtils.toJsonString((Object)crFormula);
        }
        FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
        FunctionTypes cloudFunc = ConvertFuncLoader.loadBizCloudFuncTypes();
        functionTypes.getFunctionGroups().addAll(cloudFunc.getFunctionGroups());
        functionTypes.getFunctionTypes().addAll(cloudFunc.getFunctionTypes());
        LoadFuncTypesEventArgs args = new LoadFuncTypesEventArgs(functionTypes);
        String funcsXML = FunctionTypes.serializeToXML((FunctionTypes)args.getFuncTypes());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_formula");
        showParameter.getCustomParams().put("formula", formula);
        showParameter.getCustomParams().put("entitynumber", sourceentity.getString("number"));
        showParameter.getCustomParams().put("treenodes", billNodeJson);
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "yem_formulas"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void showSourceField() {
        DynamicObject sourceentity = (DynamicObject)this.getModel().getValue("yem_sourceentity");
        if (sourceentity == null) {
            this.getView().showErrorNotification("\u8bf7\u5148\u586b\u5199\u6e90\u5355\u5b9e\u4f53\u3002");
            return;
        }
        DynamicObject targetentity = (DynamicObject)this.getModel().getValue("yem_targetentity");
        MainEntityType targeEntityType = MetadataServiceHelper.getDataEntityType((String)targetentity.getString("number"));
        int row = this.getModel().getEntryCurrentRowIndex("yem_fieldcontrast_e");
        String targetFieldValue = (String)this.getModel().getValue("yem_targetkey", row);
        IDataEntityProperty targetProperty = targeEntityType.findProperty(targetFieldValue);
        if (targetProperty == null) {
            return;
        }
        MainEntityType sourceMainType = MetadataServiceHelper.getDataEntityType((String)sourceentity.getString("number"));
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludePKField(true);
        option.setIncludeEntryEntityAsKeyPrefix(true);
        option.addMatchedClassTypes(TextProp.class);
        option.addMatchedClassTypes(DecimalProp.class);
        TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceMainType, (PropTreeBuildOption)option);
        for (EntityType entityType : sourceMainType.getAllEntities().values()) {
            List childPath;
            if (entityType instanceof MainEntityType || (childPath = billTreeNode.getChildPath(entityType.getName())).size() <= 0) continue;
            billTreeNode = billTreeNode.deleteChildNode(entityType.getName());
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_variablefieldf7");
        showParameter.setCaption("\u9009\u62e9\u5355\u636e\u5b57\u6bb5");
        String nodesJson = SerializationUtils.toJsonString((Object)billTreeNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "yem_sourcefield"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        switch (actionId) {
            case "yem_sourcefield": {
                this.setSourceInfor((String)returnData);
                break;
            }
            case "yem_formulas": {
                this.setForMulas((String)returnData);
            }
        }
    }

    public void setForMulas(String returnData) {
        if (StringUtils.isNotBlank((CharSequence)returnData)) {
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)returnData, CRFormula.class);
            int row = this.getModel().getEntryCurrentRowIndex("yem_fieldcontrast_e");
            this.getModel().setValue("yem_math", (Object)returnData, row);
            this.getModel().setValue("yem_formulas", (Object)formula.getExprDesc(), row);
        }
    }

    public void setSourceInfor(String returnData) {
        if (YEM.isEmpty((Object)returnData)) {
            return;
        }
        DynamicObject sourceentity = (DynamicObject)this.getModel().getValue("yem_sourceentity");
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)sourceentity.getString("number"));
        Map plugins = (Map)SerializationUtils.fromJsonString((String)returnData, Map.class);
        String fieldCaption = (String)plugins.get("text");
        String fieldId = (String)plugins.get("id");
        String[] arr = fieldId.split("\\.");
        String dsName = "";
        Map allEntities = mainType.getAllEntities();
        boolean isBillHead = true;
        if (allEntities.containsKey(arr[0])) {
            isBillHead = false;
            dsName = ((EntityType)allEntities.get(arr[0])).getDisplayName().toString();
        } else {
            Map allFields = mainType.getAllFields();
            IDataEntityProperty property = (IDataEntityProperty)allFields.get(arr[0]);
            IDataEntityType parent = property.getParent();
            if (parent instanceof BillEntityType) {
                fieldCaption = "\u5355\u636e\u5934." + fieldCaption;
            } else if (parent instanceof EntryType) {
                fieldCaption = parent.getDisplayName().toString() + "." + fieldCaption;
            }
        }
        if (YEM.isNotEmpty((Object)fieldId)) {
            if (isBillHead && YEM.isNotEmpty((Object)dsName) && !fieldCaption.contains(dsName)) {
                fieldCaption = dsName + "." + fieldCaption;
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex("yem_fieldcontrast_e");
            this.getModel().setValue("yem_sourcekey", (Object)fieldId, rowIndex);
            this.getModel().setValue("yem_sourcefield", (Object)fieldCaption, rowIndex);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("yem_update".equals(itemKey)) {
            this.setTargetVAlue(false);
        }
    }
}

