/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cd.common.bd.decldatarule.form;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import yem.base.common.de.meta.utils.MetaPropertyHelper;
import yem.base.common.utils.YEM;
import yem.wm.customs.common.utils.FieldSelectHandler;
import yem.wm.customs.common.utils.FieldSelectHelper;
import yem.wm.customs.common.utils.MetaDataUtils;

public class DeclDataRuleAutoFormPlugin
extends AbstractBillPlugIn
implements FieldSelectHandler {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final FieldSelectHelper fieldSelectHelper = new FieldSelectHelper((FieldSelectHandler)this);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"yem_decl_field", "yem_swin_field", "yem_decl_prop"});
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject bill = (DynamicObject)model.getValue("yem_bill");
        if (bill == null || YEM.isEmpty((Object)bill.getPkValue())) {
            view.showErrorNotification("\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\uff01");
            return;
        }
        String fromBill = bill.getString("number");
        String toBill = "yem_ca_cusdec";
        int idx = model.getEntryCurrentRowIndex("yem_cd_bgdsjppgz_ppgz");
        String declEntryID = (String)model.getValue("yem_decl_entry");
        String swinEntryID = (String)model.getValue("yem_swin_entry");
        if ("yem_decl_field".equals(key)) {
            String afterName = (String)model.getValue("yem_swin_field", idx);
            MetaPropertyHelper.showPropertySelect((AbstractFormPlugin)this, (String)key, (String)fromBill, (boolean)YEM.isEmpty((Object)afterName), (Collection)Stream.of(declEntryID).collect(Collectors.toCollection(HashSet::new)));
        }
        if ("yem_swin_field".equals(key)) {
            String beforeName = (String)model.getValue("yem_decl_field", idx);
            MetaPropertyHelper.showPropertySelect((AbstractFormPlugin)this, (String)key, (String)toBill, (boolean)YEM.isEmpty((Object)beforeName), (Collection)Stream.of(swinEntryID).collect(Collectors.toCollection(HashSet::new)));
        }
        if ("yem_decl_prop".equals(key)) {
            String field = (String)model.getValue("yem_decl_field", idx);
            if (YEM.isEmpty((Object)field)) {
                view.showErrorNotification("\u8bf7\u9009\u62e9\u5b57\u6bb5\u6807\u8bc6\uff01");
                return;
            }
            String datatype = (String)model.getValue("yem_decl_type");
            if (MetaDataUtils.isBaseData((String)datatype)) {
                String baseDataType = MetaDataUtils.getBaseDataType((String)fromBill, (String)field);
                MetaPropertyHelper.showPropertySelect((AbstractFormPlugin)this, (String)key, (String)baseDataType, (boolean)false);
            } else {
                view.showErrorNotification("\u4ec5\u652f\u6301\u57fa\u7840\u8d44\u6599\uff01");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if ("yem_decl_field".equals(actionId)) {
            this.fieldSelectHelper.handleClosedCallBack(actionId, returnData, this.getModel(), "decl");
        }
        if ("yem_swin_field".equals(actionId)) {
            this.fieldSelectHelper.handleClosedCallBack(actionId, returnData, this.getModel(), "swin");
        }
        if ("yem_decl_prop".equals(actionId)) {
            this.fieldSelectHelper.handleClosedCallBack(actionId, returnData, this.getModel(), "null");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData changeData = e.getChangeSet()[0];
        IDataModel model = this.getModel();
        int rowIndex = changeData.getRowIndex();
        Object value = changeData.getNewValue();
        if ("yem_decl_field".equals(name) && YEM.isEmpty((Object)value)) {
            model.setValue("yem_decl_name", null, rowIndex);
            model.setValue("yem_decl_type", null, rowIndex);
            model.setValue("yem_decl_prop", null, rowIndex);
        }
        if ("yem_swin_field".equals(name) && YEM.isEmpty((Object)value)) {
            model.setValue("yem_swin_name", null, rowIndex);
            model.setValue("yem_swin_type", null, rowIndex);
            model.setValue("yem_swin_prop", null, rowIndex);
        }
        if ("yem_decl_prop".equals(name) && YEM.isEmpty((Object)value)) {
            model.setValue("yem_decl_propname", null, rowIndex);
        }
    }

    public String getEntryKey() {
        return "yem_cd_bgdsjppgz_ppgz";
    }

    public void updateModelValues(IDataModel model, DynamicObject dynamicObject, String middleField, int idx, String actionId) {
        String number = dynamicObject.getString("yem_number");
        String name = dynamicObject.getString("yem_name");
        String datatype = dynamicObject.getString("yem_datatype");
        if ("yem_decl_field".equals(actionId) || "yem_swin_field".equals(actionId)) {
            model.setValue("yem_" + middleField + "_field", (Object)number, idx);
            model.setValue("yem_" + middleField + "_name", (Object)name, idx);
            model.setValue("yem_" + middleField + "_type", (Object)datatype, idx);
        }
        if ("yem_decl_prop".equals(actionId)) {
            model.setValue("yem_decl_prop", (Object)number, idx);
            model.setValue("yem_decl_propname", (Object)name, idx);
        }
    }
}

