/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cd.common.bd.mergerelation.form;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import yem.base.common.de.meta.utils.MetaPropertyHelper;
import yem.base.common.utils.YEM;

public class MergeRelationBasePlugin
extends AbstractBillPlugIn {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"yem_before_name", "yem_after_name"});
    }

    public void click(EventObject e) {
        String afterName;
        super.click(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        String billtext = (String)model.getValue("yem_billtext");
        String beforeMentry = (String)model.getValue("yem_before_mentry");
        String afterMentry = (String)model.getValue("yem_after_mentry");
        int idx = model.getEntryCurrentRowIndex("yem_base_metaproperty");
        if ("yem_before_name".equals(key)) {
            if (YEM.isEmpty((Object)billtext) || YEM.isEmpty((Object)beforeMentry)) {
                return;
            }
            afterName = (String)model.getValue("yem_after_name", idx);
            MetaPropertyHelper.showPropertySelect((AbstractFormPlugin)this, (String)"before_field_key", (String)billtext, (boolean)YEM.isEmpty((Object)afterName), (Collection)Stream.of(beforeMentry).collect(Collectors.toCollection(HashSet::new)));
        }
        if ("yem_after_name".equals(key)) {
            if (YEM.isEmpty((Object)billtext) || YEM.isEmpty((Object)afterMentry)) {
                return;
            }
            afterName = (String)model.getValue("yem_before_name", idx);
            MetaPropertyHelper.showPropertySelect((AbstractFormPlugin)this, (String)"after_field_key", (String)billtext, (boolean)YEM.isEmpty((Object)afterName), (Collection)Stream.of(afterMentry).collect(Collectors.toCollection(HashSet::new)));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if ("before_field_key".equals(actionId)) {
            this.handleSelectBeforeField(returnData, "before");
        }
        if ("after_field_key".equals(actionId)) {
            this.handleSelectBeforeField(returnData, "after");
        }
    }

    private void handleSelectBeforeField(Object returnData, String middleField) {
        IDataModel model = this.getModel();
        if (!(returnData instanceof DynamicObjectCollection)) {
            return;
        }
        DynamicObjectCollection collection = (DynamicObjectCollection)returnData;
        if (collection.size() == 1) {
            this.handleSingleEntry(model, (DynamicObject)collection.get(0), middleField);
        } else {
            this.handleSingleEntry(model, (DynamicObject)collection.get(0), middleField);
            for (int i = 1; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                this.handleNewEntry(model, dynamicObject, middleField);
            }
        }
    }

    private void handleSingleEntry(IDataModel model, DynamicObject dynamicObject, String middleField) {
        int idx = model.getEntryCurrentRowIndex("yem_cd_hbfaziysb_zdgx");
        this.updateModelValues(model, dynamicObject, middleField, idx);
    }

    private void handleNewEntry(IDataModel model, DynamicObject dynamicObject, String middleField) {
        int idx = model.createNewEntryRow("yem_cd_hbfaziysb_zdgx");
        this.updateModelValues(model, dynamicObject, middleField, idx);
    }

    private void updateModelValues(IDataModel model, DynamicObject dynamicObject, String middleField, int idx) {
        String number = dynamicObject.getString("yem_number");
        String name = dynamicObject.getString("yem_name");
        String datatype = dynamicObject.getString("yem_datatype");
        String basedatakey = dynamicObject.getString("yem_basedatakey");
        model.setValue("yem_" + middleField + "_number", (Object)number, idx);
        model.setValue("yem_" + middleField + "_name", (Object)name, idx);
        model.setValue("yem_" + middleField + "_datatype", (Object)datatype, idx);
        model.setValue("yem_" + middleField + "_bdkey", (Object)basedatakey, idx);
    }
}

