/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cd.common.bill.declaredocx.dynamic;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.IntStream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.compress.utils.Lists;
import yem.base.common.utils.BigDecimalUtils;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;
import yem.wm.cd.common.bd.mergerelation.common.MergeRelation;
import yem.wm.cd.common.bill.declaredocx.dynamic.DynamicFormDataUtils;
import yem.wm.cd.common.bill.declaredocx.dynamic.MatchProgress;
import yem.wm.cd.common.bill.declaredocx.dynamic.RelationConstant;
import yem.wm.cd.common.bill.declaredocx.utils.DeclMergeUtils;
import yem.wm.customs.common.utils.MetaDataUtils;

public class DataMatchFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(DataMatchFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        FormShowParameter fsp = view.getFormShowParameter();
        Map data = (Map)fsp.getCustomParam("_data");
        if (data == null) {
            return;
        }
        if (data.containsKey("yem_declid") && data.containsKey("yem_declnum")) {
            model.setValue("yem_declid", (Object)Long.valueOf((String)data.get("yem_declid")));
            model.setValue("yem_declnum", data.get("yem_declnum"));
        }
        this.calculateOriginMatchedQuantity(parentModel, parentView);
        this.syncCurrentDeclEntryData();
        Collection<DynamicObject> swinData = this.queryAssociateSingleWindowData(model, parentModel);
        this.setValueOfSwinData(swinData, model);
        this.calculateSwinMatchedQty(model);
        this.syncCustomsDeclarationGoodsToDynamicForm(model, view);
        this.readMatchingRelationships(model, view);
    }

    private void calculateSwinMatchedQty(IDataModel model) {
        int rowCount = model.getEntryRowCount("yem_swinentry");
        for (int i = 0; i < rowCount; ++i) {
            BigDecimal total = (BigDecimal)model.getValue("yem_gqty", i);
            BigDecimal matched = (BigDecimal)model.getValue("yem_count_sw_mted", i);
            BigDecimal last = total.subtract(matched);
            model.setValue("yem_count_sw_unmt", (Object)last, i);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"yem_exit", "yem_confirm", "yem_automatch", "yem_unmatch", "yem_match"});
    }

    public void click(EventObject e) {
        super.click(e);
        IFormView view = this.getView();
        Control source = (Control)e.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        IFormView parentView = view.getParentView();
        switch (key) {
            default: {
                break;
            }
            case "yem_exit": {
                parentView.invokeOperation("refresh");
                view.sendFormAction(parentView);
                view.close();
                break;
            }
            case "yem_confirm": {
                if (!this.beforeConfirm(model, view)) {
                    return;
                }
                this.handleConfirm(model, view);
                this.afterConfirm(model, view);
                view.sendFormAction(parentView);
                break;
            }
            case "yem_match": {
                this.beforeMatch(model, view);
                this.handleMarch(model, view);
                this.afterMatch(model, view);
                view.sendFormAction(parentView);
                break;
            }
            case "yem_unmatch": {
                this.handleUnMarch(model, view);
                view.sendFormAction(parentView);
                break;
            }
            case "yem_automatch": {
                this.beforeAutoMatch(model, view);
                view.sendFormAction(parentView);
            }
        }
    }

    private boolean beforeConfirm(IDataModel model, IFormView view) {
        int rowCount = model.getEntryRowCount("yem_declentry");
        BigDecimal total = BigDecimal.ZERO;
        for (int i = 0; i < rowCount; ++i) {
            total = total.add((BigDecimal)model.getValue("yem_qty", i));
        }
        BigDecimal matched = BigDecimal.ZERO;
        int matchInfoRowCount = model.getEntryRowCount("yem_matchinfo");
        for (int i = 0; i < matchInfoRowCount; ++i) {
            matched = matched.add((BigDecimal)model.getValue("yem_qtys", i));
        }
        if (matched.compareTo(total) != 0) {
            view.showConfirm(String.format("\u5f53\u524d\u62a5\u5173\u5355\u5546\u54c1\u660e\u7ec6\u6570\u91cf %s  \u4e0e\u62a5\u5173\u5546\u54c1\u660e\u7ec6\u6570\u91cf %s \u4e0d\u4e00\u81f4\uff0c\u662f\u5426\u786e\u8ba4\uff1f", total.setScale(4, RoundingMode.HALF_UP).toPlainString(), matched.setScale(4, RoundingMode.HALF_UP).toPlainString()), MessageBoxOptions.YesNo, ConfirmTypes.Wait, new ConfirmCallBackListener("before_confirm", (IFormPlugin)this));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("before_confirm".equals(callBackId) && "Yes".equals(result.name())) {
            this.handleConfirm(model, view);
            this.afterConfirm(model, view);
        }
    }

    private void handleConfirm(IDataModel model, IFormView view) {
        this.saveMatchingRelationships(model, view);
        this.saveMarchQtyToSwin(model, view);
    }

    private void saveMarchQtyToSwin(IDataModel model, IFormView view) {
        HashMap cacheQty = Maps.newHashMap();
        HashSet swinIds = Sets.newHashSet();
        int rowCount = model.getEntryRowCount("yem_swinentry");
        for (int i = 0; i < rowCount; ++i) {
            Long swinId = (Long)model.getValue("yem_swin_id", i);
            swinIds.add(swinId);
            Long swinentryId = (Long)model.getValue("yem_swinentry_id", i);
            ArrayList qty = Lists.newArrayList();
            qty.add((BigDecimal)model.getValue("yem_count_sw_mted", i));
            qty.add((BigDecimal)model.getValue("yem_count_sw_unmt", i));
            cacheQty.put(swinentryId, qty);
        }
        ArrayList qFilters = Lists.newArrayList();
        qFilters.add(new QFilter("id", "in", (Object)swinIds));
        Collection<DynamicObject> swinDecl = this.queryMatchingSingleWindowCustomsDeclarations(qFilters);
        for (DynamicObject d : swinDecl) {
            DynamicObjectCollection c = d.getDynamicObjectCollection("yem_ca_dyckbgd_shxx");
            for (DynamicObject swinEntry : c) {
                long id = swinEntry.getLong("id");
                if (!cacheQty.containsKey(id)) continue;
                List v = (List)cacheQty.get(id);
                BigDecimal matchedQty = (BigDecimal)v.get(0);
                BigDecimal lastQty = (BigDecimal)v.get(1);
                swinEntry.set("yem_count_sw_mted", (Object)matchedQty);
                swinEntry.set("yem_count_sw_unmt", (Object)lastQty);
            }
        }
        SaveServiceHelper.save((DynamicObject[])swinDecl.toArray(new DynamicObject[0]));
    }

    private void afterConfirm(IDataModel model, IFormView view) {
        IFormView parentView = view.getParentView();
        parentView.invokeOperation("save");
        parentView.invokeOperation("refresh");
        view.sendFormAction(parentView);
        view.close();
    }

    private void beforeMatch(IDataModel model, IFormView view) {
        BigDecimal last;
        EntryGrid declEntry = (EntryGrid)this.getControl("yem_declentry");
        int[] declRows = declEntry.getSelectRows();
        EntryGrid swinEntry = (EntryGrid)this.getControl("yem_swinentry");
        int[] swinRows = swinEntry.getSelectRows();
        StringBuilder sb = new StringBuilder();
        if (declRows.length == 0) {
            sb.append("\r\n").append("\u8bf7\u9009\u62e9\u62a5\u5173\u5355\u5546\u54c1\u4fe1\u606f\uff01");
        }
        if (swinRows.length != 1) {
            sb.append("\r\n").append("\u8bf7\u9009\u62e9\u5355\u4e00\u7a97\u53e3\u62a5\u5173\u5355\u4fe1\u606f\uff01");
        }
        for (int i : declRows) {
            last = (BigDecimal)model.getValue("yem_count_dl_unmt", i);
            if (last.compareTo(BigDecimal.ZERO) > 0) continue;
            sb.append("\r\n").append(String.format("\u62a5\u5173\u5355\u5546\u54c1\u660e\u7ec6\u7b2c %s \u884c\uff0c\u5269\u4f59\u6570\u91cf\u4e0d\u8db3\uff0c\u8bf7\u53cd\u5339\u914d\u540e\u91cd\u65b0\u5339\u914d\uff01", i + 1));
        }
        for (int i : swinRows) {
            last = (BigDecimal)model.getValue("yem_count_sw_unmt", i);
            if (last.compareTo(BigDecimal.ZERO) > 0) continue;
            sb.append("\r\n").append(String.format("\u5355\u4e00\u7a97\u53e3\u5546\u54c1\u4fe1\u606f\u7b2c %s \u884c\uff0c\u5269\u4f59\u6570\u91cf\u4e0d\u8db3\uff0c\u8bf7\u53cd\u5339\u914d\u540e\u91cd\u65b0\u5339\u914d\uff01", i + 1));
        }
        if (sb.length() > 0) {
            throw new KDBizException(sb.toString().trim());
        }
    }

    private void handleMarch(IDataModel model, IFormView view) {
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        DynamicObject dataEntity = parentModel.getDataEntity(true);
        EntryGrid declEntry = (EntryGrid)this.getControl("yem_declentry");
        int[] declRows = declEntry.getSelectRows();
        EntryGrid swinEntry = (EntryGrid)this.getControl("yem_swinentry");
        int[] swinRows = swinEntry.getSelectRows();
        int swinIdx = swinRows[0];
        Long swinId = (Long)model.getValue("yem_swin_id", swinIdx);
        Long swinentryId = (Long)model.getValue("yem_swinentry_id", swinIdx);
        DynamicObject relation = DeclMergeUtils.queryMergeRelation(parentModel);
        String to = relation.getString("yem_after_mentry");
        String from = relation.getString("yem_before_mentry");
        this.prepareMergeBasic(model, view, declRows, from);
        Map<String, MergeRelation> role = DeclMergeUtils.parseMergeRules(relation);
        Map<String, List<DynamicObject>> groupedData = DeclMergeUtils.groupDataByMergeRules(dataEntity, from, role);
        groupedData = DeclMergeUtils.mergeAndWriteData(dataEntity, to, groupedData, role);
        DeclMergeUtils.processSpecialCalculations(dataEntity, to);
        this.syncCustomsDeclarationGoodsToDynamicForm(model, view);
        DeclMergeUtils.writeASingleWindowID(model, view, swinId, swinentryId, groupedData, to);
        this.updateOriginMatchedQty(groupedData);
        this.calculateOriginMatchedQuantity(parentModel, parentView);
        this.writeMatchingRelationships(dataEntity, model, view, groupedData);
        parentView.updateView(from);
        parentView.updateView(to);
        view.updateView("yem_matchinfo");
        view.showSuccessNotification("\u64cd\u4f5c\u6210\u529f");
    }

    private void writeMatchingRelationships(DynamicObject dataEntity, IDataModel model, IFormView view, Map<String, List<DynamicObject>> groupedData) {
        DynamicObjectCollection matchInfoEntity = model.getEntryEntity("yem_matchinfo");
        HashMap idWithMatchInfo = Maps.newHashMap();
        for (DynamicObject d : matchInfoEntity) {
            idWithMatchInfo.put(d.getLong("yem_repeatid"), d);
        }
        for (Map.Entry<String, List<DynamicObject>> group : groupedData.entrySet()) {
            Long resultEntryId = Long.valueOf(group.getKey());
            if (!idWithMatchInfo.containsKey(resultEntryId)) continue;
            DynamicObject matchRow = (DynamicObject)idWithMatchInfo.get(resultEntryId);
            List<DynamicObject> value = group.getValue();
            for (DynamicObject d : value) {
                int idx = model.createNewEntryRow("yem_relation");
                model.setValue("yem_before_seq", d.get("seq"), idx);
                model.setValue("yem_before_name", d.get("yem_material"), idx);
                model.setValue("yem_before_id", d.get("id"), idx);
                model.setValue("yem_after_seq", matchRow.get("seq"), idx);
                model.setValue("yem_after_name", matchRow.get("yem_customsdeclaration"), idx);
                model.setValue("yem_after_id", (Object)resultEntryId, idx);
                model.setValue("yem_declarationobj", (Object)dataEntity.getDataEntityType().getName(), idx);
                model.setValue("yem_declarationid", matchRow.get("yem_swinhead_id"), idx);
                model.setValue("yem_swin_entryid", matchRow.get("yem_swine_id"), idx);
            }
        }
    }

    private void saveMatchingRelationships(IDataModel model, IFormView view) {
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        DynamicObject dataEntity = parentModel.getDataEntity();
        DynamicObject logBill = DeclMergeUtils.queryOrCreateRelationLog(dataEntity);
        logBill.set("billno", parentModel.getValue("billno"));
        logBill.set("yem_schemaname", (Object)"\u624b\u52a8\u5339\u914d");
        DynamicObjectCollection logEntry = logBill.getDynamicObjectCollection("yem_bgspgxb_spdzb");
        logEntry.clear();
        DynamicFormDataUtils.setValueWithRelation(model, logEntry, "yem_relation", RelationConstant.dynamicMatchRelationWithRelationLog());
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_cd_mergelog", (DynamicObject[])new DynamicObject[]{logBill}, (OperateOption)YEM.getOption());
        if (!result.isSuccess()) {
            throw new KDBizException("\u4fdd\u5b58\u62a5\u5173\u5546\u54c1\u5173\u7cfb\u8868\u5931\u8d25\uff01");
        }
    }

    private void readMatchingRelationships(IDataModel model, IFormView view) {
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        DynamicObject dataEntity = parentModel.getDataEntity();
        DynamicObject logBill = DeclMergeUtils.queryOrCreateRelationLog(dataEntity);
        if (YEM.isEmpty((Object)logBill)) {
            return;
        }
        DynamicObjectCollection logEntry = logBill.getDynamicObjectCollection("yem_bgspgxb_spdzb");
        DynamicFormDataUtils.setValueWithRelation(logEntry, model, "yem_relation", RelationConstant.dynamicMatchRelationWithRelationLog());
    }

    private void updateOriginMatchedQty(Map<String, List<DynamicObject>> groupedData) {
        for (List<DynamicObject> value : groupedData.values()) {
            for (DynamicObject d : value) {
                d.set("yem_count_dl_mted", (Object)d.getBigDecimal("yem_qty"));
            }
        }
    }

    private void syncCustomsDeclarationGoodsToDynamicForm(IDataModel model, IFormView view) {
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        int row = parentModel.getEntryRowCount("yem_cd_decmaterial");
        model.deleteEntryData("yem_matchinfo");
        DynamicFormDataUtils.setValueWithRelation(parentModel, model, "yem_matchinfo", RelationConstant.customsDeclarationProductsAndMatchedData(parentModel), row);
    }

    private void prepareMergeBasic(IDataModel model, IFormView view, int[] declRows, String from) {
        int i;
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        String randomId = UUID.randomUUID().toString();
        HashSet mergeIds = Sets.newHashSet();
        for (int idx : declRows) {
            mergeIds.add((Long)model.getValue("yem_declentryid", idx));
        }
        for (i = 0; i < parentModel.getEntryRowCount(from); ++i) {
            parentModel.setValue("yem_custombasic", null, i);
        }
        for (i = 0; i < parentModel.getEntryRowCount(from); ++i) {
            Long originID = (Long)parentModel.getValue(from + ".id", i);
            if (!mergeIds.contains(originID)) continue;
            parentModel.setValue("yem_custombasic", (Object)randomId, i);
        }
    }

    private void afterMatch(IDataModel model, IFormView view) {
        int i;
        int swinEntry = model.getEntryRowCount("yem_swinentry");
        int matchInfo = model.getEntryRowCount("yem_matchinfo");
        HashMap swinId_matchQty = Maps.newHashMap();
        for (i = 0; i < matchInfo; ++i) {
            BigDecimal qty = (BigDecimal)model.getValue("yem_qtys", i);
            Long swinEntryId = (Long)model.getValue("yem_swine_id", i);
            if (swinId_matchQty.containsKey(swinEntryId)) {
                swinId_matchQty.put(swinEntryId, ((BigDecimal)swinId_matchQty.get(swinEntryId)).add(qty));
                continue;
            }
            swinId_matchQty.put(swinEntryId, qty);
        }
        for (i = 0; i < swinEntry; ++i) {
            Long swinEntryId = (Long)model.getValue("yem_swinentry_id", i);
            if (!swinId_matchQty.containsKey(swinEntryId)) continue;
            BigDecimal qty = (BigDecimal)swinId_matchQty.get(swinEntryId);
            model.setValue("yem_count_sw_mted", (Object)qty, i);
            BigDecimal total = (BigDecimal)model.getValue("yem_count_sw_unmt", i);
            model.setValue("yem_count_sw_unmt", (Object)BigDecimalUtils.sub((BigDecimal)total, (BigDecimal)qty, (int)4), i);
        }
        this.syncCurrentDeclEntryData();
    }

    private void calculateOriginMatchedQuantity(IDataModel parentModel, IFormView parentView) {
        int rowCount = parentModel.getEntryRowCount("yem_materialentry");
        for (int i = 0; i < rowCount; ++i) {
            BigDecimal total = (BigDecimal)parentModel.getValue("yem_qty", i);
            BigDecimal matchCount = (BigDecimal)parentModel.getValue("yem_count_dl_mted", i);
            BigDecimal last = total.subtract(matchCount);
            parentModel.setValue("yem_count_dl_unmt", (Object)last, i);
        }
    }

    private void syncCurrentDeclEntryData() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        model.deleteEntryData("yem_declentry");
        int rowCount = parentModel.getEntryRowCount("yem_materialentry");
        for (int fromIdx = 0; fromIdx < rowCount; ++fromIdx) {
            int toIdx = model.createNewEntryRow("yem_declentry");
            model.setValue("yem_material", parentModel.getValue("yem_material"), toIdx, fromIdx);
            DynamicFormDataUtils.setValueWithRelation(parentModel, model, RelationConstant.declEntryWithDynamicProductInformation(parentModel), fromIdx, toIdx);
        }
    }

    private Collection<DynamicObject> queryAssociateSingleWindowData(IDataModel model, IDataModel parentModel) {
        Collection<DynamicObject> decl = this.queryAssociatedCustomsDeclarations(parentModel, false);
        if (decl.isEmpty()) {
            throw new KDBizException("\u672a\u67e5\u8be2\u5230\u62a5\u5173\u5355\u6570\u636e\u5339\u914d\u89c4\u5219\uff01");
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        for (DynamicObject single : decl) {
            DynamicObjectCollection c = single.getDynamicObjectCollection("yem_cd_bgdsjppgz_ppgz");
            ArrayList<QFilter> and = new ArrayList<QFilter>();
            for (DynamicObject d : c) {
                HashSet formValue = Sets.newHashSet();
                String fromField = d.getString("yem_decl_field");
                String toFiled = d.getString("yem_swin_field");
                String fromType = d.getString("yem_decl_type");
                String baseProp = d.getString("yem_decl_prop");
                if (MetaDataUtils.isBaseData((String)fromType) && YEM.isNotEmpty((Object)baseProp)) {
                    fromField = fromField + "." + baseProp;
                }
                formValue.add(parentModel.getValue(fromField));
                and.add(new QFilter(toFiled, "in", (Object)formValue));
            }
            if (and.size() == 1) {
                qFilters.add((QFilter)and.get(0));
                continue;
            }
            if (and.size() <= 1) continue;
            QFilter qFilter = (QFilter)and.get(0);
            for (int i = 1; i < and.size(); ++i) {
                qFilter.and((QFilter)and.get(i));
            }
            qFilters.add(qFilter);
        }
        return this.queryMatchingSingleWindowCustomsDeclarations(qFilters);
    }

    private void setValueOfSwinData(Collection<DynamicObject> swinData, IDataModel model) {
        for (DynamicObject d : swinData) {
            DynamicObjectCollection toEntry = d.getDynamicObjectCollection("yem_ca_dyckbgd_shxx");
            DynamicFormDataUtils.setValueWithRelation(toEntry, model, "yem_swinentry", RelationConstant.swinWithDynamicSwin(), d.getLong("id"));
        }
    }

    private Collection<DynamicObject> queryAssociatedCustomsDeclarations(IDataModel model, boolean auto) {
        String formId = model.getDataEntityType().getName();
        String selectfields = DynamicObjectUtil.getSelectfields((String)"yem_cd_decldatarule", (boolean)false);
        selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"yem_cd_decldatarule", (String)"yem_cd_bgdsjppgz_ppgz", (boolean)false);
        QFilter[] qFilters = new QFilter[]{new QFilter("yem_bill.number", "=", (Object)formId), new QFilter("status", "=", (Object)"C")};
        if (auto) {
            return BusinessDataServiceHelper.loadFromCache((String)"yem_cd_decldatarule_auto", (String)selectfields, (QFilter[])qFilters).values();
        }
        return BusinessDataServiceHelper.loadFromCache((String)"yem_cd_decldatarule", (String)selectfields, (QFilter[])qFilters).values();
    }

    private Collection<DynamicObject> queryMatchingSingleWindowCustomsDeclarations(List<QFilter> qFilter) {
        String selectfields = DynamicObjectUtil.getSelectfields((String)"yem_ca_cusdec");
        selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"yem_ca_cusdec", (String)"yem_ca_dyckbgd_shxx");
        return BusinessDataServiceHelper.loadFromCache((String)"yem_ca_cusdec", (String)selectfields, (QFilter[])qFilter.toArray(new QFilter[0])).values();
    }

    private void handleUnMarch(IDataModel model, IFormView view) {
        EntryGrid matchInfo = (EntryGrid)this.getControl("yem_matchinfo");
        int[] rows = matchInfo.getSelectRows();
        if (rows.length == 0) {
            view.showErrorNotification("\u8bf7\u9009\u62e9\u9700\u8981\u53d6\u6d88\u5339\u914d\u7684\u884c\uff01");
            return;
        }
        HashMap matchCount = Maps.newHashMap();
        for (int row : rows) {
            Long swine_id = (Long)model.getValue("yem_swine_id", row);
            BigDecimal qtys = (BigDecimal)model.getValue("yem_qtys", row);
            if (matchCount.containsKey(swine_id)) {
                matchCount.put(swine_id, ((BigDecimal)matchCount.get(swine_id)).add(qtys));
                continue;
            }
            matchCount.put(swine_id, qtys);
        }
        int rowCount = model.getEntryRowCount("yem_swinentry");
        for (int i = 0; i < rowCount; ++i) {
            Long swinentryId = (Long)model.getValue("yem_swinentry_id", i);
            if (!matchCount.containsKey(swinentryId)) continue;
            BigDecimal subQty = (BigDecimal)matchCount.get(swinentryId);
            BigDecimal matched = (BigDecimal)model.getValue("yem_count_sw_mted", i);
            matched = matched.subtract(subQty);
            model.setValue("yem_count_sw_mted", (Object)matched, i);
            BigDecimal total = (BigDecimal)model.getValue("yem_count_sw_unmt", i);
            model.setValue("yem_count_sw_unmt", (Object)BigDecimalUtils.sub((BigDecimal)total, (BigDecimal)matched, (int)4), i);
        }
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        int declEntryCount = parentModel.getEntryRowCount("yem_cd_decmaterial");
        for (int r = declEntryCount - 1; r > -1; --r) {
            Long swine_id = (Long)parentModel.getValue("yem_swine_id", r);
            if (!matchCount.containsKey(swine_id)) continue;
            parentModel.deleteEntryRow("yem_cd_decmaterial", r);
        }
        HashSet ids = Sets.newHashSet();
        HashSet deleteRelation = Sets.newHashSet();
        int matchInfoRowCount = model.getEntryRowCount("yem_relation");
        for (int row : rows) {
            Long swinEntryId = (Long)model.getValue("yem_swine_id", row);
            for (int i = 0; i < matchInfoRowCount; ++i) {
                Long swinEntryid = (Long)model.getValue("yem_swin_entryid", i);
                if (!Objects.equals(swinEntryId, swinEntryid)) continue;
                deleteRelation.add(i);
                ids.add(Long.valueOf((String)model.getValue("yem_before_id", i)));
            }
        }
        model.deleteEntryRows("yem_relation", deleteRelation.stream().mapToInt(Integer::intValue).toArray());
        int declEntry = parentModel.getEntryRowCount("yem_materialentry");
        for (int i = 0; i < declEntry; ++i) {
            Long id = (Long)parentModel.getValue("yem_materialentry.id", i);
            if (!ids.contains(id)) continue;
            BigDecimal total = (BigDecimal)parentModel.getValue("yem_qty", i);
            BigDecimal matched = BigDecimal.ZERO;
            BigDecimal last = total.subtract(matched);
            parentModel.setValue("yem_count_dl_mted", (Object)matched, i);
            parentModel.setValue("yem_count_dl_unmt", (Object)last, i);
        }
        this.syncCurrentDeclEntryData();
        this.syncCustomsDeclarationGoodsToDynamicForm(model, view);
        view.updateView("yem_matchinfo");
        parentView.updateView("yem_cd_decmaterial");
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String name = e.getName();
        if ("beforeAutoMatch_SelectedRow".equals(name)) {
            this.handleUnMarch(model, view);
            view.addClientCallBack("afterUnMatch_autoGroupEntryData", Integer.valueOf(50));
        }
        if ("afterUnMatch_autoGroupEntryData".equals(name)) {
            this.autoGroupEntryData(model, view);
        }
        if ("afterGroupData_StartAutoMatchOperation".equals(name)) {
            this.handleAutoMatch(model, view);
        }
        if ("continueMatching".equals(name)) {
            this.handleAutoMatch(model, view);
        }
        if ("afterSelectRow_doMatchOperation".equals(name)) {
            this.handleTriggerMatch(model, view);
        }
    }

    private void autoGroupEntryData(IDataModel model, IFormView view) {
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        Collection<DynamicObject> matchRule = this.queryAssociatedCustomsDeclarations(parentModel, true);
        if (matchRule.size() != 1) {
            view.showErrorNotification("\u67e5\u8be2\u5230\u591a\u6761\u81ea\u52a8\u5339\u914d\u89c4\u5219\uff0c\u6216\u4e3a\u67e5\u8be2\u5230\u81ea\u52a8\u5339\u914d\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\uff01");
            return;
        }
        DynamicObject dataEntity = parentModel.getDataEntity(true);
        Collection<DynamicObject> sWindowData = this.queryAssociateSingleWindowData(model, parentModel);
        Map<Long, List<Long>> match = DeclMergeUtils.autoMarchDeclAndSwin(matchRule, sWindowData, dataEntity);
        HashMap result = Maps.newHashMap();
        for (Map.Entry<Long, List<Long>> entry : match.entrySet()) {
            result.put(entry.getKey(), false);
        }
        MatchProgress progress = new MatchProgress(match, result, null);
        IPageCache cache = view.getPageCache();
        cache.put("progress", JSON.toJSONString((Object)progress));
        view.addClientCallBack("afterGroupData_StartAutoMatchOperation");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAutoMatch(IDataModel model, IFormView view) {
        IPageCache cache = view.getPageCache();
        String cacheStr = cache.get("progress");
        MatchProgress progress = (MatchProgress)JSON.parseObject((String)cacheStr, MatchProgress.class);
        Map<Long, List<Long>> originData = progress.getOriginData();
        Long nextUnMatch = progress.getNextUnMatch();
        if (nextUnMatch != 0L) {
            if (!originData.containsKey(nextUnMatch)) throw new KDBizException("\u5206\u7ec4\u89c4\u5219\u6709\u8bef");
            List<Long> declIds = originData.get(nextUnMatch);
            if (!declIds.isEmpty()) {
                progress.setCurrentOperation(nextUnMatch);
                cache.put("progress", JSON.toJSONString((Object)progress));
                this.triggerMatch(declIds, nextUnMatch, model, view, progress);
                return;
            } else {
                view.showSuccessNotification("\u8df3\u8fc7");
                progress.updateResult(nextUnMatch);
                cache.put("progress", JSON.toJSONString((Object)progress));
                view.addClientCallBack("continueMatching", Integer.valueOf(50));
            }
            return;
        } else {
            view.showSuccessNotification("\u81ea\u52a8\u5339\u914d\u5b8c\u6210\uff01");
        }
    }

    private void handleTriggerMatch(IDataModel model, IFormView view) {
        IFormView parentView = view.getParentView();
        IPageCache cache = view.getPageCache();
        String cacheStr = cache.get("progress");
        MatchProgress progress = (MatchProgress)JSON.parseObject((String)cacheStr, MatchProgress.class);
        Long currentOperation = progress.getCurrentOperation();
        this.beforeMatch(model, view);
        this.handleMarch(model, view);
        this.afterMatch(model, view);
        view.sendFormAction(parentView);
        progress.updateResult(currentOperation);
        cache.put("progress", JSON.toJSONString((Object)progress));
        view.addClientCallBack("continueMatching", Integer.valueOf(50));
    }

    private void beforeAutoMatch(IDataModel model, IFormView view) {
        EntryGrid matchinfo = (EntryGrid)this.getControl("yem_matchinfo");
        int rowCount = model.getEntryRowCount("yem_matchinfo");
        if (rowCount == 0) {
            view.addClientCallBack("afterUnMatch_autoGroupEntryData", Integer.valueOf(50));
            return;
        }
        matchinfo.selectRows(IntStream.range(0, rowCount).toArray(), 0);
        view.addClientCallBack("beforeAutoMatch_SelectedRow", Integer.valueOf(50));
    }

    private void triggerMatch(List<Long> declIds, Long nextUnMatch, IDataModel model, IFormView view, MatchProgress progress) {
        EntryGrid declentry = (EntryGrid)this.getControl("yem_declentry");
        EntryGrid swinentry = (EntryGrid)this.getControl("yem_swinentry");
        int declEntryRowCount = model.getEntryRowCount("yem_declentry");
        HashSet declentryRow = Sets.newHashSet();
        for (int i = 0; i < declEntryRowCount; ++i) {
            Long declentryid = (Long)model.getValue("yem_declentryid", i);
            if (!declIds.contains(declentryid)) continue;
            declentryRow.add(i);
        }
        declentry.selectRows(declentryRow.stream().mapToInt(Integer::intValue).toArray(), 0);
        int swinEntryRowCount = model.getEntryRowCount("yem_swinentry");
        for (int i = 0; i < swinEntryRowCount; ++i) {
            Long swinentryId = (Long)model.getValue("yem_swinentry_id", i);
            if (!Objects.equals(nextUnMatch, swinentryId)) continue;
            swinentry.selectRows(i);
        }
        view.addClientCallBack("afterSelectRow_doMatchOperation", Integer.valueOf(50));
    }
}

