/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cd.common.bill.declaredocx.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.compress.utils.Lists;
import yem.base.common.utils.BigDecimalUtils;
import yem.base.common.utils.YEM;
import yem.wm.cd.common.bd.mergerelation.common.MergeRelation;
import yem.wm.customs.common.utils.MetaDataUtils;

public class DeclMergeUtils {
    public static DynamicObject queryMergeBasicAndRelation(String basic, String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("yem_billid", "=", (Object)formId), new QFilter("number", "=", (Object)basic)};
        DynamicObject single = BusinessDataServiceHelper.loadSingle((String)"yem_cd_mergeschema", (QFilter[])filters);
        if (YEM.isEmpty((Object)single)) {
            throw new KDBizException("\u672a\u627e\u5230\u7f16\u7801\u4e3a " + basic + " \u7684\u5408\u5e76\u65b9\u6848\uff01");
        }
        String name = single.getString("name");
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>();
        DynamicObjectCollection c = single.getDynamicObjectCollection("yem_cd_hbfa_hbyj");
        for (DynamicObject d : c) {
            ids.add(d.getLong("yem_fieldentryid"));
        }
        long relationId = single.getLong("yem_mergerelationid");
        DynamicObject relation = BusinessDataServiceHelper.loadSingle((String)"yem_cd_mergerelation", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)relationId)});
        if (YEM.isEmpty((Object)relation)) {
            throw new KDBizException("\u672a\u627e\u5230ID\u4e3a " + relationId + " \u7684\u5b57\u6bb5\u6620\u5c04\u8868\uff01");
        }
        DynamicObjectCollection relaCollection = relation.getDynamicObjectCollection("yem_cd_hbfaziysb_zdgx");
        for (DynamicObject d : relaCollection) {
            long id = d.getLong("id");
            if (ids.contains(id)) {
                d.set("yem_isbasic", (Object)true);
                continue;
            }
            d.set("yem_isbasic", (Object)false);
        }
        relation.set("name", (Object)name);
        return relation;
    }

    public static boolean isSameDataType(String afterDatatype, String beforeDatatype) {
        if ("LongProp_BigIntProp".contains(afterDatatype) && "LongProp_BigIntProp".contains(beforeDatatype)) {
            return true;
        }
        if ("MaterielProp_BasedataProp".contains(afterDatatype) && "MaterielProp_BasedataProp".contains(beforeDatatype)) {
            return true;
        }
        return afterDatatype.equals(beforeDatatype);
    }

    public static Map<String, MergeRelation> parseMergeRules(DynamicObject relation) {
        LinkedHashSet<MergeRelation> mergeRelations = new LinkedHashSet<MergeRelation>();
        DynamicObjectCollection collection = relation.getDynamicObjectCollection("yem_cd_hbfaziysb_zdgx");
        for (DynamicObject d : collection) {
            boolean isbasic = d.getBoolean("yem_isbasic");
            String mergetype = d.getString("yem_mergetype");
            String afterName = d.getString("yem_after_name");
            String afterNumber = d.getString("yem_after_number");
            String afterDatatype = d.getString("yem_after_datatype");
            String afterBdkey = d.getString("yem_after_bdkey");
            String beforeName = d.getString("yem_before_name");
            String beforeNumber = d.getString("yem_before_number");
            String beforeDatatype = d.getString("yem_before_datatype");
            String beforeBdkey = d.getString("yem_before_bdkey");
            String expressvalue = d.getString("yem_expressvalue");
            if (YEM.isNotEmpty((Object)afterDatatype) && YEM.isNotEmpty((Object)beforeDatatype) && !DeclMergeUtils.isSameDataType(afterDatatype, beforeDatatype)) {
                throw new KDBizException(String.format("%s \u548c %s \u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5408\u5e76\uff01", afterName, beforeName));
            }
            if (YEM.isNotEmpty((Object)afterBdkey) && YEM.isNotEmpty((Object)beforeBdkey) && !afterBdkey.equals(beforeBdkey)) {
                throw new KDBizException(String.format("%s \u548c %s \u5b57\u6bb5\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5408\u5e76\uff01", afterName, beforeName));
            }
            MergeRelation real2 = new MergeRelation(beforeNumber, afterNumber, mergetype, isbasic, expressvalue);
            mergeRelations.add(real2);
        }
        return mergeRelations.stream().filter(real -> {
            String fromNumber = real.getFromNumber();
            String express = real.getExpress();
            return fromNumber != null && !fromNumber.isEmpty() || express != null && !express.isEmpty();
        }).collect(Collectors.toMap(real -> {
            String fromNumber = real.getFromNumber();
            return fromNumber != null && !fromNumber.isEmpty() ? fromNumber : real.getExpress();
        }, real -> real, (existing, replacement) -> existing));
    }

    public static Map<String, MergeRelation> parseMergeRulesAfter(DynamicObject relation) {
        return null;
    }

    public static Map<String, List<DynamicObject>> groupDataByMergeRules(DynamicObject dataEntity, String form, Map<String, MergeRelation> role) {
        LinkedHashMap<String, List<DynamicObject>> merge = new LinkedHashMap<String, List<DynamicObject>>();
        DynamicObjectCollection formCollection = dataEntity.getDynamicObjectCollection(form);
        for (DynamicObject d : formCollection) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, MergeRelation> entrySet : role.entrySet()) {
                String key = entrySet.getKey();
                MergeRelation value = entrySet.getValue();
                if (!value.isBasic()) continue;
                Object v = d.get(key);
                if (v instanceof DynamicObject && YEM.isNotEmpty((Object)v)) {
                    sb.append(((DynamicObject)v).getString("id"));
                    continue;
                }
                if (!YEM.isNotEmpty((Object)v)) continue;
                sb.append(v);
            }
            String base = sb.toString();
            if (!YEM.isNotEmpty((Object)base)) continue;
            merge.computeIfAbsent(base, k -> new ArrayList()).add(d);
        }
        return merge;
    }

    public static Map<Long, List<Long>> autoMarchDeclAndSwin(Collection<DynamicObject> matchRule, Collection<DynamicObject> sWindowData, DynamicObject dataEntity) {
        DynamicObject rule = matchRule.iterator().next();
        DynamicObjectCollection c = rule.getDynamicObjectCollection("yem_cd_bgdsjppgz_ppgz");
        String declEntryId = rule.getString("yem_decl_entry");
        String swinEntryId = rule.getString("yem_swin_entry");
        HashMap expressDecl = Maps.newHashMap();
        HashMap expressSwin = Maps.newHashMap();
        for (Object d : c) {
            String string = d.getString("yem_decl_field");
            String declType = d.getString("yem_decl_type");
            String declProp = d.getString("yem_decl_prop");
            if (MetaDataUtils.isBaseData((String)declType) && YEM.isNotEmpty((Object)declProp)) {
                expressDecl.put(string, string + "." + (String)declProp);
            } else {
                expressDecl.put(string, string);
            }
            String swinField = d.getString("yem_swin_field");
            expressSwin.put(swinField, swinField);
        }
        LinkedHashMap<String, List> mergeSwin = new LinkedHashMap<String, List>();
        for (DynamicObject dynamicObject : sWindowData) {
            DynamicObjectCollection sSwinEntry = dynamicObject.getDynamicObjectCollection(swinEntryId);
            for (DynamicObject d : sSwinEntry) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry exp : expressSwin.entrySet()) {
                    String field = (String)exp.getKey();
                    String express = (String)exp.getValue();
                    Object v = d.get(express);
                    if (v instanceof DynamicObject && YEM.isNotEmpty((Object)v)) {
                        sb.append(((DynamicObject)v).getString("id"));
                        continue;
                    }
                    if (!YEM.isNotEmpty((Object)v)) continue;
                    sb.append(v);
                }
                String string = sb.toString();
                if (!YEM.isNotEmpty((Object)string)) continue;
                mergeSwin.computeIfAbsent(string, k -> new ArrayList()).add(d);
            }
        }
        for (Map.Entry entry : mergeSwin.entrySet()) {
            List value = (List)entry.getValue();
            if (value.size() <= 1) continue;
            throw new KDBizException("\u5355\u4e00\u7a97\u53e3\u62a5\u5173\u5355\u6309\u7167\u5408\u5e76\u89c4\u5219\u5206\u7ec4\u4e4b\u540e\uff0c\u5b58\u5728\u591a\u6761\u5408\u5e76\u7684\u60c5\u51b5\uff0c\u65e0\u6cd5\u81ea\u52a8\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u62a5\u5173\u5355\u81ea\u52a8\u5408\u5e76\u89c4\u5219\uff01");
        }
        LinkedHashMap<String, List> mergeDecl = new LinkedHashMap<String, List>();
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(declEntryId);
        for (DynamicObject d : dynamicObjectCollection) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : expressDecl.entrySet()) {
                String field = (String)entry.getKey();
                String express = (String)entry.getValue();
                Object v = d.get(express);
                if (v instanceof DynamicObject && YEM.isNotEmpty((Object)v)) {
                    sb.append(((DynamicObject)v).getString("id"));
                    continue;
                }
                if (!YEM.isNotEmpty((Object)v)) continue;
                sb.append(v);
            }
            String base = sb.toString();
            if (!YEM.isNotEmpty((Object)base)) continue;
            mergeDecl.computeIfAbsent(base, k -> new ArrayList()).add(d);
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry swinEntry : mergeSwin.entrySet()) {
            String key = (String)swinEntry.getKey();
            ArrayList arrayList = Lists.newArrayList();
            DynamicObject value = (DynamicObject)((List)swinEntry.getValue()).get(0);
            if (mergeDecl.containsKey(key)) {
                for (DynamicObject d : (List)mergeDecl.get(key)) {
                    long declId = d.getLong("id");
                    arrayList.add(declId);
                }
            }
            long swinId = value.getLong("id");
            result.put(swinId, arrayList);
        }
        return result;
    }

    public static Map<String, List<DynamicObject>> mergeAndWriteData(DynamicObject dataEntity, String to, Map<String, List<DynamicObject>> groupedData, Map<String, MergeRelation> fieldRelations) {
        DynamicObjectCollection afterDataCollection = dataEntity.getDynamicObjectCollection(to);
        HashMap<String, List<DynamicObject>> replaceKeyWithNewKey = new HashMap<String, List<DynamicObject>>();
        for (List<DynamicObject> beforeData : groupedData.values()) {
            DynamicObject afterData = afterDataCollection.addNew();
            for (Map.Entry<String, MergeRelation> filedSet : fieldRelations.entrySet()) {
                String beforeNo = filedSet.getKey();
                MergeRelation rel = filedSet.getValue();
                String afterNo = rel.getToNumber();
                String express = rel.getExpress();
                if (YEM.isEmpty((Object)rel) || YEM.isEmpty((Object)afterNo) || YEM.isEmpty((Object)beforeNo)) continue;
                String type = rel.getType();
                if ("A".equals(type)) {
                    if (YEM.isNotEmpty((Object)express)) {
                        afterData.set(afterNo, beforeData.get(0).get(express));
                    } else {
                        afterData.set(afterNo, beforeData.get(0).get(beforeNo));
                    }
                }
                if ("B".equals(type)) {
                    if (YEM.isNotEmpty((Object)express)) {
                        afterData.set(afterNo, beforeData.get(beforeData.size() - 1).get(express));
                    } else {
                        afterData.set(afterNo, beforeData.get(beforeData.size() - 1).get(beforeNo));
                    }
                }
                if (!"C".equals(type)) continue;
                BigDecimal sum = BigDecimal.ZERO;
                for (DynamicObject d : beforeData) {
                    sum = sum.add(d.getBigDecimal(beforeNo));
                }
                afterData.set(afterNo, (Object)sum);
            }
            long id = DB.genLongId((String)"");
            afterData.set("id", (Object)id);
            replaceKeyWithNewKey.put(String.valueOf(id), beforeData);
        }
        return replaceKeyWithNewKey;
    }

    public static void processSpecialCalculations(DynamicObject dataEntity, String to) {
        DynamicObjectCollection afterDataCollection = dataEntity.getDynamicObjectCollection(to);
        for (DynamicObject d : afterDataCollection) {
            BigDecimal amounts = d.getBigDecimal("yem_amounts");
            BigDecimal qtys = d.getBigDecimal("yem_qtys");
            BigDecimal price = BigDecimalUtils.div((BigDecimal)amounts, (BigDecimal)qtys, (int)4);
            d.set("yem_prices", (Object)price);
            BigDecimal totalgross = d.getBigDecimal("yem_totalgross");
            BigDecimal gross = BigDecimalUtils.div((BigDecimal)totalgross, (BigDecimal)qtys, (int)4);
            d.set("yem_bggrossweight", (Object)gross);
            BigDecimal totalnet = d.getBigDecimal("yem_totalnet");
            BigDecimal weight = BigDecimalUtils.div((BigDecimal)totalnet, (BigDecimal)qtys, (int)4);
            d.set("yem_bgnetweight", (Object)weight);
            BigDecimal totalvolumem3 = d.getBigDecimal("yem_totalvolumem3");
            BigDecimal vol = BigDecimalUtils.div((BigDecimal)totalvolumem3, (BigDecimal)qtys, (int)4);
            d.set("yem_cubicmeters", (Object)vol);
        }
    }

    public static void writeProductMappingTable(String basic, String name, DynamicObject dataEntity, Map<String, List<DynamicObject>> groupedData, Map<String, MergeRelation> role) {
        DynamicObject logBill = DeclMergeUtils.queryOrCreateRelationLog(dataEntity);
        logBill.set("billno", (Object)dataEntity.getString("billno"));
        logBill.set("yem_schemaid", (Object)basic);
        logBill.set("yem_schemaname", (Object)name);
        DynamicObjectCollection logEntry = logBill.getDynamicObjectCollection("yem_bgspgxb_spdzb");
        logEntry.clear();
        String type = "A";
        if (role.containsKey("yem_material")) {
            MergeRelation relation = role.get("yem_material");
            type = relation.getType();
        }
        int idx = 0;
        for (Map.Entry<String, List<DynamicObject>> entrySet : groupedData.entrySet()) {
            ++idx;
            List<DynamicObject> value = entrySet.getValue();
            for (DynamicObject e : value) {
                DynamicObject d = logEntry.addNew();
                d.set("yem_before_seq", (Object)e.getString("seq"));
                d.set("yem_before_id", (Object)e.getString("id"));
                d.set("yem_before_name", (Object)e.getDynamicObject("yem_material"));
                d.set("yem_after_seq", (Object)idx);
                if ("A".equals(type)) {
                    d.set("yem_after_name", (Object)value.get(0).getString("yem_material.name"));
                    continue;
                }
                d.set("yem_after_name", (Object)value.get(value.size() - 1).getString("yem_material.name"));
            }
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_cd_mergelog", (DynamicObject[])new DynamicObject[]{logBill}, (OperateOption)YEM.getOption());
        if (!result.isSuccess()) {
            throw new KDBizException("\u4fdd\u5b58\u62a5\u5173\u5546\u54c1\u5173\u7cfb\u8868\u5931\u8d25\uff01");
        }
    }

    public static DynamicObject queryOrCreateRelationLog(DynamicObject dataEntity) {
        String name = dataEntity.getDataEntityType().getName();
        Long id = (Long)dataEntity.getPkValue();
        if (YEM.isEmpty((Object)id)) {
            throw new RuntimeException("\u521b\u5efa\u5339\u914d\u5173\u7cfb\u5e95\u8868\u65f6\uff0c\u83b7\u53d6\u4e0d\u5230\u539f\u5355ID\uff0c\u8bf7\u68c0\u67e5");
        }
        QFilter[] filters = new QFilter[]{new QFilter("yem_opbill.number", "=", (Object)name), new QFilter("yem_customsid", "=", (Object)id)};
        DynamicObject logTable = BusinessDataServiceHelper.loadSingle((String)"yem_cd_mergelog", (QFilter[])filters);
        if (YEM.isEmpty((Object)logTable)) {
            DynamicObject newLogTable = BusinessDataServiceHelper.newDynamicObject((String)"yem_cd_mergelog");
            newLogTable.set("yem_customsid", (Object)id);
            newLogTable.set("yem_opbill", (Object)BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)name)}));
            newLogTable.set("org", (Object)YEM.getCurrentOrgId());
            newLogTable.set("billstatus", (Object)"A");
            return newLogTable;
        }
        return logTable;
    }

    public static DynamicObject queryMergeRelation(IDataModel parentModel) {
        String formId = parentModel.getDataEntityType().getName();
        DynamicObject relation = BusinessDataServiceHelper.loadSingle((String)"yem_cd_mergerelation", (QFilter[])new QFilter[]{new QFilter("yem_billtext", "=", (Object)formId)});
        if (YEM.isEmpty((Object)relation)) {
            throw new KDBizException("\u672a\u627e\u5230\u5f53\u524d\u5355\u636e\u7684 \u5408\u5e76\u65b9\u6848\u5b57\u6bb5\u6620\u5c04\u8868");
        }
        DynamicObjectCollection relaCollection = relation.getDynamicObjectCollection("yem_cd_hbfaziysb_zdgx");
        for (DynamicObject d : relaCollection) {
            String before_number = d.getString("yem_before_number");
            if ("yem_custombasic".equals(before_number)) {
                d.set("yem_isbasic", (Object)true);
                continue;
            }
            d.set("yem_isbasic", (Object)false);
        }
        return relation;
    }

    private static Set<String> parseIsBasicFromMatchRule(Collection<DynamicObject> matchRule) {
        HashSet<String> result = new HashSet<String>();
        for (DynamicObject rule : matchRule) {
            DynamicObjectCollection c = rule.getDynamicObjectCollection("yem_cd_bgdsjppgz_ppgz");
            for (DynamicObject d : c) {
                result.add(d.getString("yem_decl_field"));
            }
        }
        return result;
    }

    public static void writeASingleWindowID(IDataModel model, IFormView view, Long swinId, Long swinentryId, Map<String, List<DynamicObject>> groupedData, String to) {
        HashSet currentOperationDataID = Sets.newHashSet();
        for (List<DynamicObject> value : groupedData.values()) {
            for (DynamicObject d : value) {
                currentOperationDataID.add(d.getLong("id"));
            }
        }
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        int formEntry = parentModel.getEntryRowCount(to);
        for (int i = 0; i < formEntry; ++i) {
            Long entryId = (Long)parentModel.getValue("yem_declarationgoods", i);
            if (!currentOperationDataID.contains(entryId)) continue;
            parentModel.setValue("yem_swinhead_id", (Object)swinId, i);
            parentModel.setValue("yem_swine_id", (Object)swinentryId, i);
        }
        int dynamicEntry = model.getEntryRowCount("yem_matchinfo");
        for (int i = 0; i < dynamicEntry; ++i) {
            Long declentryId = (Long)model.getValue("yem_declentry_id", i);
            if (!currentOperationDataID.contains(declentryId)) continue;
            model.setValue("yem_swinhead_id", (Object)swinId, i);
            model.setValue("yem_swine_id", (Object)swinentryId, i);
        }
    }

    public static Map<String, MergeRelation> convertToAfterField(Map<String, MergeRelation> role) {
        return role.values().stream().filter(real -> {
            String fromNumber = real.getFromNumber();
            String express = real.getExpress();
            return fromNumber != null && !fromNumber.isEmpty() || express != null && !express.isEmpty();
        }).collect(Collectors.toMap(real -> {
            String fromNumber = real.getFromNumber();
            return fromNumber != null && !fromNumber.isEmpty() ? fromNumber : real.getExpress();
        }, real -> real, (existing, replacement) -> existing));
    }

    public static Map<String, List<DynamicObject>> groupSwinDataByCustomsDeclarationDataMatchingRules(Collection<DynamicObject> matchRule, Collection<DynamicObject> sWindowData) {
        DynamicObject rule = matchRule.iterator().next();
        String declEntryId = rule.getString("yem_decl_entry");
        String swinEntryId = rule.getString("yem_swin_entry");
        DynamicObjectCollection c = rule.getDynamicObjectCollection("yem_cd_bgdsjppgz_ppgz");
        for (DynamicObject d : c) {
            String string = d.getString("yem_swin_field");
        }
        return null;
    }
}

