/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cd.common.bill.invoicenotice.op;

import java.util.ArrayList;
import java.util.List;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.utils.SystemParamUtil;
import yem.base.common.utils.YEM;

public class InvoiceNoticeAuditPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(this.billEntityType.getFields().keySet());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        this.pushGenerateVendorInvoicingNotification(entities);
    }

    private void pushGenerateVendorInvoicingNotification(DynamicObject[] entities) {
        boolean isDoPush = this.isDoPush();
        if (!isDoPush) {
            return;
        }
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        for (DynamicObject entity : entities) {
            ListSelectedRow srcBill1 = new ListSelectedRow(entity.getPkValue());
            selectedRows.add(srcBill1);
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("yem_cd_invoicenotice");
        pushArgs.setTargetEntityNumber("yem_cd_supinvoicenotice");
        pushArgs.setHasRight(false);
        pushArgs.setRuleId("2265403674215867392");
        pushArgs.setBuildConvReport(true);
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (pushResult.isSuccess()) {
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"yem_cd_supinvoicenotice");
            List targetBillObjs = pushResult.loadTargetDataObjects(new IRefrencedataProvider(){

                public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                    BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
                }
            }, targetMainType);
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("ignorewarn", String.valueOf(true));
            saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
            saveOption.setVariableValue("strictvalidation", String.valueOf(true));
            for (DynamicObject target : targetBillObjs) {
                OperationResult saveResult = SaveServiceHelper.saveOperate((String)"yem_cd_supinvoicenotice", (DynamicObject[])new DynamicObject[]{target}, (OperateOption)saveOption);
                if (saveResult.isSuccess()) continue;
                throw new KDBizException("\u4e0b\u63a8\u5355\u636e\u4fdd\u5b58\u5931\u8d25\uff1a" + saveResult.getMessage());
            }
        } else {
            String message = pushResult.getMessage();
            throw new KDBizException("\u4e0b\u63a8\u5931\u8d25\uff1a" + message);
        }
    }

    private boolean isDoPush() {
        Object params = SystemParamUtil.getAppParam((String)"yem_ts", (String)"yem_isgensupinnotify");
        if (YEM.isEmpty((Object)params)) {
            return false;
        }
        if (params instanceof String) {
            return "Y".equals(String.valueOf(params));
        }
        return false;
    }
}

