/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cd.common.bill.invoicing.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;

public class InvoicingBillPlugin
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        if (rowIndex < 0) {
            return;
        }
        switch (name) {
            case "yem_feemarknames": 
            case "yem_feerate": {
                this.yem_fee();
                break;
            }
            case "yem_insurmarknames": 
            case "yem_insurrate": {
                this.yem_insur();
                break;
            }
            case "yem_othermarknames": 
            case "yem_otherrate": {
                this.yem_other();
                break;
            }
            case "yem_grossweight": 
            case "yem_materialentry": {
                this.yem_fee();
                this.yem_insur();
                this.yem_other();
                break;
            }
            case "yem_totalamountloc": {
                this.yem_priceloc(rowIndex);
                this.yem_taxamountloc(rowIndex);
                this.yem_amountnotaxloc(rowIndex);
                break;
            }
            case "yem_taxamountloc": {
                this.yem_amountnotaxloc(rowIndex);
                this.yem_priceloc(rowIndex);
                break;
            }
            case "yem_etaxrate": {
                this.yem_taxamountloc(rowIndex);
                break;
            }
            case "yem_amountnotaxloc": {
                this.yem_pricenotaxloc(rowIndex);
                break;
            }
            case "yem_qtynotaxloc": {
                this.yem_priceloc(rowIndex);
                this.yem_pricenotaxloc(rowIndex);
                this.yem_baseqty(rowIndex);
                break;
            }
            case "yem_rate": 
            case "yem_feecurrtotal": 
            case "yem_insurcurtotal": 
            case "yem_othercutotal": 
            case "yem_amount": {
                this.yem_totalamountloc(rowIndex);
                break;
            }
            case "yem_amountnotax": {
                this.yem_totalamountloc(rowIndex);
                break;
            }
            case "yem_qty": {
                this.yem_pricenotax(rowIndex);
                break;
            }
            case "yem_price": {
                BigDecimal yemQty = (BigDecimal)this.getModel().getValue("yem_qty");
                BigDecimal yemPrice = (BigDecimal)this.getModel().getValue("yem_price");
                this.getModel().setValue("yem_amt", (Object)yemQty.multiply(yemPrice));
            }
        }
    }

    private void yem_baseqty(int rowIndex) {
        BigDecimal yemQtynotaxloc = (BigDecimal)this.getModel().getValue("yem_qtynotaxloc", rowIndex);
        this.getModel().setValue("yem_baseqty", (Object)yemQtynotaxloc, rowIndex);
    }

    private void yem_pricenotax(int rowIndex) {
        BigDecimal yemAmountnotax = (BigDecimal)this.getModel().getValue("yem_amountnotax", rowIndex);
        BigDecimal yemQty = (BigDecimal)this.getModel().getValue("yem_qty", rowIndex);
        if (yemQty.compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue("yem_pricenotax", (Object)yemAmountnotax.divide(yemQty, 2, RoundingMode.HALF_UP));
        } else {
            this.getModel().setValue("yem_pricenotax", (Object)BigDecimal.ZERO);
        }
    }

    private void yem_priceloc(int rowIndex) {
        BigDecimal yemTotalamountloc = (BigDecimal)this.getModel().getValue("yem_totalamountloc", rowIndex);
        BigDecimal yemQtynotaxloc = (BigDecimal)this.getModel().getValue("yem_qtynotaxloc", rowIndex);
        if (yemQtynotaxloc.compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue("yem_priceloc", (Object)yemTotalamountloc.divide(yemQtynotaxloc, 2, RoundingMode.HALF_UP), rowIndex);
        } else {
            this.getModel().setValue("yem_priceloc", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    private void yem_taxamountloc(int rowIndex) {
        BigDecimal yemTotalamountloc = (BigDecimal)this.getModel().getValue("yem_totalamountloc", rowIndex);
        String yemTaxrate = (String)this.getModel().getValue("yem_taxrate", rowIndex);
        BigDecimal bigDecimal = new BigDecimal(yemTaxrate);
        if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue("yem_taxamountloc", (Object)yemTotalamountloc.divide(bigDecimal.add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(bigDecimal), rowIndex);
        } else {
            this.getModel().setValue("yem_taxamountloc", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    private void yem_amountnotaxloc(int rowIndex) {
        BigDecimal yemTotalamountloc = (BigDecimal)this.getModel().getValue("yem_totalamountloc", rowIndex);
        BigDecimal yemTaxamountloc = (BigDecimal)this.getModel().getValue("yem_taxamountloc", rowIndex);
        if (yemTotalamountloc.compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue("yem_amountnotaxloc", (Object)yemTotalamountloc.subtract(yemTaxamountloc), rowIndex);
        } else {
            this.getModel().setValue("yem_amountnotaxloc", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    private void yem_totalamountloc(int rowIndex) {
        BigDecimal yemAmt = (BigDecimal)this.getModel().getValue("yem_amountnotax", rowIndex);
        BigDecimal yemExrate = (BigDecimal)this.getModel().getValue("yem_rate");
        BigDecimal yemFeecurrtotal = (BigDecimal)this.getModel().getValue("yem_feecurrtotal");
        BigDecimal yemInsurcurtotal = (BigDecimal)this.getModel().getValue("yem_insurcurtotal");
        BigDecimal yemOthercutotal = (BigDecimal)this.getModel().getValue("yem_othercutotal");
        BigDecimal yemAmount = (BigDecimal)this.getModel().getValue("yem_amount");
        BigDecimal RMBamt = yemFeecurrtotal.add(yemInsurcurtotal).add(yemOthercutotal);
        BigDecimal divide = BigDecimal.ZERO;
        if (yemAmt != null) {
            if (yemAmount.compareTo(BigDecimal.ZERO) > 0) {
                divide = yemAmt.divide(yemAmount, 2, RoundingMode.HALF_UP);
            }
            BigDecimal multiplied = RMBamt.multiply(divide);
            this.getModel().setValue("yem_totalamountloc", (Object)yemAmt.multiply(yemExrate).subtract(multiplied), rowIndex);
        }
    }

    private void yem_pricenotaxloc(int rowIndex) {
        BigDecimal yemAmountnotaxloc = (BigDecimal)this.getModel().getValue("yem_amountnotaxloc", rowIndex);
        BigDecimal yemQtynotaxloc = (BigDecimal)this.getModel().getValue("yem_qtynotaxloc", rowIndex);
        if (yemQtynotaxloc.compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue("yem_pricenotaxloc", (Object)yemAmountnotaxloc.divide(yemQtynotaxloc, 2, RoundingMode.HALF_UP), rowIndex);
        } else {
            this.getModel().setValue("yem_pricenotaxloc", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    private void yem_fee() {
        String yemFeemarknames = (String)this.getModel().getValue("yem_feemarknames");
        BigDecimal yemFeerate = (BigDecimal)this.getModel().getValue("yem_feerate");
        BigDecimal yemGrossweight = (BigDecimal)this.getModel().getValue("yem_grossweight");
        BigDecimal yemExrate = (BigDecimal)this.getModel().getValue("yem_exrate");
        DynamicObjectCollection yemMaterialentry = this.getModel().getEntryEntity("yem_materialentry");
        BigDecimal yemAmt = BigDecimal.ZERO;
        BigDecimal yem_feecur = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : yemMaterialentry) {
            yemAmt = yemAmt.add(dynamicObject.getBigDecimal("yem_amt"));
        }
        if (yemFeemarknames.isEmpty()) {
            return;
        }
        if (yemFeemarknames.equals("A")) {
            yem_feecur = yemGrossweight.multiply(yemFeerate);
        }
        if (yemFeemarknames.equals("B")) {
            yem_feecur = yemAmt.multiply(yemFeerate);
        }
        if (yemFeemarknames.equals("C")) {
            yem_feecur = yemFeerate;
        }
        this.getModel().setValue("yem_feecur", (Object)yem_feecur);
        this.getModel().setValue("yem_feecurrtotal", (Object)yem_feecur.multiply(yemExrate));
    }

    private void yem_insur() {
        String yemInsurmarknames = (String)this.getModel().getValue("yem_insurmarknames");
        BigDecimal yemInsurrate = (BigDecimal)this.getModel().getValue("yem_insurrate");
        BigDecimal yemGrossweight = (BigDecimal)this.getModel().getValue("yem_grossweight");
        BigDecimal yemExrate = (BigDecimal)this.getModel().getValue("yem_exrate");
        DynamicObjectCollection yemMaterialentry = this.getModel().getEntryEntity("yem_materialentry");
        BigDecimal yemAmt = BigDecimal.ZERO;
        BigDecimal yem_insurcur = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : yemMaterialentry) {
            yemAmt = yemAmt.add(dynamicObject.getBigDecimal("yem_amt"));
        }
        if (yemInsurmarknames.isEmpty()) {
            return;
        }
        if (yemInsurmarknames.equals("A")) {
            yem_insurcur = yemGrossweight.multiply(yemInsurrate);
        }
        if (yemInsurmarknames.equals("B")) {
            yem_insurcur = yemAmt.multiply(yemInsurrate);
        }
        if (yemInsurmarknames.equals("C")) {
            yem_insurcur = yemInsurrate;
        }
        this.getModel().setValue("yem_insurcur", (Object)yem_insurcur);
        this.getModel().setValue("yem_insurcurtotal", (Object)yem_insurcur.multiply(yemExrate));
    }

    private void yem_other() {
        String yemOthermarknames = (String)this.getModel().getValue("yem_othermarknames");
        BigDecimal yemOtherrate = (BigDecimal)this.getModel().getValue("yem_otherrate");
        BigDecimal yemGrossweight = (BigDecimal)this.getModel().getValue("yem_grossweight");
        BigDecimal yemExrate = (BigDecimal)this.getModel().getValue("yem_exrate");
        DynamicObjectCollection yemMaterialentry = this.getModel().getEntryEntity("yem_materialentry");
        BigDecimal yemAmt = BigDecimal.ZERO;
        BigDecimal yem_othercur = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : yemMaterialentry) {
            yemAmt = yemAmt.add(dynamicObject.getBigDecimal("yem_amt"));
        }
        if (yemOthermarknames.isEmpty()) {
            return;
        }
        if (yemOthermarknames.equals("A")) {
            yem_othercur = yemGrossweight.multiply(yemOtherrate);
        }
        if (yemOthermarknames.equals("B")) {
            yem_othercur = yemAmt.multiply(yemOtherrate);
        }
        if (yemOthermarknames.equals("C")) {
            yem_othercur = yemOtherrate;
        }
        this.getModel().setValue("yem_othercur", (Object)yem_othercur);
        this.getModel().setValue("yem_othercutotal", (Object)yem_othercur.multiply(yemExrate));
    }
}

