/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ce.trade.bill.customerassess.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.armor.core.util.StringUtil;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ClientActions;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.builder.ListRowStyleBuilder;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CustomerAssessFromPlugin
extends AbstractBillPlugIn {
    public static final String KEY_FILED_KSZR = "yem_customeraccess";
    public static final String KEY_FILED_PGLX = "yem_valuationtype";
    public static final String KEY_FILED_PGFA = "yem_scoringscheme";
    public static final String KEY_FILED_PF = "yem_score";
    public static final String KEY_ENTRY_PGMX = "yem_ce_cr_trentryentity";
    public static final BigDecimal DFGZ_SCORE_TYPE = BigDecimal.ONE;
    public static final String[] KSZR_SELECT_FILED = new String[]{"yem_suppliertype", "yem_moreclienttype", "yem_societycreditcode", "yem_merchantstname"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((TextEdit)this.getControl(KEY_FILED_KSZR)).addButtonClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (name) {
            case "yem_valuationtype": {
                if (newValue == null || newValue == oldValue) break;
                switch (newValue.toString()) {
                    case "A": {
                        this.setCustomerAccessInformation(model);
                        break;
                    }
                    case "B": 
                    case "C": {
                        model.setValue(KEY_FILED_KSZR, (Object)"");
                    }
                }
                break;
            }
            case "yem_customeraccess": {
                if (!(newValue instanceof String)) break;
                this.setCustomerAccessInformation(newValue.toString(), model);
                break;
            }
            case "yem_scoringscheme": {
                model.beginInit();
                this.setIndicatorEntry(model, dataEntity);
                model.endInit();
                this.indexweight(model, dataEntity);
                this.changeEntryStyle(model, dataEntity);
                this.setEntryGridCollapse(KEY_ENTRY_PGMX, false, null);
                break;
            }
            case "yem_score": {
                this.indexweight(model, dataEntity);
                this.changeEntryStyle(model, dataEntity);
            }
        }
    }

    public void afterLoadData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String billstatus = dataEntity.getString("billstatus");
        if ("A".equals(billstatus)) {
            this.setEntryGridCollapse(KEY_ENTRY_PGMX, false, null);
        }
        this.changeEntryStyle(model, dataEntity);
    }

    private void setIndicatorEntry(IDataModel model, DynamicObject dataEntity) {
        DynamicObject itemScheme = dataEntity.getDynamicObject(KEY_FILED_PGFA);
        model.deleteEntryData(KEY_ENTRY_PGMX);
        if (itemScheme != null) {
            itemScheme = BusinessDataServiceHelper.loadSingle((Object)itemScheme.getPkValue(), (String)itemScheme.getDynamicObjectType().getName());
            DynamicObjectCollection risk_riskasse = itemScheme.getDynamicObjectCollection("yem_ce_sp_treeentry");
            HashSet<Integer> entryIDs = this.getEntryIDs(risk_riskasse, true);
            int entryRow = 0;
            int entryRows = 0;
            for (int i = 0; i < risk_riskasse.size(); ++i) {
                DynamicObject loaded = (DynamicObject)risk_riskasse.get(i);
                if (entryIDs.contains(i)) {
                    entryRow = model.createNewEntryRow(KEY_ENTRY_PGMX);
                    model.setValue("yem_scoreindexgroup", (Object)loaded.getDynamicObject("yem_scoreindexgroup"), entryRow);
                    model.setValue("yem_weight", (Object)loaded.getBigDecimal("yem_weight"), entryRow);
                    model.setValue("yem_isperson", (Object)loaded.getBoolean("yem_scorerequired"), entryRow);
                    continue;
                }
                entryRows = model.insertEntryRow(KEY_ENTRY_PGMX, entryRow);
                model.setValue("yem_scoringrubrics", (Object)loaded.getDynamicObject("yem_scoringrubrics"), entryRows);
                model.setValue("yem_descindicator", (Object)loaded.getString("yem_scoringrubrics.yem_indicator"), entryRows);
                model.setValue("yem_weight", (Object)loaded.getBigDecimal("yem_weight"), entryRows);
                model.setValue("yem_isperson", (Object)loaded.getBoolean("yem_scorerequired"), entryRows);
            }
        }
        this.getView().updateView(KEY_ENTRY_PGMX);
    }

    private void changeEntryStyle(IDataModel model, DynamicObject dataEntity) {
        DynamicObjectCollection entryEntity = model.getEntryEntity(KEY_ENTRY_PGMX);
        Set<Integer> sets = entryEntity.stream().filter(x -> x.getLong("pid") > 0L).filter(x -> x.getBigDecimal(KEY_FILED_PF) == null || BigDecimal.ZERO.compareTo(x.getBigDecimal(KEY_FILED_PF)) == 0).filter(x -> x.getBoolean("yem_isperson")).map(x -> x.getInt("seq") - 1).collect(Collectors.toSet());
        Set set_lock = entryEntity.stream().filter(x -> !x.getBoolean("yem_isperson")).map(x -> x.getInt("seq") - 1).collect(Collectors.toSet());
        set_lock.addAll(this.getEntryIDs(entryEntity, true));
        for (Integer i : set_lock) {
            this.getView().setEnable(Boolean.valueOf(false), i.intValue(), new String[]{KEY_FILED_PF});
        }
        this.changEntryBackgroundColor(this.getEntryIDs(entryEntity, true), KEY_ENTRY_PGMX, "#FFF8E1");
        this.changEntryBackgroundColor(this.getEntryIDs(entryEntity, false), KEY_ENTRY_PGMX, "white");
        this.changEntryBackgroundColor(sets, KEY_ENTRY_PGMX, "#28c067");
    }

    private void changEntryBackgroundColor(Set<Integer> index, String entryID, String color) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        ListRowStyleBuilder rowStyleBuilder = ClientActions.createRowStyleBuilder();
        rowStyleBuilder.setRows(this.listToArray(new ArrayList<Integer>(index)));
        rowStyleBuilder.setBackColor(color);
        rowStyleBuilder.buildStyle();
        rowStyleBuilder.build();
        rowStyleBuilder.invokeControlMethod(proxy, entryID);
    }

    private int[] listToArray(ArrayList<Integer> index) {
        int[] ints = new int[index.size()];
        for (int i = 0; i < index.size(); ++i) {
            ints[i] = index.get(i);
        }
        return ints;
    }

    private void setEntryGridCollapse(String entryID, boolean isCollapse, int[] index) {
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(entryID);
        if (index != null) {
            if (isCollapse) {
                grid.collapse(index);
            } else {
                grid.expand(index);
            }
        } else {
            grid.setCollapse(isCollapse);
        }
    }

    private void indexweight(IDataModel model, DynamicObject dataEntity) {
        BigDecimal field;
        DynamicObjectCollection entryEntity = model.getEntryEntity(KEY_ENTRY_PGMX);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> map_weight = new HashMap<String, BigDecimal>();
        for (DynamicObject row : entryEntity) {
            String pid = row.getString("pid");
            BigDecimal yem_weight = row.getBigDecimal("yem_weight");
            BigDecimal yem_score = row.getBigDecimal(KEY_FILED_PF);
            BigDecimal div = yem_weight.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP);
            if (yem_score == null) {
                map_weight.merge(pid, div, BigDecimal::add);
                continue;
            }
            field = div.multiply(yem_score).setScale(10, RoundingMode.HALF_UP);
            map.merge(pid, field, BigDecimal::add);
            map_weight.merge(pid, BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal tpv_riskscore = BigDecimal.ZERO;
        for (DynamicObject row : entryEntity) {
            String id = row.getString("id");
            if (!map.containsKey(id)) continue;
            BigDecimal bigDecimal = (BigDecimal)map.get(id);
            BigDecimal weight = (BigDecimal)map_weight.get(id);
            bigDecimal = bigDecimal.divide(BigDecimal.ONE.subtract(weight), 10, RoundingMode.HALF_UP);
            BigDecimal yem_weight = row.getBigDecimal("yem_weight");
            row.set(KEY_FILED_PF, (Object)bigDecimal.multiply(DFGZ_SCORE_TYPE));
            BigDecimal div = yem_weight.divide(new BigDecimal("100"), 10, RoundingMode.HALF_UP);
            field = div.multiply(bigDecimal).setScale(10, RoundingMode.HALF_DOWN);
            tpv_riskscore = field.add(tpv_riskscore);
        }
        model.setValue("yem_totalscore", (Object)tpv_riskscore.setScale(0, RoundingMode.HALF_UP));
        this.getView().updateView(KEY_ENTRY_PGMX);
    }

    private HashSet<Integer> getEntryIDs(DynamicObjectCollection collection, boolean isParentRow) {
        HashSet<Integer> ids = new HashSet<Integer>();
        HashSet<Integer> pids = new HashSet<Integer>();
        for (int i = 0; i < collection.size(); ++i) {
            long pid = ((DynamicObject)collection.get(i)).getLong("pid");
            ids.add(i);
            if (pid <= 0L) continue;
            pids.add(i);
        }
        ids.removeAll(pids);
        return isParentRow ? ids : pids;
    }

    private void setCustomerAccessInformation(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        this.setCustomerAccessInformation(dataEntity.getString(KEY_FILED_KSZR), model);
    }

    private void setCustomerAccessInformation(String number, IDataModel model) {
        String supplierType = "";
        String moreClientType = "";
        String merChantstName = "";
        String societyCreditCode = "";
        if (StringUtil.isNotBlank((String)number)) {
            QFilter qFilter = new QFilter("billno", "=", (Object)number);
            DynamicObject customerAccess = BusinessDataServiceHelper.loadSingle((String)"yem_cs_customeraccess", (String)String.join((CharSequence)",", KSZR_SELECT_FILED), (QFilter[])new QFilter[]{qFilter});
            if (customerAccess != null) {
                supplierType = customerAccess.getString("yem_suppliertype");
                moreClientType = customerAccess.getString("yem_moreclienttype");
                merChantstName = customerAccess.getString("yem_merchantstname");
                societyCreditCode = customerAccess.getString("yem_societycreditcode");
            }
        }
        model.setValue("yem_suppliertype", (Object)supplierType);
        model.setValue("yem_moreclienttype", (Object)moreClientType);
        model.setValue("yem_merchantstname", (Object)merChantstName);
        model.setValue("yem_societycreditcode", (Object)societyCreditCode);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals(KEY_FILED_KSZR)) {
            this.showBillList("yem_cs_customeraccess");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (actionId.equals(KEY_FILED_KSZR) && returnData != null && !returnData.isEmpty()) {
            this.getModel().setValue(KEY_FILED_KSZR, (Object)returnData.get(0).getBillNo());
        }
    }

    private void showBillList(String keyFiled) {
        ListShowParameter listParam = new ListShowParameter();
        listParam.setBillFormId(keyFiled);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)keyFiled);
        listParam.setFormId(formConfig.getF7ListFormId());
        listParam.setParentPageId(this.getView().getPageId());
        listParam.setMultiSelect(false);
        listParam.setStatus(OperationStatus.VIEW);
        listParam.getOpenStyle().setShowType(ShowType.Modal);
        listParam.getOpenStyle().setCacheId(listParam.getPageId());
        listParam.setLookUp(true);
        listParam.setCaption(EntityMetadataCache.getDataEntityType((String)keyFiled).getDisplayName().getLocaleValue());
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setWidth("1200px");
        inlineStyleCss.setHeight("600px");
        listParam.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), KEY_FILED_KSZR);
        listParam.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listParam);
    }
}

