/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.ident.module.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.de.utils.F7Helper;

public class RecordBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        this.initData(this.getView());
    }

    private void initData(IFormView view) {
        IDataModel model = this.getModel();
        Map params = view.getFormShowParameter().getCustomParams();
        if (params != null && !((Boolean)params.get("isbegine")).booleanValue()) {
            String billKey = (String)params.get("billKey");
            this.getModel().setValue("org", params.get("orgId"));
            this.getModel().setValue("yem_datatype", (Object)("cas_recbill".equals(billKey) ? "1" : "2"));
            this.getModel().setValue("yem_isbeginning", params.get("isbegine"));
            DynamicObject accountingsys = BusinessDataServiceHelper.loadSingle((String)"bd_accountingsys_base", (String)"id,basecurrrency,exratetable,baseacctorg", (QFilter[])new QFilter[]{new QFilter("baseacctorg", "=", params.get("orgId"))});
            if (accountingsys != null) {
                model.setValue("yem_exratetable", accountingsys.get("exratetable"));
                model.setValue("yem_tocurr", accountingsys.get("basecurrrency"));
            }
            EntryGrid entryGrid = (EntryGrid)view.getControl("yem_cnb_crdjl_ysfkxx");
            List properties_this = entryGrid.getItems().stream().map(Control::getKey).collect(Collectors.toList());
            List billIds = (List)params.get("billIds");
            List entryIds = (List)params.get("entryIds");
            String selectFields = "cas_recbill".equals(billKey) ? "id,currency,payertype,payer" : "id,currency,payeetype,payee";
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)billKey, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIds)});
            if (bills.length > 0) {
                model.setValue("yem_fromcurr", bills[0].get("currency"));
                model.setValue("yem_accounttype", bills[0].get("cas_recbill".equals(billKey) ? "payertype" : "payeetype"));
                model.setValue("yem_cusorsupp", bills[0].get("cas_recbill".equals(billKey) ? "payer" : "payee"));
            }
            for (DynamicObject bill : bills) {
                bill = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.getLong("id"), (String)billKey);
                DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
                DataEntityPropertyCollection properties = entry.getDynamicObjectType().getProperties();
                for (DynamicObject row : entry) {
                    if (!entryIds.contains(row.getLong("id"))) continue;
                    int index = model.createNewEntryRow("yem_cnb_crdjl_ysfkxx");
                    model.setValue("yem_recpaytype", (Object)billKey, index);
                    model.setValue("yem_recpaybillno", bill.get("billno"), index);
                    model.setValue("yem_recpayid", bill.get("id"), index);
                    model.setValue("yem_recpayentryid", row.get("id"), index);
                    model.setValue("yem_payment", row.get("e_expenseitem"), index);
                    model.setValue("yem_recpaydate", bill.get("bizdate"), index);
                    model.setValue("yem_exratedate", bill.get("exratedate"), index);
                    model.setValue("yem_exrate", bill.get("exchangerate"), index);
                    if ("cas_recbill".equals(billKey)) {
                        model.setValue("yem_receivingtype", row.get("e_receivingtype"), index);
                        model.setValue("yem_rectype", row.get("yem_naturetype_e"), index);
                    } else {
                        model.setValue("yem_paymenttype", row.get("e_paymenttype"), index);
                        model.setValue("yem_paytype", bill.get("yem_naturetype"), index);
                    }
                    for (IDataEntityProperty property : properties) {
                        String name = property.getName();
                        if (!properties_this.contains(name)) continue;
                        model.setValue(name, row.get(name), index);
                    }
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"yem_advcontoolbarap"});
        ((BasedataEdit)this.getControl("yem_purbillnox")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("yem_puragreex")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("yem_salebillnox")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("yem_saleagreex")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("yem_ysfkxx_crd".equals(itemKey)) {
            this.createEntryRow(this.getModel());
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if ("yem_cnb_crdjl_ysfkxx".equals(name)) {
            this.delCheck(this.getModel(), e);
        }
    }

    private void delCheck(IDataModel model, BeforeDeleteRowEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("yem_cnb_crdjl_ysfkxx");
        String entryKeyName = this.getModel().getEntryEntity("yem_cnb_crdjl_ysfkxx").getDynamicObjectType().getDisplayName().getLocaleValue_zh_CN();
        int[] selectRows = entryGrid.getSelectRows();
        boolean isreturn = false;
        for (int selectRow : selectRows) {
            Long recpayentryid = (Long)model.getValue("yem_recpayentryid", selectRow);
            DynamicObjectCollection rows = model.getEntryEntity("yem_cnb_crdjl_xsfkxx");
            List recpayentryidx = rows.stream().filter(x -> x.getLong("yem_recpayentryidx") == recpayentryid.longValue()).map(x -> x.getInt("seq")).collect(Collectors.toList());
            List stringList = recpayentryidx.stream().map(Object::toString).collect(Collectors.toList());
            if (recpayentryidx.size() <= 0) continue;
            String entryName = rows.getDynamicObjectType().getDisplayName().getLocaleValue_zh_CN();
            this.getView().showTipNotification(String.format("{%s}\u4e2d\u7b2c%s\u884c\uff0c\u5728{%s}\u4e2d\u5b58\u5728\u76f8\u5bf9\u5e94\u7684\u6570\u636e\uff0c\u8bf7\u5148\u5220\u9664{%s}\u7b2c%s\u884c\u3002", entryKeyName, selectRow + 1, entryName, entryName, String.join((CharSequence)"\u3001", stringList)));
            isreturn = true;
        }
        if (isreturn) {
            e.setCancel(true);
        }
    }

    private void createEntryRow(IDataModel model) {
        int[] selectRows;
        EntryGrid entryGrid = (EntryGrid)this.getControl("yem_cnb_crdjl_ysfkxx");
        for (int selectRow : selectRows = entryGrid.getSelectRows()) {
            DynamicObject rowEntity = model.getEntryRowEntity("yem_cnb_crdjl_ysfkxx", selectRow);
            int index = model.createNewEntryRow("yem_cnb_crdjl_xsfkxx");
            model.setValue("yem_recpaytypex", rowEntity.get("yem_recpaytype"), index);
            model.setValue("yem_recpaybillnox", rowEntity.get("yem_recpaybillno"), index);
            model.setValue("yem_recpayidx", rowEntity.get("yem_recpayid"), index);
            model.setValue("yem_recpayentryidx", rowEntity.get("yem_recpayentryid"), index);
            model.setValue("yem_exratedatex", rowEntity.get("yem_exratedate"), index);
            model.setValue("yem_exratex", rowEntity.get("yem_exrate"), index);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "yem_salebillnox": 
            case "yem_saleagreex": {
                this.setSaleFilter(e);
                break;
            }
            case "yem_purbillnox": 
            case "yem_puragreex": {
                this.setPurFilter(e);
            }
        }
    }

    private void setPurFilter(BeforeF7SelectEvent e) {
        int index = this.getModel().getEntryCurrentRowIndex("yem_cnb_crdjl_xsfkxx");
        String recpaytypex = (String)this.getModel().getValue("yem_recpaytypex", index);
        Long recpayidx = (Long)this.getModel().getValue("yem_recpayidx", index);
        if ("cas_paybill".equals(recpaytypex)) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)recpayidx, (String)recpaytypex);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter qFilter = new QFilter("yem_accounttype", "=", (Object)"bd_supplier");
            qFilter = qFilter.and(new QFilter("yem_cusorsupp", "=", (Object)bill.getLong("payee")));
            qFilter.or(new QFilter("number", "=", (Object)"HT-000001"));
            qFilters.add(qFilter);
            F7Helper.addF7Filter((BeforeF7SelectEvent)e, qFilters);
        }
    }

    private void setSaleFilter(BeforeF7SelectEvent e) {
        int index = this.getModel().getEntryCurrentRowIndex("yem_cnb_crdjl_xsfkxx");
        String recpaytypex = (String)this.getModel().getValue("yem_recpaytypex", index);
        Long recpayidx = (Long)this.getModel().getValue("yem_recpayidx", index);
        if ("cas_recbill".equals(recpaytypex)) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)recpayidx, (String)recpaytypex);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter qFilter = new QFilter("yem_accounttype", "=", (Object)"bd_customer");
            qFilter = qFilter.and(new QFilter("yem_cusorsupp", "=", (Object)bill.getLong("payer")));
            qFilter.or(new QFilter("number", "=", (Object)"HT-000001"));
            qFilters.add(qFilter);
            F7Helper.addF7Filter((BeforeF7SelectEvent)e, qFilters);
        }
    }
}

