/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.ident.module.opplugin.op;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PaySubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("yem_recid");
        fieldKeys.add("yem_recentryid");
        fieldKeys.add("e_actamt");
        fieldKeys.add("yem_recbillno");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        String key = (String)this.operateMeta.get("key");
        if ("beforesubmit".equals(key)) {
            e.addValidator(new AbstractValidator(){

                public void validate() {
                    for (ExtendedDataEntity extendedData : this.getDataEntities()) {
                        DynamicObject dataEntity = extendedData.getDataEntity();
                        DynamicObjectCollection entryRow = dataEntity.getDynamicObjectCollection("entry");
                        for (DynamicObject row : entryRow) {
                            BigDecimal canrecamt;
                            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                            qFilters.add(new QFilter("id", "=", (Object)row.getLong("yem_recid")));
                            qFilters.add(new QFilter("entry.id", "=", (Object)row.getLong("yem_recentryid")));
                            DynamicObjectCollection bills = QueryServiceHelper.query((String)"cas_recbill", (String)"entry.yem_canrecamt yem_canrecamt", (QFilter[])qFilters.toArray(new QFilter[0]));
                            if (bills.size() != 1 || (canrecamt = ((DynamicObject)bills.get(0)).getBigDecimal("yem_canrecamt")).compareTo(row.getBigDecimal("e_actamt")) >= 0) continue;
                            this.addMessage(extendedData, String.format("\u4ed8\u6b3e\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s\uff0c\u5bf9\u5e94\u7684\u6536\u6b3e\u5355\u636e\u7f16\u53f7%s\u53ef\u91cd\u8ba4\u5b9a\u91d1\u989d\u5c0f\u4e8e\u672c\u6b21\u9000\u6b3e\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", dataEntity.getString("billno"), row.getString("yem_recbillno")));
                        }
                    }
                }
            });
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        block8: for (DynamicObject dataEntity : e.getDataEntities()) {
            switch (e.getOperationKey()) {
                case "audit": {
                    this.backRec(dataEntity, true);
                    continue block8;
                }
                case "unaudit": {
                    this.backRec(dataEntity, false);
                }
            }
        }
    }

    private void backRec(DynamicObject dataEntity, boolean isadd) {
        DynamicObjectCollection entryRow = dataEntity.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entryRow) {
            Long recid = entry.getLong("yem_recid");
            long recentryid = entry.getLong("yem_recentryid");
            DynamicObject recbill = BusinessDataServiceHelper.loadSingleFromCache((Object)recid, (String)"cas_recbill");
            if (recbill == null) continue;
            DynamicObjectCollection recEntryRow = recbill.getDynamicObjectCollection("entry");
            for (DynamicObject recEntry : recEntryRow) {
                if (recEntry.getLong("id") != recentryid) continue;
                BigDecimal e_actamt = entry.getBigDecimal("e_actamt");
                e_actamt = isadd ? e_actamt : BigDecimal.ZERO.subtract(e_actamt);
                e_actamt = e_actamt.add(recEntry.getBigDecimal("yem_returnamt"));
                recEntry.set("yem_returnamt", (Object)e_actamt);
                BigDecimal actamt = recEntry.getBigDecimal("e_actamt");
                BigDecimal recamt = recEntry.getBigDecimal("yem_recamt");
                recEntry.set("yem_canrecamt", (Object)actamt.subtract(recamt).subtract(e_actamt));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recbill});
        }
    }
}

