/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.ident.module.opplugin.op;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.utils.YEM;

public class RecordAuditOpPlugin
extends AbstractOperationServicePlugIn {
    public void endOperationTransaction(EndOperationTransactionArgs e) {
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (DynamicObject dataEntity : e.getDataEntities()) {
            if ((dataEntity = BusinessDataServiceHelper.loadSingleFromCache((Object)dataEntity.getLong("id"), (String)dataEntity.getDataEntityType().getName())).getBoolean("yem_isbeginning")) continue;
            this.mainLogic(dataEntity);
        }
    }

    private void mainLogic(DynamicObject dataEntity) {
        String datatype = dataEntity.getString("yem_datatype");
        if (datatype.equals("1") || datatype.equals("2")) {
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("yem_cnb_crdjl_ysfkxx");
            Map<Long, List<DynamicObject>> groupByBillId = collection.stream().collect(Collectors.groupingBy(x -> x.getLong("yem_recpayid")));
            for (Long billId : groupByBillId.keySet()) {
                this.createRedBill(billId, groupByBillId, datatype, dataEntity);
                this.createBlueBill(billId, groupByBillId, datatype, dataEntity);
                this.backIdentAmt(billId, dataEntity, datatype);
            }
        }
    }

    private void backIdentAmt(Long billId, DynamicObject dataEntity, String datatype) {
        String billKey = "1".equals(datatype) ? "cas_recbill" : "cas_paybill";
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection("yem_cnb_crdjl_xsfkxx");
        Map<Long, List<DynamicObject>> groupByEntryId = entryRows.stream().collect(Collectors.groupingBy(x -> x.getLong("yem_recpayentryidx")));
        DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)billKey);
        DynamicObjectCollection rows = bill.getDynamicObjectCollection("entry");
        for (DynamicObject row : rows) {
            Long entryId = row.getLong("id");
            if (!groupByEntryId.containsKey(entryId)) continue;
            BigDecimal amt = groupByEntryId.get(entryId).stream().map(x -> x.getBigDecimal("yem_recpayamtx")).reduce(BigDecimal.ZERO, BigDecimal::add);
            amt = row.getBigDecimal("yem_recamt").add(amt);
            row.set("yem_recamt", (Object)amt);
            BigDecimal e_actamt = row.getBigDecimal("e_actamt");
            BigDecimal yem_returnamt = row.getBigDecimal("yem_returnamt");
            row.set("yem_canrecamt", (Object)e_actamt.subtract(amt).subtract(yem_returnamt));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
    }

    private void createBlueBill(Long billId, Map<Long, List<DynamicObject>> groupByBillId, String datatype, DynamicObject dataEntity) {
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection("yem_cnb_crdjl_xsfkxx");
        Map<Long, List<DynamicObject>> groupByEntryId = entryRows.stream().collect(Collectors.groupingBy(x -> x.getLong("yem_recpayentryidx")));
        String billKey = "1".equals(datatype) ? "cas_recbill" : "cas_paybill";
        DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)billKey);
        DynamicObject createblue = (DynamicObject)OrmUtils.clone((Object)bill, (IDataEntityType)bill.getDataEntityType(), (boolean)true, (boolean)true);
        DynamicObjectCollection entryBlueRow = createblue.getDynamicObjectCollection("entry");
        DynamicObjectCollection entryRow = bill.getDynamicObjectCollection("entry");
        entryBlueRow.clear();
        BigDecimal amtSumTotal = BigDecimal.ZERO;
        BigDecimal amtSumBaseTotal = BigDecimal.ZERO;
        DynamicObject natureType = null;
        String natureKey = "cas_recbill".equals(billKey) ? "yem_rectypenew" : "yem_paytypenew";
        ArrayList<DynamicObject> newRows = new ArrayList<DynamicObject>();
        for (DynamicObject entry : entryRow) {
            Long entryId = entry.getLong("id");
            if (!groupByEntryId.containsKey(entryId)) continue;
            List<DynamicObject> newCreateBills = groupByEntryId.get(entryId);
            natureType = newCreateBills.get(0).getDynamicObject(natureKey);
            for (DynamicObject createBill : newCreateBills) {
                DynamicObject saleagree;
                DynamicObject addNew = (DynamicObject)OrmUtils.clone((Object)entry, (IDataEntityType)entry.getDataEntityType(), (boolean)true, (boolean)true);
                BigDecimal recpayamtx = createBill.getBigDecimal("yem_recpayamtx");
                amtSumTotal = amtSumTotal.add(recpayamtx);
                addNew.set("1".equals(datatype) ? "e_receivableamt" : "e_payableamt", (Object)recpayamtx);
                addNew.set("e_actamt", (Object)recpayamtx);
                addNew.set("e_unlockamt", (Object)recpayamtx);
                addNew.set("e_unsettledamt", (Object)recpayamtx);
                addNew.set("yem_canrecamt", (Object)recpayamtx);
                addNew.set("yem_recamt", (Object)BigDecimal.ZERO);
                addNew.set("yem_returnamt", (Object)BigDecimal.ZERO);
                BigDecimal curramt = createBill.getBigDecimal("yem_curramt");
                amtSumBaseTotal = amtSumBaseTotal.add(curramt);
                addNew.set("1".equals(datatype) ? "e_receivablelocamt" : "e_payablelocamt", (Object)curramt);
                addNew.set("e_localamt", (Object)curramt);
                addNew.set("e_unsettledlocalamt", (Object)curramt);
                if ("cas_recbill".equals(billKey)) {
                    addNew.set("yem_naturetype_e", createBill.get("yem_rectypenew"));
                }
                addNew.set("e_expenseitem", createBill.get("yem_paymentx"));
                DynamicObject salebillno = createBill.getDynamicObject("yem_salebillnox");
                if (salebillno != null) {
                    salebillno = BusinessDataServiceHelper.loadSingleFromCache((Object)salebillno.getLong("id"), (String)salebillno.getDynamicObjectType().getName());
                    addNew.set("yem_salebillno", (Object)salebillno);
                    addNew.set("e_corebilltype", (Object)salebillno.getString("yem_billkey"));
                    addNew.set("e_corebillid", (Object)salebillno.getLong("yem_billid"));
                    addNew.set("e_corebillno", (Object)salebillno.getString("yem_billno"));
                }
                if ((saleagree = createBill.getDynamicObject("yem_saleagreex")) != null) {
                    saleagree = BusinessDataServiceHelper.loadSingleFromCache((Object)saleagree.getLong("id"), (String)saleagree.getDynamicObjectType().getName());
                    addNew.set("yem_saleagree", (Object)saleagree);
                    addNew.set("e_corebilltype", (Object)saleagree.getString("yem_billkey"));
                    addNew.set("e_corebillid", (Object)saleagree.getLong("yem_billid"));
                    addNew.set("e_corebillno", (Object)saleagree.getString("yem_billno"));
                }
                addNew.set("e_sourcebillid", (Object)0L);
                addNew.set("e_sourcebillentryid", (Object)0L);
                newRows.add(addNew);
            }
        }
        entryBlueRow.addAll(newRows);
        this.setCreateValue(createblue, amtSumTotal, amtSumBaseTotal, billKey, billId, bill);
        if ("cas_paybill".equals(billKey)) {
            createblue.set("yem_naturetype", natureType);
        }
        createblue.set("yem_recordbillno", (Object)dataEntity.getString("billno"));
        OperateOption option = YEM.getOption();
        option.setVariableValue("coderule_billno_from_init", "");
        option.setVariableValue("coderule_recycle", "");
        option.setVariableValue("WF", "TRUE");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)billKey, (DynamicObject[])new DynamicObject[]{createblue}, (OperateOption)option);
        if (submitResult.isSuccess()) {
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)billKey, (DynamicObject[])new DynamicObject[]{createblue}, (OperateOption)YEM.getOption());
            if (!auditResult.isSuccess()) {
                throw new KDBizException(String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\uff1a\u5ba1\u6838\u84dd\u5b57\u5355\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a%s", groupByBillId.get(billId).get(0).getString("yem_recpaybillno"), YEM.getOpErrorMsgNoTitle((OperationResult)auditResult)));
            }
        } else {
            throw new KDBizException(String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\uff1a\u63d0\u4ea4\u84dd\u5b57\u5355\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a%s", groupByBillId.get(billId).get(0).getString("yem_recpaybillno"), YEM.getOpErrorMsgNoTitle((OperationResult)submitResult)));
        }
        createblue.set("billstatus", (Object)"D");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{createblue});
    }

    private void setCreateValue(DynamicObject createblue, BigDecimal amtSumTotal, BigDecimal amtSumBaseTotal, String billKey, Long billId, DynamicObject bill) {
        createblue.set("bizdate", (Object)new Date());
        createblue.set("yem_actdate", (Object)bill.getDate("bizdate"));
        createblue.set("cas_recbill".equals(billKey) ? "actrecamt" : "actpayamt", (Object)amtSumTotal);
        createblue.set("unsettleamount", (Object)amtSumTotal);
        createblue.set("localamt", (Object)amtSumBaseTotal);
        createblue.set("unsettleamountbase", (Object)amtSumBaseTotal);
        createblue.set("localamt", (Object)amtSumBaseTotal);
        createblue.set("unsettleamountbase", (Object)amtSumBaseTotal);
        createblue.set("sourcebilltype", (Object)"");
        createblue.set("sourcebillnumber", (Object)"");
        createblue.set("sourcebillid", (Object)0L);
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)billKey, (DynamicObject)createblue, null);
        String generateNumber = null;
        if (codeRule != null) {
            CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)createblue);
            generateNumber = codeRule.getNumber();
        }
        if (StringUtils.isEmpty(generateNumber)) {
            generateNumber = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        }
        createblue.set("yem_isrecord", (Object)true);
        createblue.set("billno", (Object)generateNumber);
        createblue.set("billstatus", (Object)"A");
    }

    private void createRedBill(Long billId, Map<Long, List<DynamicObject>> groupByBillId, String datatype, DynamicObject dataEntity) {
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection("yem_cnb_crdjl_xsfkxx");
        Map<Long, List<DynamicObject>> groupByEntryId = entryRows.stream().collect(Collectors.groupingBy(x -> x.getLong("yem_recpayentryidx")));
        String billKey = "1".equals(datatype) ? "cas_recbill" : "cas_paybill";
        DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)billKey);
        DynamicObject createRed = (DynamicObject)OrmUtils.clone((Object)bill, (IDataEntityType)bill.getDataEntityType(), (boolean)true, (boolean)true);
        DynamicObjectCollection entryRedRow = createRed.getDynamicObjectCollection("entry");
        DynamicObjectCollection entryRow = bill.getDynamicObjectCollection("entry");
        entryRedRow.clear();
        BigDecimal amtSumTotal = BigDecimal.ZERO;
        BigDecimal amtSumBaseTotal = BigDecimal.ZERO;
        ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>();
        for (DynamicObject entry : entryRow) {
            if (!groupByEntryId.containsKey(entry.getLong("id"))) continue;
            DynamicObject addNew = (DynamicObject)OrmUtils.clone((Object)entry, (IDataEntityType)entry.getDataEntityType(), (boolean)true, (boolean)true);
            BigDecimal amtSum = BigDecimal.ZERO.subtract(groupByEntryId.get(entry.getLong("id")).stream().map(x -> x.getBigDecimal("yem_recpayamtx")).reduce(BigDecimal.ZERO, BigDecimal::add));
            addNew.set("e_actamt", (Object)amtSum);
            addNew.set("1".equals(datatype) ? "e_receivableamt" : "e_payableamt", (Object)amtSum);
            addNew.set("yem_canrecamt", (Object)amtSum);
            addNew.set("e_unlockamt", (Object)amtSum);
            addNew.set("e_unsettledamt", (Object)amtSum);
            amtSumTotal = amtSumTotal.add(amtSum);
            addNew.set("yem_recamt", (Object)BigDecimal.ZERO);
            addNew.set("yem_returnamt", (Object)BigDecimal.ZERO);
            BigDecimal amtSumBase = BigDecimal.ZERO.subtract(groupByEntryId.get(entry.getLong("id")).stream().map(x -> x.getBigDecimal("yem_curramt")).reduce(BigDecimal.ZERO, BigDecimal::add));
            addNew.set("1".equals(datatype) ? "e_receivablelocamt" : "e_payablelocamt", (Object)amtSumBase);
            addNew.set("e_localamt", (Object)amtSumBase);
            addNew.set("e_unsettledlocalamt", (Object)amtSumBase);
            amtSumBaseTotal = amtSumBaseTotal.add(amtSumBase);
            addNew.set("e_sourcebillid", (Object)0L);
            addNew.set("e_sourcebillentryid", (Object)0L);
            addList.add(addNew);
        }
        if (addList.size() > 0) {
            entryRedRow.addAll(addList);
        }
        this.setCreateValue(createRed, amtSumTotal, amtSumBaseTotal, billKey, billId, bill);
        createRed.set("yem_recordbillno", (Object)dataEntity.getString("billno"));
        OperateOption option = YEM.getOption();
        option.setVariableValue("coderule_billno_from_init", "");
        option.setVariableValue("coderule_recycle", "");
        option.setVariableValue("WF", "TRUE");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)billKey, (DynamicObject[])new DynamicObject[]{createRed}, (OperateOption)option);
        if (submitResult.isSuccess()) {
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)billKey, (DynamicObject[])new DynamicObject[]{createRed}, (OperateOption)option);
            if (!auditResult.isSuccess()) {
                throw new KDBizException(String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\uff1a\u5ba1\u6838\u7ea2\u5b57\u5355\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a%s", groupByBillId.get(billId).get(0).getString("yem_recpaybillno"), YEM.getOpErrorMsgNoTitle((OperationResult)auditResult)));
            }
        } else {
            throw new KDBizException(String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\uff1a\u63d0\u4ea4\u7ea2\u5b57\u5355\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a%s", groupByBillId.get(billId).get(0).getString("yem_recpaybillno"), YEM.getOpErrorMsgNoTitle((OperationResult)submitResult)));
        }
        createRed.set("billstatus", (Object)"D");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{createRed});
    }
}

