/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.ident.module.opplugin.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import yem.base.common.utils.YEM;

public class RecordSubmitValidatorPlugin
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedData : this.getDataEntities()) {
            this.checkAmt(extendedData);
        }
    }

    private void checkAmt(ExtendedDataEntity extendedData) {
        String type;
        DynamicObject dataEntity = extendedData.getDataEntity();
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("yem_cnb_crdjl_ysfkxx");
        String entryname = collection.getDynamicObjectType().getDisplayName().getLocaleValue_zh_CN();
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject row = (DynamicObject)collection.get(i);
            BigDecimal canrecamt = row.getBigDecimal("yem_canrecamt");
            BigDecimal thisidentamt = row.getBigDecimal("yem_thisidentamt");
            long recpayentryid = row.getLong("yem_recpayentryid");
            map.put(recpayentryid, thisidentamt);
            if (thisidentamt.compareTo(canrecamt) > 0) {
                this.addMessage(extendedData, String.format("\u6536\u4ed8\u6b3e\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s\uff0c\u91cd\u8ba4\u5b9a\u91d1\u989d\u5927\u4e8e\u53ef\u91cd\u8ba4\u5b9a\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", row.getString("yem_recpaybillno")));
            }
            DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection("yem_cnb_crdjl_xsfkxx");
            String entryName = entryRows.getDynamicObjectType().getDisplayName().getLocaleValue_zh_CN();
            List entryid = entryRows.stream().filter(x -> x.getLong("yem_recpayentryidx") == recpayentryid).collect(Collectors.toList());
            if (entryid.size() != 0) continue;
            this.addMessage(extendedData, String.format("{%s}\u7b2c%s\u884c\uff0c\u6536\u4ed8\u6b3e\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s\uff0c{%s}\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6570\u636e\uff0c\u8bf7\u5220\u9664\u6b64\u884c\u6570\u636e\u3002", entryname, i + 1, row.getString("yem_recpaybillno"), entryName));
        }
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection("yem_cnb_crdjl_xsfkxx");
        Map<Long, List<DynamicObject>> groupByEntryId = entryRows.stream().collect(Collectors.groupingBy(x -> x.getLong("yem_recpayentryidx")));
        for (Long entryId : groupByEntryId.keySet()) {
            BigDecimal amtSum;
            BigDecimal amt = map.getOrDefault(entryId, BigDecimal.ZERO);
            List<DynamicObject> rows = groupByEntryId.get(entryId);
            if (rows.size() <= 0 || (amtSum = rows.stream().map(x -> x.getBigDecimal("yem_recpayamtx")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(amt) == 0) continue;
            this.addMessage(extendedData, String.format("\u6536\u4ed8\u6b3e\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s\uff0c{%s}\u91cd\u8ba4\u5b9a\u91d1\u989d\u4e0d\u7b49\u4e8e{%s}\u7684\u91cd\u8ba4\u5b9a\u91d1\u989d\u6c47\u603b\uff0c\u8bf7\u68c0\u67e5\u3002", rows.get(0).getString("yem_recpaybillnox"), collection.getDynamicObjectType().getDisplayName().getLocaleValue_zh_CN(), entryRows.getDynamicObjectType().getDisplayName().getLocaleValue_zh_CN()));
        }
        Map<String, List<DynamicObject>> groupByBillno = entryRows.stream().collect(Collectors.groupingBy(x -> x.getString("yem_recpaybillnox")));
        String datatype = dataEntity.getString("yem_datatype");
        String string = "1".equals(datatype) ? "yem_rectypenew" : (type = "2".equals(datatype) ? "yem_paytypenew" : "");
        if (YEM.isNotEmpty((Object)type)) {
            for (String billno : groupByBillno.keySet()) {
                List<DynamicObject> rows = groupByBillno.get(billno);
                List typeIds = rows.stream().filter(x -> x.getDynamicObject(type) != null).map(x -> x.getDynamicObject(type).getLong("id")).distinct().collect(Collectors.toList());
                if (typeIds.size() <= 1) continue;
                this.addMessage(extendedData, String.format("\u6536\u4ed8\u6b3e\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s\uff0c\u6b3e\u9879\u6027\u8d28\u4e0d\u7edf\u4e00\uff0c\u8bf7\u68c0\u67e5\u3002", billno, collection.getDynamicObjectType().getDisplayName().getLocaleValue_zh_CN(), entryRows.getDynamicObjectType().getDisplayName().getLocaleValue_zh_CN()));
            }
        }
    }
}

