/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.fw.common.module.bill.lotnum.op.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.SystemParamUtil;
import yem.base.common.utils.YEM;
import yem.wm.fw.common.module.bill.lotnum.utils.LotCodeRuleHelper;

public class StorageCreateLotSubmitOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity exEntity : this.getDataEntities()) {
                    String s;
                    DynamicObject dataEntity = exEntity.getDataEntity();
                    String name = dataEntity.getDataEntityType().getName();
                    String lotnumber = name.equals("im_transdirbill") ? "inlotnumber" : "lotnumber";
                    DynamicObjectCollection billentry = dataEntity.getDynamicObjectCollection("billentry");
                    List rows = billentry.stream().filter(x -> YEM.isNotEmpty((Object)x.getString(lotnumber))).collect(Collectors.toList());
                    ArrayList<String> lots = new ArrayList<String>();
                    for (DynamicObject row : rows) {
                        String number = row.getString(lotnumber);
                        if (lots.contains(number)) continue;
                        lots.add(number);
                    }
                    DynamicObject biztype = dataEntity.getDynamicObject("biztype");
                    String string = s = null != biztype ? biztype.getString("number") : null;
                    if (lots.size() == rows.size()) {
                        Boolean appParam = (Boolean)SystemParamUtil.getAppParam((String)"yem_fw", (String)"yem_automaticallylot");
                        if (null == appParam) {
                            return;
                        }
                        if (appParam.booleanValue() && "im_purinbill".equals(name) && dataEntity.getBoolean("ischargeoff")) break;
                        for (String lot : lots) {
                            DynamicObject[] bd_lot;
                            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                            qFilters.add(new QFilter("number", "=", (Object)lot));
                            qFilters.add(new QFilter("lotstatus", "=", (Object)"A"));
                            if ("im_purinbill".equals(name)) {
                                List srcbillentryid = billentry.stream().map(x -> x.getLong("srcbillentryid")).collect(Collectors.toList());
                                DynamicObjectCollection im_purreceivebill = QueryServiceHelper.query((String)"im_purreceivebill", (String)"billentry.lot lot", (QFilter[])new QFilter[]{new QFilter("billentry", "in", srcbillentryid)});
                                ArrayList<Long> notinlot = new ArrayList<Long>();
                                for (DynamicObject purreceivebill : im_purreceivebill) {
                                    long inlot = purreceivebill.getLong("lot");
                                    if (!YEM.isNotEmpty((Object)inlot) || notinlot.contains(inlot)) continue;
                                    notinlot.add(inlot);
                                }
                                if (notinlot.size() > 0) {
                                    qFilters.add(new QFilter("id", "not in", notinlot));
                                }
                            }
                            if ((bd_lot = BusinessDataServiceHelper.load((String)"bd_lot", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]))).length <= 0 || "im_transdirbill".equals(name) || !"110".equals(s) || !"im_purinbill".equals(name)) continue;
                            this.addErrorMessage(exEntity, String.format("\u6279\u6b21\u53f7\u4e3a:%s\u5b58\u5728\u76f8\u540c\u7684\u6279\u6b21\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", lot));
                        }
                    } else {
                        if ("im_purinbill".equals(name) && "110".equals(s) || "im_saloutbill".equals(name)) break;
                        this.addErrorMessage(exEntity, String.format("%s\u660e\u7ec6\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u6279\u6b21\u53f7\uff0c\u8bf7\u4fee\u6539\u6279\u6b21\u53f7\u3002", dataEntity.getDataEntityType().getDisplayName().getLocaleValue_zh_CN()));
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("entryfield", "billentry");
                    map.put("material", "material");
                    map.put("lotmap", lotnumber);
                    Map<Integer, String> lotCode = LotCodeRuleHelper.getLotCode(dataEntity, map);
                    if (lotCode == null || lotCode.size() <= 0) continue;
                    for (Integer seq : lotCode.keySet()) {
                        String value = lotCode.get(seq);
                        if (value.contains("ERROR")) {
                            value = value.substring(5);
                            this.addMessage(exEntity, value);
                            continue;
                        }
                        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("billentry");
                        for (DynamicObject row : collection) {
                            if (row.getInt("seq") != seq.intValue()) continue;
                            row.set(lotnumber, (Object)value);
                        }
                    }
                }
            }
        });
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(DynamicObjectUtil.addFieldKey((String)this.billEntityType.getName(), (boolean)true));
    }
}

