/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.fw.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.YEM;

public class CalculationToolUtil {
    public static BigDecimal handleBoxPieceCalculation(DynamicObject ent, String qty, String pieceqty) {
        BigDecimal boxgoodsqty = ent.getBigDecimal(qty);
        BigDecimal boxpieceqty = ent.getBigDecimal(pieceqty);
        if (YEM.isEmpty((Object)boxgoodsqty) || YEM.isEmpty((Object)boxpieceqty) || boxpieceqty.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return boxgoodsqty.divide(boxpieceqty, 0, RoundingMode.UP);
    }

    public static BigDecimal handleBoxWeightSumCalculation(DynamicObject ent, String qtyKey, String weightKey) {
        BigDecimal boxgoodsqty = ent.getBigDecimal(qtyKey);
        BigDecimal weight = ent.getBigDecimal(weightKey);
        if (YEM.isEmpty((Object)boxgoodsqty) || YEM.isEmpty((Object)weight)) {
            return null;
        }
        return boxgoodsqty.multiply(weight);
    }

    public static Map<String, BigDecimal> handleBoxVolumeCalculation(DynamicObject ent, Map<String, String> map, DynamicObject munit) {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        BigDecimal boxgoodsqty = ent.getBigDecimal(map.get("qty"));
        String longKey = map != null ? map.get("long") : null;
        BigDecimal boxlong = longKey != null ? ent.getBigDecimal(longKey) : null;
        String wideKey = map != null ? map.get("weide") : null;
        BigDecimal boxwide = wideKey != null ? ent.getBigDecimal(wideKey) : null;
        String highKey = map != null ? map.get("high") : null;
        BigDecimal boxhigh = highKey != null ? ent.getBigDecimal(highKey) : null;
        DynamicObject yemBoxlenghtunitid = ent.getDynamicObject(map.get("lenghtunitid"));
        DynamicObject yemBoxgoodsid = ent.getDynamicObject(map.get("material"));
        BigDecimal unitRate = YEM.getUnitRate((Object)yemBoxgoodsid, (Object)yemBoxlenghtunitid, (Object)munit);
        if (unitRate.compareTo(BigDecimal.ZERO) == 0 || YEM.isEmpty((Object)boxgoodsqty) || YEM.isEmpty((Object)boxlong) || YEM.isEmpty((Object)boxwide) || YEM.isEmpty((Object)boxhigh)) {
            result.put("vol", null);
            result.put("volm3", null);
            result.put("totalvolm3", null);
        } else {
            BigDecimal longm = boxlong.multiply(unitRate);
            BigDecimal widem = boxwide.multiply(unitRate);
            BigDecimal highm = boxhigh.multiply(unitRate);
            BigDecimal boxgoodsvol = boxlong.multiply(boxwide).multiply(boxhigh);
            BigDecimal boxsinglevol = longm.multiply(widem).multiply(highm);
            result.put("vol", boxgoodsvol);
            result.put("volm3", boxsinglevol);
            result.put("totalvolm3", boxsinglevol.multiply(boxgoodsqty));
        }
        return result;
    }

    public static Map<String, Integer> precision(Long id) {
        if (id == null || id == 0L) {
            return null;
        }
        DynamicObject currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        HashMap<String, Integer> amtMap = new HashMap<String, Integer>();
        amtMap.put("amtprecision", currency.getInt("amtprecision"));
        amtMap.put("priceprecision", currency.getInt("priceprecision"));
        return amtMap;
    }

    public static BigDecimal calculateTaxrefund(DynamicObject row, String purchamtaxField, String taxrefundrateField, String vatrateField, int amtprecision, int priceprecision) {
        BigDecimal purchamtax = row.getBigDecimal(purchamtaxField);
        BigDecimal taxrefundrate = row.getBigDecimal(taxrefundrateField);
        BigDecimal vatrate = row.getBigDecimal(vatrateField);
        if (YEM.isEmpty((Object)purchamtax) || YEM.isEmpty((Object)taxrefundrate) || YEM.isEmpty((Object)vatrate)) {
            return null;
        }
        taxrefundrate = taxrefundrate.divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP);
        vatrate = BigDecimal.ONE.add(vatrate.divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP));
        return purchamtax.multiply(taxrefundrate).divide(vatrate, 10, RoundingMode.HALF_UP).setScale(amtprecision, RoundingMode.HALF_UP);
    }
}

