/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ca.affairs.card;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import org.apache.commons.compress.utils.Lists;
import yem.base.common.utils.RptUtil;
import yem.wm.conmmon.common.GraphUtils;

public class CustomsBrokerAmountCardPlugin
extends AbstractFormPlugin {
    private final String algoKey = ((Object)((Object)this)).getClass().getName();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Control control = this.getControl("yem_chart");
        if (control instanceof PointLineChart) {
            PointLineChart chart = (PointLineChart)control;
            LinkedHashMap<String, Map<String, BigDecimal>> barData = this.initBarData();
            GraphUtils.handleDrawChart((PointLineChart)chart, barData, barData, (String)"\u62a5\u5173\u884c/\u6708\u4efd", (String)"\u62a5\u5173\u91d1\u989d\uff08\u4e07\u5143\uff09", (Collection)barData.keySet().stream().map(month -> month + "\u6708\u4efd").collect(Collectors.toCollection(LinkedHashSet::new)));
        }
    }

    private LinkedHashMap<String, Map<String, BigDecimal>> initBarData() {
        ArrayList selectFields = Lists.newArrayList();
        selectFields.add("yem_agentname");
        selectFields.add("yem_sumlocdecltotal");
        selectFields.add("yem_fiedatets");
        ArrayList<QFilter> qFilter = new ArrayList<QFilter>();
        qFilter.add(new QFilter("yem_localcurrency.number", "=", (Object)"CNY"));
        DataSet dataSet = ORM.create().queryDataSet(this.algoKey, "yem_ca_cusdec", String.join((CharSequence)",", selectFields), qFilter.toArray(new QFilter[0]));
        dataSet = dataSet.select("TO_CHAR(yem_fiedatets, 'MM') date, yem_sumlocdecltotal / 10000 amount, yem_agentname").groupBy(new String[]{"date", "yem_agentname"}).sum("amount").finish();
        dataSet = dataSet.orderBy(new String[]{"amount"});
        dataSet = RptUtil.zeroNullNums((DataSet)dataSet);
        DynamicObjectCollection dataList = ORM.create().toPlainDynamicObjectCollection(dataSet);
        Set topThreeNames = dataList.stream().filter(obj -> obj.getBigDecimal("amount").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.groupingBy(obj -> obj.getString("yem_agentname"), Collectors.counting())).entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(3L).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashMap<String, Map<String, BigDecimal>> result = new LinkedHashMap<String, Map<String, BigDecimal>>();
        for (int month = 1; month <= 12; ++month) {
            int finalMonth = month;
            Map<String, BigDecimal> monthData = dataList.stream().filter(data -> data.getInt("date") == finalMonth).filter(data -> topThreeNames.contains(data.getString("yem_agentname"))).collect(Collectors.toMap(d -> d.getString("yem_agentname"), d -> d.getBigDecimal("amount").setScale(2, RoundingMode.HALF_UP), (existing, replacement) -> existing));
            result.put(String.valueOf(month), monthData);
        }
        return result;
    }
}

